/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.glowroot.GlowrootModule;
import org.glowroot.MainEntryPoint;
import org.glowroot.common.SpyingLogbackFilter;
import org.glowroot.container.AppUnderTest;
import org.glowroot.container.Threads;
import org.glowroot.container.impl.SocketCommander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketCommandProcessor
implements Runnable {
    public static final String EXECUTE_APP = "EXECUTE_APP";
    public static final String GET_PORT = "GET_PORT";
    public static final String ADD_EXPECTED_LOG_MESSAGE = "ADD_EXPECTED_LOG_MESSAGE";
    public static final String CLEAR_LOG_MESSAGES = "CLEAR_LOG_MESSAGES";
    public static final String EXCEPTION_RESPONSE = "EXCEPTION";
    public static final String SHUTDOWN = "SHUTDOWN";
    public static final String KILL = "KILL";
    public static final String INTERRUPT = "INTERRUPT";
    public static final String STARTUP_FAILED = "STARTUP_FAILED";
    private static final Logger logger = LoggerFactory.getLogger(SocketCommandProcessor.class);
    private final ObjectInputStream objectIn;
    private final ObjectOutputStream objectOut;
    private final ExecutorService executorService;
    private final List<Thread> executingAppThreads = Lists.newCopyOnWriteArrayList();
    private final Set<Thread> preExistingThreads;

    SocketCommandProcessor(ObjectInputStream objectIn, ObjectOutputStream objectOut) {
        this.objectIn = objectIn;
        this.objectOut = objectOut;
        this.executorService = Executors.newCachedThreadPool();
        this.preExistingThreads = Sets.newHashSet(Threads.currentThreads());
    }

    @Override
    public void run() {
        this.preExistingThreads.add(Thread.currentThread());
        try {
            while (true) {
                this.readCommandAndSpawnHandlerThread();
            }
        }
        catch (EOFException e) {
            SocketCommandProcessor.terminateJvm(0);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            SocketCommandProcessor.terminateJvm(1);
        }
    }

    private void readCommandAndSpawnHandlerThread() throws Exception {
        final SocketCommander.CommandWrapper commandWrapper = (SocketCommander.CommandWrapper)this.objectIn.readObject();
        logger.debug("command received by external jvm: {}", (Object)commandWrapper);
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                SocketCommandProcessor.this.preExistingThreads.add(Thread.currentThread());
                try {
                    SocketCommandProcessor.this.runCommandAndRespond(commandWrapper);
                }
                catch (EOFException e) {
                    SocketCommandProcessor.terminateJvm(0);
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                    SocketCommandProcessor.terminateJvm(1);
                }
            }
        });
    }

    private void runCommandAndRespond(SocketCommander.CommandWrapper commandWrapper) throws Exception {
        try {
            this.runCommandAndRespondInternal(commandWrapper);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            this.respond(EXCEPTION_RESPONSE, commandWrapper.getCommandNum());
        }
    }

    private void runCommandAndRespondInternal(SocketCommander.CommandWrapper commandWrapper) throws Exception {
        String commandName = commandWrapper.getCommandName();
        ImmutableList<Object> args = commandWrapper.getArgs();
        int commandNum = commandWrapper.getCommandNum();
        if (commandName.equals(GET_PORT)) {
            this.respondWithPort(commandNum);
        } else if (commandName.equals(CLEAR_LOG_MESSAGES)) {
            this.respond(SpyingLogbackFilter.clearMessages(), commandNum);
        } else if (commandName.equals(KILL)) {
            SocketCommandProcessor.terminateJvm(0);
        } else if (commandName.equals(SHUTDOWN)) {
            this.shutdown(commandNum);
            SocketCommandProcessor.terminateJvm(0);
        } else if (commandName.equals(INTERRUPT)) {
            this.interruptAppAndRespond(commandNum);
        } else if (commandName.equals(EXECUTE_APP)) {
            this.executeAppAndRespond(commandNum, (List<Object>)args);
        } else if (commandName.equals(ADD_EXPECTED_LOG_MESSAGE)) {
            this.addExpectedMessageAndRespond(commandNum, (List<Object>)args);
        } else {
            logger.error("unexpected command: {}", (Object)commandName);
            this.respond(EXCEPTION_RESPONSE, commandNum);
        }
    }

    private void respondWithPort(int commandNum) throws Exception {
        GlowrootModule glowrootModule = MainEntryPoint.getGlowrootModule();
        if (glowrootModule == null) {
            this.respond(STARTUP_FAILED, commandNum);
        } else {
            this.respond(glowrootModule.getUiModule().getPort(), commandNum);
        }
    }

    private void shutdown(int commandNum) throws Exception {
        this.executorService.shutdown();
        GlowrootModule glowrootModule = MainEntryPoint.getGlowrootModule();
        if (glowrootModule == null) {
            this.respond(STARTUP_FAILED, commandNum);
            return;
        }
        Threads.preShutdownCheck(this.preExistingThreads);
        glowrootModule.close();
        Threads.postShutdownCheck(this.preExistingThreads);
        this.respond(null, commandNum);
    }

    private void interruptAppAndRespond(int commandNum) throws Exception {
        for (Thread thread : this.executingAppThreads) {
            thread.interrupt();
        }
        this.respond(null, commandNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAppAndRespond(int commandNum, List<Object> args) throws Exception {
        String appClassName = (String)args.get(0);
        Class<?> appClass = Class.forName(appClassName);
        try {
            this.executingAppThreads.add(Thread.currentThread());
            AppUnderTest app = (AppUnderTest)appClass.newInstance();
            app.executeApp();
            this.respond(null, commandNum);
        }
        finally {
            this.executingAppThreads.remove(Thread.currentThread());
        }
    }

    private void addExpectedMessageAndRespond(int commandNum, List<Object> args) throws Exception {
        String loggerName = (String)args.get(0);
        String partialMessage = (String)args.get(1);
        SpyingLogbackFilter.addExpectedMessage(loggerName, partialMessage);
        this.respond(null, commandNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respond(@Nullable Object response, int commandNum) throws Exception {
        SocketCommander.ResponseWrapper responseWrapper = new SocketCommander.ResponseWrapper(commandNum, response);
        logger.debug("sending response to unit test jvm: {}", (Object)responseWrapper);
        ObjectOutputStream objectOutputStream = this.objectOut;
        synchronized (objectOutputStream) {
            this.objectOut.writeObject(responseWrapper);
            logger.debug("response sent");
        }
    }

    private static void terminateJvm(int status) {
        System.exit(status);
    }
}

