/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.trace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class ProfileNode {
    @Nullable
    private final String stackTraceElement;
    @Nullable
    private final String leafThreadState;
    private final int sampleCount;
    private final ImmutableList<String> timerNames;
    private final ImmutableList<ProfileNode> childNodes;

    private ProfileNode(@Nullable String stackTraceElement, @Nullable String leafThreadState, int sampleCount, List<String> timerNames, List<ProfileNode> childNodes) {
        this.stackTraceElement = stackTraceElement;
        this.leafThreadState = leafThreadState;
        this.sampleCount = sampleCount;
        this.timerNames = ImmutableList.copyOf(timerNames);
        this.childNodes = ImmutableList.copyOf(childNodes);
    }

    @Nullable
    public String getStackTraceElement() {
        return this.stackTraceElement;
    }

    @Nullable
    public String getLeafThreadState() {
        return this.leafThreadState;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public ImmutableList<String> getTimerNames() {
        return this.timerNames;
    }

    public ImmutableList<ProfileNode> getChildNodes() {
        return this.childNodes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stackTraceElement", (Object)this.stackTraceElement).add("leafThreadState", (Object)this.leafThreadState).add("sampleCount", this.sampleCount).add("timerNames", this.timerNames).add("childNodes", this.childNodes).toString();
    }

    @JsonCreator
    static ProfileNode readValue(@JsonProperty(value="stackTraceElement") @Nullable String stackTraceElement, @JsonProperty(value="leafThreadState") @Nullable String leafThreadState, @JsonProperty(value="sampleCount") @Nullable Integer sampleCount, @JsonProperty(value="timerNames") @Nullable List<String> uncheckedTimerNames, @JsonProperty(value="childNodes") @Nullable List<ProfileNode> uncheckedChildNodes) throws JsonMappingException {
        List<String> timerNames = ObjectMappers.orEmpty(uncheckedTimerNames, "timerNames");
        List<ProfileNode> childNodes = ObjectMappers.orEmpty(uncheckedChildNodes, "childNodes");
        ObjectMappers.checkRequiredProperty(sampleCount, "sampleCount");
        return new ProfileNode(stackTraceElement, leafThreadState, sampleCount, timerNames, childNodes);
    }
}

