/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.trace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

class TracePointResponse {
    private final ImmutableList<RawPoint> normalPoints;
    private final ImmutableList<RawPoint> errorPoints;
    private final ImmutableList<RawPoint> activePoints;

    private TracePointResponse(List<RawPoint> normalPoints, List<RawPoint> errorPoints, List<RawPoint> activePoints) {
        this.normalPoints = ImmutableList.copyOf(normalPoints);
        this.errorPoints = ImmutableList.copyOf(errorPoints);
        this.activePoints = ImmutableList.copyOf(activePoints);
    }

    List<RawPoint> getNormalPoints() {
        return this.normalPoints;
    }

    List<RawPoint> getErrorPoints() {
        return this.errorPoints;
    }

    List<RawPoint> getActivePoints() {
        return this.activePoints;
    }

    @JsonCreator
    static TracePointResponse readValue(@JsonProperty(value="normalPoints") @Nullable List<RawPoint> uncheckedNormalPoints, @JsonProperty(value="errorPoints") @Nullable List<RawPoint> uncheckedErrorPoints, @JsonProperty(value="activePoints") @Nullable List<RawPoint> uncheckedActivePoints) throws JsonMappingException {
        List<RawPoint> normalPoints = ObjectMappers.orEmpty(uncheckedNormalPoints, "normalPoints");
        List<RawPoint> errorPoints = ObjectMappers.orEmpty(uncheckedErrorPoints, "errorPoints");
        List<RawPoint> activePoints = ObjectMappers.orEmpty(uncheckedActivePoints, "activePoints");
        return new TracePointResponse(normalPoints, errorPoints, activePoints);
    }

    static class RawPoint {
        static final Ordering<RawPoint> orderingByCaptureTime = new Ordering<RawPoint>(){

            public int compare(@Nullable RawPoint left, @Nullable RawPoint right) {
                Preconditions.checkNotNull((Object)left);
                Preconditions.checkNotNull((Object)right);
                return Longs.compare((long)left.captureTime, (long)right.captureTime);
            }
        };
        private final long captureTime;
        private final String id;

        private RawPoint(long captureTime, String id) {
            this.captureTime = captureTime;
            this.id = id;
        }

        String getId() {
            return this.id;
        }

        @JsonCreator
        static RawPoint readValue(ArrayNode point) {
            long captureTime = point.get(0).asLong();
            String id = point.get(2).asText();
            return new RawPoint(captureTime, id);
        }
    }
}

