/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.jvm;

import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.glowroot.jvm.LazyPlatformMBeanServer;
import org.glowroot.jvm.OptionalService;
import org.glowroot.shaded.google.common.base.Supplier;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class HeapDumps {
    private static final String MBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final Logger logger = LoggerFactory.getLogger(HeapDumps.class);
    private final LazyPlatformMBeanServer lazyPlatformMBeanServer;
    private final ObjectName objectName;

    private HeapDumps(LazyPlatformMBeanServer lazyPlatformMBeanServer, ObjectName objectName) {
        this.lazyPlatformMBeanServer = lazyPlatformMBeanServer;
        this.objectName = objectName;
    }

    public void dumpHeap(String path) throws Exception {
        this.lazyPlatformMBeanServer.invoke(this.objectName, "dumpHeap", new Object[]{path, false}, new String[]{"java.lang.String", "boolean"});
    }

    static OptionalService<HeapDumps> create(final LazyPlatformMBeanServer lazyPlatformMBeanServer) {
        ObjectName objectName;
        try {
            objectName = ObjectName.getInstance(MBEAN_NAME);
        }
        catch (MalformedObjectNameException e) {
            logger.error(e.getMessage(), e);
            return OptionalService.unavailable("<see error log for detail>");
        }
        return OptionalService.lazy(new Supplier<OptionalService<HeapDumps>>(){

            @Override
            public OptionalService<HeapDumps> get() {
                try {
                    lazyPlatformMBeanServer.getObjectInstance(objectName);
                }
                catch (InstanceNotFoundException e) {
                    logger.debug(e.getMessage(), e);
                    return OptionalService.unavailable("No such MBean com.sun.management:type=HotSpotDiagnostic (introduced in Oracle Java SE 6)");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    return OptionalService.unavailable("<see error log for detail>");
                }
                return OptionalService.available(new HeapDumps(lazyPlatformMBeanServer, objectName));
            }
        });
    }
}

