/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.common.Styles;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.GaugeMeta;
import org.glowroot.local.store.Index;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.cache.Cache;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.immutables.value.Value;

class GaugeMetaDao {
    private static final ImmutableList<Column> gaugeColumns = ImmutableList.of(Column.of("id", -5).withIdentity(true), Column.of("name", 12), Column.of("ever_increasing", 16));
    private static final ImmutableList<Index> gaugeIndexes = ImmutableList.of(Index.of("gauge_meta_idx", ImmutableList.of("name")));
    private final Cache<String, GaugeMeta> gaugeMetas = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private final DataSource dataSource;
    private final Object lock = new Object();

    GaugeMetaDao(DataSource dataSource) throws SQLException {
        this.dataSource = dataSource;
        dataSource.renameTable("gauge", "gauge_meta");
        dataSource.syncTable("gauge_meta", gaugeColumns);
        dataSource.syncIndexes("gauge_meta", gaugeIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getOrCreateGaugeMetaId(String gaugeName, boolean everIncreasing) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            GaugeMeta gaugeMeta = this.gaugeMetas.getIfPresent(gaugeName);
            if (gaugeMeta != null) {
                if (gaugeMeta.everIncreasing() != everIncreasing) {
                    this.dataSource.update("update gauge_meta set ever_increasing = ? where name = ?", everIncreasing, gaugeName);
                    this.gaugeMetas.put(gaugeName, gaugeMeta.withEverIncreasing(everIncreasing));
                }
                return gaugeMeta.id();
            }
            gaugeMeta = this.readGaugeMeta(gaugeName);
            if (gaugeMeta != null) {
                return gaugeMeta.id();
            }
            this.dataSource.update("insert into gauge_meta (name, ever_increasing) values (?, ?)", gaugeName, everIncreasing);
            gaugeMeta = this.readGaugeMeta(gaugeName);
            Preconditions.checkNotNull(gaugeMeta);
            this.gaugeMetas.put(gaugeName, gaugeMeta);
            return gaugeMeta.id();
        }
    }

    @Nullable
    Long getGaugeMetaId(String gaugeName) throws SQLException {
        GaugeMeta gaugeMeta = this.gaugeMetas.getIfPresent(gaugeName);
        if (gaugeMeta != null) {
            return gaugeMeta.id();
        }
        gaugeMeta = this.readGaugeMeta(gaugeName);
        if (gaugeMeta == null) {
            return null;
        }
        this.gaugeMetas.put(gaugeName, gaugeMeta);
        return gaugeMeta.id();
    }

    @Nullable
    private GaugeMeta readGaugeMeta(String gaugeName) throws SQLException {
        ImmutableList<GaugeMeta> gaugeMetas = this.dataSource.query("select id, ever_increasing from gauge_meta where name = ?", new GaugeMetaRowMapper(), gaugeName);
        if (gaugeMetas.isEmpty()) {
            return null;
        }
        Preconditions.checkState(gaugeMetas.size() == 1);
        return (GaugeMeta)gaugeMetas.get(0);
    }

    private static class GaugeMetaRowMapper
    implements DataSource.RowMapper<GaugeMeta> {
        private GaugeMetaRowMapper() {
        }

        @Override
        public GaugeMeta mapRow(ResultSet resultSet) throws SQLException {
            long id = resultSet.getLong(1);
            boolean everIncreasing = resultSet.getBoolean(2);
            return GaugeMeta.of(id, everIncreasing);
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    static abstract class GaugeMetaBase {
        GaugeMetaBase() {
        }

        abstract long id();

        abstract boolean everIncreasing();
    }
}

