/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.collector.GaugePoint;
import org.glowroot.collector.GaugePointRepository;
import org.glowroot.common.Checkers;
import org.glowroot.common.Clock;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.GaugeMetaDao;
import org.glowroot.local.store.Index;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;

public class GaugePointDao
implements GaugePointRepository {
    private static final ImmutableList<Column> gaugePointColumns = ImmutableList.of(Column.of("gauge_meta_id", -5), Column.of("capture_time", -5), Column.of("value", 8));
    private static final ImmutableList<Index> gaugePointIndexes = ImmutableList.of(Index.of("gauge_point_idx", ImmutableList.of("gauge_meta_id", "capture_time", "value")));
    private static final ImmutableList<Column> gaugePointRollupColumns = ImmutableList.of(Column.of("gauge_meta_id", -5), Column.of("capture_time", -5), Column.of("value", 8), Column.of("count", 8));
    private static final ImmutableList<Index> gaugePointRollup1Indexes = ImmutableList.of(Index.of("gauge_point_rollup_1_idx", ImmutableList.of("gauge_meta_id", "capture_time", "value")));
    private static final ImmutableList<Index> gaugePointRollup2Indexes = ImmutableList.of(Index.of("gauge_point_rollup_2_idx", ImmutableList.of("gauge_meta_id", "capture_time", "value")));
    private static final ImmutableList<Column> gaugePointLastRollupTimesColumns = ImmutableList.of(Column.of("last_rollup_1_time", -5), Column.of("last_rollup_2_time", -5));
    private final GaugeMetaDao gaugeMetaDao;
    private final DataSource dataSource;
    private final Clock clock;
    private final long fixedRollup1Millis;
    private final long fixedRollup2Millis;
    private final long rollup1ViewThresholdMillis;
    private final long rollup2ViewThresholdMillis;
    private volatile long lastRollup1Time;
    private volatile long lastRollup2Time;
    private final Object rollupLock = new Object();

    GaugePointDao(DataSource dataSource, Clock clock, long fixedRollup1Seconds, long fixedRollup2Seconds) throws SQLException {
        this.gaugeMetaDao = new GaugeMetaDao(dataSource);
        this.dataSource = dataSource;
        this.clock = clock;
        this.fixedRollup1Millis = fixedRollup1Seconds * 1000L;
        this.fixedRollup2Millis = fixedRollup2Seconds * 1000L;
        this.rollup1ViewThresholdMillis = this.fixedRollup1Millis * 15L;
        this.rollup2ViewThresholdMillis = this.fixedRollup2Millis * 16L;
        dataSource.renameColumn("gauge_point", "gauge_id", "gauge_meta_id");
        dataSource.renameColumn("gauge_point_rollup_1", "gauge_id", "gauge_meta_id");
        dataSource.syncTable("gauge_point", gaugePointColumns);
        dataSource.syncIndexes("gauge_point", gaugePointIndexes);
        dataSource.syncTable("gauge_point_rollup_1", gaugePointRollupColumns);
        dataSource.syncIndexes("gauge_point_rollup_1", gaugePointRollup1Indexes);
        dataSource.syncTable("gauge_point_rollup_2", gaugePointRollupColumns);
        dataSource.syncIndexes("gauge_point_rollup_2", gaugePointRollup2Indexes);
        dataSource.syncTable("gauge_point_last_rollup_times", gaugePointLastRollupTimesColumns);
        Long[] lastRollupTimes = dataSource.query("select last_rollup_1_time, last_rollup_2_time from gauge_point_last_rollup_times", new LastRollupTimesExtractor(), new Object[0]);
        if (lastRollupTimes == null) {
            this.lastRollup1Time = dataSource.queryForLong("select ifnull(max(capture_time), 0) from gauge_point_rollup_1", new Object[0]);
            this.lastRollup2Time = dataSource.queryForLong("select ifnull(max(capture_time), 0) from gauge_point_rollup_2", new Object[0]);
            dataSource.update("insert into gauge_point_last_rollup_times (last_rollup_1_time, last_rollup_2_time) values (?, ?)", this.lastRollup1Time, this.lastRollup2Time);
        } else {
            this.lastRollup1Time = lastRollupTimes[0];
            this.lastRollup2Time = lastRollupTimes[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(final List<GaugePoint> gaugePoints) throws Exception {
        if (gaugePoints.isEmpty()) {
            return;
        }
        this.dataSource.batchUpdate("insert into gauge_point (gauge_meta_id, capture_time, value) values (?, ?, ?)", new DataSource.BatchAdder(){

            @Override
            public void addBatches(PreparedStatement preparedStatement) throws SQLException {
                for (GaugePoint gaugePoint : gaugePoints) {
                    Boolean everIncreasing = gaugePoint.everIncreasing();
                    Preconditions.checkNotNull(everIncreasing);
                    long gaugeMetaId = GaugePointDao.this.gaugeMetaDao.getOrCreateGaugeMetaId(gaugePoint.gaugeName(), everIncreasing);
                    preparedStatement.setLong(1, gaugeMetaId);
                    preparedStatement.setLong(2, gaugePoint.captureTime());
                    preparedStatement.setDouble(3, gaugePoint.value());
                    preparedStatement.addBatch();
                }
            }
        });
        Object object = this.rollupLock;
        synchronized (object) {
            long safeRollup2Time;
            long safeRollupTime = this.clock.currentTimeMillis() - 1L;
            long safeRollup1Time = (long)Math.floor((double)safeRollupTime / (double)this.fixedRollup1Millis) * this.fixedRollup1Millis;
            if (safeRollup1Time > this.lastRollup1Time) {
                this.rollup(this.lastRollup1Time, safeRollup1Time, this.fixedRollup1Millis, "_rollup_1", "");
                this.dataSource.update("update gauge_point_last_rollup_times set last_rollup_1_time = ?", this.lastRollup1Time);
                this.lastRollup1Time = safeRollup1Time;
            }
            if ((safeRollup2Time = (long)Math.floor((double)safeRollupTime / (double)this.fixedRollup2Millis) * this.fixedRollup2Millis) > this.lastRollup2Time) {
                this.rollup(this.lastRollup2Time, safeRollup2Time, this.fixedRollup2Millis, "_rollup_2", "_rollup_1");
                this.dataSource.update("update gauge_point_last_rollup_times set last_rollup_2_time = ?", this.lastRollup2Time);
                this.lastRollup2Time = safeRollup2Time;
            }
        }
    }

    public ImmutableList<GaugePoint> readGaugePoints(String gaugeName, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        Long gaugeMetaId;
        String tableName = "gauge_point";
        if (rollupLevel > 0) {
            tableName = tableName + "_rollup_" + Checkers.castUntainted(rollupLevel);
        }
        if ((gaugeMetaId = this.gaugeMetaDao.getGaugeMetaId(gaugeName)) == null) {
            return ImmutableList.of();
        }
        return this.dataSource.query("select capture_time, value from " + tableName + " where gauge_meta_id = ? and capture_time >= ? and capture_time <= ?" + " order by capture_time", new GaugePointRowMapper(gaugeName), gaugeMetaId, captureTimeFrom, captureTimeTo);
    }

    public int getRollupLevelForView(long from, long to) {
        long millis = to - from;
        if (millis >= this.rollup2ViewThresholdMillis) {
            return 2;
        }
        if (millis >= this.rollup1ViewThresholdMillis) {
            return 1;
        }
        return 0;
    }

    public void deleteAll() throws SQLException {
        this.dataSource.execute("truncate table gauge_point");
        this.dataSource.execute("truncate table gauge_point_rollup_1");
        this.dataSource.execute("truncate table gauge_point_rollup_2");
    }

    void deleteBefore(long captureTime) throws SQLException {
        this.dataSource.deleteBefore("gauge_point", captureTime);
        this.dataSource.deleteBefore("gauge_point_rollup_1", captureTime);
        this.dataSource.deleteBefore("gauge_point_rollup_2", captureTime);
    }

    private void rollup(long lastRollupTime, long safeRollupTime, long fixedRollupMillis, @Untainted String rollupSuffix, @Untainted String sourceSuffix) throws SQLException {
        String captureTimeSql = Checkers.castUntainted("ceil(capture_time / " + fixedRollupMillis + ".0) * " + fixedRollupMillis);
        this.rollup(lastRollupTime, safeRollupTime, captureTimeSql, false, rollupSuffix, sourceSuffix);
        this.rollup(lastRollupTime, safeRollupTime, captureTimeSql, true, rollupSuffix, sourceSuffix);
    }

    private void rollup(long lastRollupTime, long safeRollupTime, @Untainted String captureTimeSql, boolean everIncreasing, @Untainted String rollupSuffix, @Untainted String sourceSuffix) throws SQLException {
        String aggregateFunction = everIncreasing ? "max" : "avg";
        this.dataSource.update("insert into gauge_point" + rollupSuffix + " (gauge_meta_id, capture_time, value, count) select gauge_meta_id, " + captureTimeSql + " ceil_capture_time, " + aggregateFunction + "(value), count(*) from gauge_point" + sourceSuffix + " gp, gauge_meta gm" + " where gp.capture_time > ? and gp.capture_time <= ?" + " and gp.gauge_meta_id = gm.id and gm.ever_increasing = ?" + " group by gp.gauge_meta_id, ceil_capture_time", lastRollupTime, safeRollupTime, everIncreasing);
    }

    private static class GaugePointRowMapper
    implements DataSource.RowMapper<GaugePoint> {
        private final String gaugeName;

        public GaugePointRowMapper(String gaugeName) {
            this.gaugeName = gaugeName;
        }

        @Override
        public GaugePoint mapRow(ResultSet resultSet) throws SQLException {
            long captureTime = resultSet.getLong(1);
            double value = resultSet.getDouble(2);
            return GaugePoint.builder().gaugeName(this.gaugeName).captureTime(captureTime).value(value).build();
        }
    }

    private static class LastRollupTimesExtractor
    implements DataSource.ResultSetExtractor<Long[]> {
        private LastRollupTimesExtractor() {
        }

        @Override
        public Long[] extractData(ResultSet resultSet) throws Exception {
            if (resultSet.next()) {
                return new Long[]{resultSet.getLong(1), resultSet.getLong(2)};
            }
            return null;
        }
    }
}

