/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.local.store.Schemas;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class Index
extends Schemas.IndexBase {
    private final String name;
    private final ImmutableList<String> columns;

    private Index(String name, Iterable<String> columns) {
        this.name = Preconditions.checkNotNull(name);
        this.columns = ImmutableList.copyOf(columns);
    }

    private Index(Index original, String name, ImmutableList<String> columns) {
        this.name = name;
        this.columns = columns;
    }

    @Override
    @JsonProperty(value="name")
    @Untainted
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="columns")
    public ImmutableList<String> columns() {
        return this.columns;
    }

    public final Index withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Index(this, newValue, this.columns);
    }

    public final Index withColumns(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Index(this, this.name, newValue);
    }

    public final Index withColumns(Iterable<String> elements) {
        if (this.columns == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Index(this, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Index && this.equalTo((Index)another);
    }

    private boolean equalTo(Index another) {
        return this.name.equals(another.name) && this.columns.equals(another.columns);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.columns.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Index").add("name", this.name).add("columns", this.columns).toString();
    }

    @JsonCreator
    public static Index fromAllAttributes(@JsonProperty(value="name") @Nullable @Untainted String name, @JsonProperty(value="columns") @Nullable ImmutableList<String> columns) {
        Builder builder = Index.builder();
        if (name != null) {
            builder.name(name);
        }
        if (columns != null) {
            builder.addAllColumns(columns);
        }
        return builder.build();
    }

    public static Index of(String name, ImmutableList<String> columns) {
        return Index.of(name, columns);
    }

    public static Index of(String name, Iterable<String> columns) {
        return new Index(name, columns);
    }

    static Index copyOf(Schemas.IndexBase instance) {
        if (instance instanceof Index) {
            return (Index)instance;
        }
        return Index.builder().name(instance.name()).addAllColumns(instance.columns()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private long initializedBitset;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> columnsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder name(String name) {
            this.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addColumns(String element) {
            this.columnsBuilder.add((Object)element);
            return this;
        }

        public final Builder addColumns(String ... elements) {
            this.columnsBuilder.add(elements);
            return this;
        }

        public final Builder addAllColumns(Iterable<String> elements) {
            this.columnsBuilder.addAll((Iterable)elements);
            return this;
        }

        public Index build() {
            this.checkRequiredAttributes();
            return new Index(null, this.name, (ImmutableList)this.columnsBuilder.build());
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Index is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build Index, some of required attributes are not set " + attributes;
        }
    }
}

