/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.List;
import org.glowroot.shaded.google.common.collect.ImmutableList;

public class QueryResult<T> {
    private final List<T> records;
    private final boolean moreAvailable;

    public QueryResult(List<T> records, boolean moreAvailable) {
        this.records = records;
        this.moreAvailable = moreAvailable;
    }

    public List<T> records() {
        return this.records;
    }

    public boolean moreAvailable() {
        return this.moreAvailable;
    }

    static <T> QueryResult<T> from(ImmutableList<T> records, int limit) {
        if (limit == 0) {
            return new QueryResult<T>(records, false);
        }
        if (records.size() > limit) {
            return new QueryResult<T>(records.subList(0, limit), true);
        }
        return new QueryResult<T>(records, false);
    }
}

