/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.glowroot.collector.Existence;
import org.glowroot.local.store.CappedDatabase;

class RowMappers {
    private RowMappers() {
    }

    @Nullable
    static Long getLong(ResultSet resultSet, int columnIndex) throws SQLException {
        long value = resultSet.getLong(columnIndex);
        if (resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    static void setLong(PreparedStatement preparedStatement, int columnIndex, @Nullable Long value) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(columnIndex, -5);
        } else {
            preparedStatement.setLong(columnIndex, value);
        }
    }

    static Existence getExistence(ResultSet resultSet, int columnIndex, CappedDatabase cappedDatabase) throws SQLException {
        long cappedId = resultSet.getLong(columnIndex);
        if (resultSet.wasNull()) {
            return Existence.NO;
        }
        if (cappedDatabase.isExpired(cappedId)) {
            return Existence.EXPIRED;
        }
        return Existence.YES;
    }
}

