/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.collector.Trace;
import org.glowroot.collector.TraceRepository;
import org.glowroot.common.Checkers;
import org.glowroot.common.ChunkSource;
import org.glowroot.local.store.CappedDatabase;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.ErrorMessageCount;
import org.glowroot.local.store.ErrorMessageQuery;
import org.glowroot.local.store.Index;
import org.glowroot.local.store.ParameterizedSql;
import org.glowroot.local.store.QueryResult;
import org.glowroot.local.store.RowMappers;
import org.glowroot.local.store.TraceErrorPoint;
import org.glowroot.local.store.TracePoint;
import org.glowroot.local.store.TracePointQuery;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSetMultimap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class TraceDao
implements TraceRepository {
    private static final Logger logger = LoggerFactory.getLogger(TraceDao.class);
    private static final ImmutableList<Column> traceColumns = ImmutableList.of(Column.of("id", 12).withPrimaryKey(true), Column.of("partial", -5), Column.of("error", 16), Column.of("start_time", -5), Column.of("capture_time", -5), Column.of("duration", -5), Column.of("transaction_type", 12), Column.of("transaction_name", 12), Column.of("headline", 12), Column.of("user", 12), Column.of("custom_attributes", 12), Column.of("custom_detail", 12), new Column[]{Column.of("error_message", 12), Column.of("error_throwable", 12), Column.of("timers", 12), Column.of("thread_cpu_time", -5), Column.of("thread_blocked_time", -5), Column.of("thread_waited_time", -5), Column.of("thread_allocated_bytes", -5), Column.of("gc_infos", 12), Column.of("entry_count", -5), Column.of("entries_capped_id", 12), Column.of("profile_sample_count", -5), Column.of("profile_capped_id", 12)});
    private static final ImmutableList<Column> transactionCustomAttributeColumns = ImmutableList.of(Column.of("trace_id", 12), Column.of("name", 12), Column.of("value", 12), Column.of("capture_time", -5));
    private static final ImmutableList<Index> traceIndexes = ImmutableList.of(Index.of("trace_idx", ImmutableList.of("capture_time", "transaction_type", "duration", "id", "error")), Index.of("trace_error_message_idx", ImmutableList.of("error", "capture_time", "transaction_type", "transaction_name", "error_message")), Index.of("trace_transaction_count_idx", ImmutableList.of("transaction_type", "transaction_name", "capture_time")), Index.of("trace_overall_count_idx", ImmutableList.of("transaction_type", "capture_time")));
    private final DataSource dataSource;
    private final CappedDatabase cappedDatabase;

    TraceDao(DataSource dataSource, CappedDatabase cappedDatabase) throws SQLException {
        this.dataSource = dataSource;
        this.cappedDatabase = cappedDatabase;
        TraceDao.upgradeTraceTable(dataSource);
        dataSource.syncTable("trace", traceColumns);
        dataSource.syncIndexes("trace", traceIndexes);
        dataSource.syncTable("trace_custom_attribute", transactionCustomAttributeColumns);
    }

    @Override
    public void store(final Trace trace, @Nullable ChunkSource entries, @Nullable ChunkSource profile) throws Exception {
        Long entriesId = null;
        if (entries != null) {
            entriesId = this.cappedDatabase.write(entries, "trace entries");
        }
        Long profileId = null;
        if (profile != null) {
            profileId = this.cappedDatabase.write(profile, "trace profiles");
        }
        this.dataSource.update("merge into trace (id, partial, error, start_time, capture_time, duration, transaction_type, transaction_name, headline, user, custom_attributes, custom_detail, error_message, error_throwable, timers, thread_cpu_time, thread_blocked_time, thread_waited_time, thread_allocated_bytes, gc_infos, entry_count, entries_capped_id, profile_sample_count, profile_capped_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", trace.id(), trace.partial(), trace.error(), trace.startTime(), trace.captureTime(), trace.duration(), trace.transactionType(), trace.transactionName(), trace.headline(), trace.user(), trace.customAttributes(), trace.customDetail(), trace.errorMessage(), trace.errorThrowable(), trace.timers(), trace.threadCpuTime(), trace.threadBlockedTime(), trace.threadWaitedTime(), trace.threadAllocatedBytes(), trace.gcInfos(), trace.entryCount(), entriesId, trace.profileSampleCount(), profileId);
        final ImmutableSetMultimap<String, String> customAttributesForIndexing = trace.customAttributesForIndexing();
        if (!customAttributesForIndexing.isEmpty()) {
            this.dataSource.batchUpdate("insert into trace_custom_attribute (trace_id, name, value, capture_time) values (?, ?, ?, ?)", new DataSource.BatchAdder(){

                @Override
                public void addBatches(PreparedStatement preparedStatement) throws SQLException {
                    for (Map.Entry entry : customAttributesForIndexing.entries()) {
                        preparedStatement.setString(1, trace.id());
                        preparedStatement.setString(2, (String)entry.getKey());
                        preparedStatement.setString(3, (String)entry.getValue());
                        preparedStatement.setLong(4, trace.captureTime());
                        preparedStatement.addBatch();
                    }
                }
            });
        }
    }

    public QueryResult<TracePoint> readPoints(TracePointQuery query) throws SQLException {
        ParameterizedSql parameterizedSql = query.getParameterizedSql();
        ImmutableList<TracePoint> points = this.dataSource.query(parameterizedSql.sql(), new TracePointRowMapper(), parameterizedSql.argsAsArray());
        return QueryResult.from(points, query.limit());
    }

    public long readTransactionCount(String transactionType, String transactionName, long captureTimeFrom, long captureTimeTo) throws SQLException {
        return this.dataSource.queryForLong("select count(*) from trace where transaction_type = ? and transaction_name = ? and capture_time >= ? and capture_time <= ?", transactionType, transactionName, captureTimeFrom, captureTimeTo);
    }

    public long readOverallCount(String transactionType, long captureTimeFrom, long captureTimeTo) throws SQLException {
        return this.dataSource.queryForLong("select count(*) from trace where transaction_type = ? and capture_time >= ? and capture_time <= ?", transactionType, captureTimeFrom, captureTimeTo);
    }

    public long readTransactionErrorCount(String transactionType, String transactionName, long captureTimeFrom, long captureTimeTo) throws SQLException {
        return this.dataSource.queryForLong("select count(*) from trace where transaction_type = ? and transaction_name = ? and capture_time >= ? and capture_time <= ? and error = ?", transactionType, transactionName, captureTimeFrom, captureTimeTo, true);
    }

    public long readOverallErrorCount(String transactionType, long captureTimeFrom, long captureTimeTo) throws SQLException {
        return this.dataSource.queryForLong("select count(*) from trace where transaction_type = ? and capture_time >= ? and capture_time <= ? and error = ?", transactionType, captureTimeFrom, captureTimeTo, true);
    }

    public ImmutableList<TraceErrorPoint> readErrorPoints(ErrorMessageQuery query, long resolutionMillis, long liveCaptureTime) throws SQLException {
        String captureTimeSql = Checkers.castUntainted("ceil(capture_time / " + resolutionMillis + ".0) * " + resolutionMillis);
        ParameterizedSql parameterizedSql = this.buildErrorMessageQuery(query, "select " + captureTimeSql + ", count(*) from trace", "group by " + captureTimeSql + " order by " + captureTimeSql);
        return this.dataSource.query(parameterizedSql.sql(), new ErrorPointRowMapper(liveCaptureTime), parameterizedSql.argsAsArray());
    }

    public QueryResult<ErrorMessageCount> readErrorMessageCounts(ErrorMessageQuery query) throws SQLException {
        ParameterizedSql parameterizedSql = this.buildErrorMessageQuery(query, "select error_message, count(*) from trace", "group by error_message order by count(*) desc");
        ImmutableList<ErrorMessageCount> points = this.dataSource.query(parameterizedSql.sql(), new ErrorMessageCountRowMapper(), parameterizedSql.argsAsArray());
        return QueryResult.from(points, query.limit());
    }

    @Nullable
    public Trace readTrace(String traceId) throws SQLException {
        ImmutableList<Trace> traces = this.dataSource.query("select id, partial, error, start_time, capture_time, duration, transaction_type, transaction_name, headline, user, custom_attributes, custom_detail, error_message, error_throwable, timers, thread_cpu_time, thread_blocked_time, thread_waited_time, thread_allocated_bytes, gc_infos, entry_count, entries_capped_id, profile_sample_count, profile_capped_id from trace where id = ?", new TraceRowMapper(), traceId);
        if (traces.isEmpty()) {
            return null;
        }
        if (traces.size() > 1) {
            logger.error("multiple records returned for trace id: {}", (Object)traceId);
        }
        return (Trace)traces.get(0);
    }

    @Nullable
    public CharSource readEntries(String traceId) throws SQLException {
        return this.readFromCappedDatabase("entries_capped_id", traceId);
    }

    @Nullable
    public CharSource readProfile(String traceId) throws SQLException {
        return this.readFromCappedDatabase("profile_capped_id", traceId);
    }

    public void deleteAll() throws SQLException {
        this.dataSource.execute("truncate table trace_custom_attribute");
        this.dataSource.execute("truncate table trace");
    }

    void deleteBefore(long captureTime) throws SQLException {
        this.dataSource.deleteBefore("trace_custom_attribute", captureTime);
        this.dataSource.deleteBefore("trace", captureTime);
    }

    @Nullable
    private CharSource readFromCappedDatabase(@Untainted String columnName, String traceId) throws SQLException {
        return this.dataSource.query("select " + columnName + " from trace where id = ?", new CappedIdResultExtractor(), traceId);
    }

    @OnlyUsedByTests
    public long count() throws SQLException {
        return this.dataSource.queryForLong("select count(*) from trace", new Object[0]);
    }

    private ParameterizedSql buildErrorMessageQuery(ErrorMessageQuery query, @Untainted String selectClause, @Untainted String groupByClause) {
        String sql = selectClause;
        ArrayList<Object> args = Lists.newArrayList();
        sql = sql + " where error = ?";
        args.add(true);
        sql = sql + " and transaction_type = ?";
        args.add(query.transactionType());
        String transactionName = query.transactionName();
        if (transactionName != null) {
            sql = sql + " and transaction_name = ?";
            args.add(transactionName);
        }
        sql = sql + " and capture_time >= ? and capture_time <= ?";
        args.add(query.from());
        args.add(query.to());
        for (String include : query.includes()) {
            sql = sql + " and upper(error_message) like ?";
            args.add('%' + include.toUpperCase(Locale.ENGLISH) + '%');
        }
        for (String exclude : query.excludes()) {
            sql = sql + " and upper(error_message) not like ?";
            args.add('%' + exclude.toUpperCase(Locale.ENGLISH) + '%');
        }
        sql = sql + " " + groupByClause;
        return ParameterizedSql.of(sql, args);
    }

    private static void upgradeTraceTable(DataSource dataSource) throws SQLException {
        if (!dataSource.tableExists("trace")) {
            return;
        }
    }

    private static class ErrorMessageCountRowMapper
    implements DataSource.RowMapper<ErrorMessageCount> {
        private ErrorMessageCountRowMapper() {
        }

        @Override
        public ErrorMessageCount mapRow(ResultSet resultSet) throws SQLException {
            return ErrorMessageCount.builder().message(Strings.nullToEmpty(resultSet.getString(1))).count(resultSet.getLong(2)).build();
        }
    }

    private static class ErrorPointRowMapper
    implements DataSource.RowMapper<TraceErrorPoint> {
        private final long liveCaptureTime;

        private ErrorPointRowMapper(long liveCaptureTime) {
            this.liveCaptureTime = liveCaptureTime;
        }

        @Override
        public TraceErrorPoint mapRow(ResultSet resultSet) throws SQLException {
            long captureTime = Math.min(resultSet.getLong(1), this.liveCaptureTime);
            long errorCount = resultSet.getLong(2);
            return TraceErrorPoint.of(captureTime, errorCount);
        }
    }

    private class TraceRowMapper
    implements DataSource.RowMapper<Trace> {
        private TraceRowMapper() {
        }

        @Override
        public Trace mapRow(ResultSet resultSet) throws SQLException {
            int columnIndex = 1;
            String id = resultSet.getString(columnIndex++);
            Preconditions.checkNotNull(id);
            return Trace.builder().id(id).active(false).partial(resultSet.getBoolean(columnIndex++)).error(resultSet.getBoolean(columnIndex++)).startTime(resultSet.getLong(columnIndex++)).captureTime(resultSet.getLong(columnIndex++)).duration(resultSet.getLong(columnIndex++)).transactionType(Strings.nullToEmpty(resultSet.getString(columnIndex++))).transactionName(Strings.nullToEmpty(resultSet.getString(columnIndex++))).headline(Strings.nullToEmpty(resultSet.getString(columnIndex++))).user(resultSet.getString(columnIndex++)).customAttributes(resultSet.getString(columnIndex++)).customDetail(resultSet.getString(columnIndex++)).errorMessage(resultSet.getString(columnIndex++)).errorThrowable(resultSet.getString(columnIndex++)).timers(resultSet.getString(columnIndex++)).threadCpuTime(RowMappers.getLong(resultSet, columnIndex++)).threadBlockedTime(RowMappers.getLong(resultSet, columnIndex++)).threadWaitedTime(RowMappers.getLong(resultSet, columnIndex++)).threadAllocatedBytes(RowMappers.getLong(resultSet, columnIndex++)).gcInfos(resultSet.getString(columnIndex++)).entryCount(resultSet.getInt(columnIndex++)).entriesExistence(RowMappers.getExistence(resultSet, columnIndex++, TraceDao.this.cappedDatabase)).profileSampleCount(resultSet.getLong(columnIndex++)).profileExistence(RowMappers.getExistence(resultSet, columnIndex++, TraceDao.this.cappedDatabase)).build();
        }
    }

    private static class TracePointRowMapper
    implements DataSource.RowMapper<TracePoint> {
        private TracePointRowMapper() {
        }

        @Override
        public TracePoint mapRow(ResultSet resultSet) throws SQLException {
            String id = resultSet.getString(1);
            Preconditions.checkNotNull(id);
            return TracePoint.builder().id(id).captureTime(resultSet.getLong(2)).duration(resultSet.getLong(3)).error(resultSet.getBoolean(4)).build();
        }
    }

    private class CappedIdResultExtractor
    implements DataSource.ResultSetExtractor<CharSource> {
        private CappedIdResultExtractor() {
        }

        @Override
        @Nullable
        public CharSource extractData(ResultSet resultSet) throws SQLException {
            if (!resultSet.next()) {
                return CharSource.wrap("{\"expired\":true}");
            }
            long cappedId = resultSet.getLong(1);
            if (resultSet.wasNull()) {
                return null;
            }
            return TraceDao.this.cappedDatabase.read(cappedId, "{\"overwritten\":true}");
        }
    }
}

