/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.TraceErrorPointBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class TraceErrorPoint
extends TraceErrorPointBase {
    private final long captureTime;
    private final long errorCount;

    private TraceErrorPoint(long captureTime, long errorCount) {
        this.captureTime = captureTime;
        this.errorCount = errorCount;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="errorCount")
    public long errorCount() {
        return this.errorCount;
    }

    public final TraceErrorPoint withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        long newValue = value;
        return new TraceErrorPoint(newValue, this.errorCount);
    }

    public final TraceErrorPoint withErrorCount(long value) {
        if (this.errorCount == value) {
            return this;
        }
        long newValue = value;
        return new TraceErrorPoint(this.captureTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TraceErrorPoint && this.equalTo((TraceErrorPoint)another);
    }

    private boolean equalTo(TraceErrorPoint another) {
        return this.captureTime == another.captureTime && this.errorCount == another.errorCount;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.captureTime);
        h = h * 17 + Longs.hashCode(this.errorCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TraceErrorPoint").add("captureTime", this.captureTime).add("errorCount", this.errorCount).toString();
    }

    @JsonCreator
    public static TraceErrorPoint fromAllAttributes(@JsonProperty(value="captureTime") @Nullable Long captureTime, @JsonProperty(value="errorCount") @Nullable Long errorCount) {
        Builder builder = TraceErrorPoint.builder();
        if (captureTime != null) {
            builder.captureTime(captureTime);
        }
        if (errorCount != null) {
            builder.errorCount(errorCount);
        }
        return builder.build();
    }

    public static TraceErrorPoint of(long captureTime, long errorCount) {
        return new TraceErrorPoint(captureTime, errorCount);
    }

    public static TraceErrorPoint copyOf(TraceErrorPointBase instance) {
        if (instance instanceof TraceErrorPoint) {
            return (TraceErrorPoint)instance;
        }
        return TraceErrorPoint.builder().captureTime(instance.captureTime()).errorCount(instance.errorCount()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_CAPTURE_TIME = 1L;
        private static final long INITIALIZED_BIT_ERROR_COUNT = 2L;
        private long initializedBitset;
        private long captureTime;
        private long errorCount;

        private Builder() {
        }

        public final Builder captureTime(long captureTime) {
            this.checkNotIsSet(this.captureTimeIsSet(), "captureTime");
            this.captureTime = captureTime;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder errorCount(long errorCount) {
            this.checkNotIsSet(this.errorCountIsSet(), "errorCount");
            this.errorCount = errorCount;
            this.initializedBitset |= 2L;
            return this;
        }

        public TraceErrorPoint build() {
            this.checkRequiredAttributes();
            return new TraceErrorPoint(this.captureTime, this.errorCount);
        }

        private boolean captureTimeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean errorCountIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TraceErrorPoint is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.captureTimeIsSet()) {
                attributes.add("captureTime");
            }
            if (!this.errorCountIsSet()) {
                attributes.add("errorCount");
            }
            return "Cannot build TraceErrorPoint, some of required attributes are not set " + attributes;
        }
    }
}

