/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.AlertJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;

@ParametersAreNonnullByDefault
@Immutable
final class AlertConfigDto
extends AlertJsonService.AlertConfigDtoBase {
    private final String transactionType;
    private final double percentile;
    private final int timePeriodMinutes;
    private final int thresholdMillis;
    private final int minTransactionCount;
    private final ImmutableList<String> emailAddresses;
    @Nullable
    private final String version;

    private AlertConfigDto(String transactionType, double percentile, int timePeriodMinutes, int thresholdMillis, int minTransactionCount, ImmutableList<String> emailAddresses, @Nullable String version) {
        this.transactionType = transactionType;
        this.percentile = percentile;
        this.timePeriodMinutes = timePeriodMinutes;
        this.thresholdMillis = thresholdMillis;
        this.minTransactionCount = minTransactionCount;
        this.emailAddresses = emailAddresses;
        this.version = version;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="percentile")
    public double percentile() {
        return this.percentile;
    }

    @Override
    @JsonProperty(value="timePeriodMinutes")
    public int timePeriodMinutes() {
        return this.timePeriodMinutes;
    }

    @Override
    @JsonProperty(value="thresholdMillis")
    public int thresholdMillis() {
        return this.thresholdMillis;
    }

    @Override
    @JsonProperty(value="minTransactionCount")
    public int minTransactionCount() {
        return this.minTransactionCount;
    }

    @Override
    @JsonProperty(value="emailAddresses")
    public ImmutableList<String> emailAddresses() {
        return this.emailAddresses;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final AlertConfigDto withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new AlertConfigDto(newValue, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, this.emailAddresses, this.version);
    }

    public final AlertConfigDto withPercentile(double value) {
        double newValue = value;
        return new AlertConfigDto(this.transactionType, newValue, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, this.emailAddresses, this.version);
    }

    public final AlertConfigDto withTimePeriodMinutes(int value) {
        if (this.timePeriodMinutes == value) {
            return this;
        }
        int newValue = value;
        return new AlertConfigDto(this.transactionType, this.percentile, newValue, this.thresholdMillis, this.minTransactionCount, this.emailAddresses, this.version);
    }

    public final AlertConfigDto withThresholdMillis(int value) {
        if (this.thresholdMillis == value) {
            return this;
        }
        int newValue = value;
        return new AlertConfigDto(this.transactionType, this.percentile, this.timePeriodMinutes, newValue, this.minTransactionCount, this.emailAddresses, this.version);
    }

    public final AlertConfigDto withMinTransactionCount(int value) {
        if (this.minTransactionCount == value) {
            return this;
        }
        int newValue = value;
        return new AlertConfigDto(this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, newValue, this.emailAddresses, this.version);
    }

    public final AlertConfigDto withEmailAddresses(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AlertConfigDto(this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, newValue, this.version);
    }

    public final AlertConfigDto withEmailAddresses(Iterable<String> elements) {
        if (this.emailAddresses == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AlertConfigDto(this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, newValue, this.version);
    }

    public final AlertConfigDto withVersion(@Nullable String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = value;
        return new AlertConfigDto(this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, this.emailAddresses, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AlertConfigDto && this.equalTo((AlertConfigDto)another);
    }

    private boolean equalTo(AlertConfigDto another) {
        return this.transactionType.equals(another.transactionType) && Double.doubleToLongBits(this.percentile) == Double.doubleToLongBits(another.percentile) && this.timePeriodMinutes == another.timePeriodMinutes && this.thresholdMillis == another.thresholdMillis && this.minTransactionCount == another.minTransactionCount && this.emailAddresses.equals(another.emailAddresses) && Objects.equal(this.version, another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + Doubles.hashCode(this.percentile);
        h = h * 17 + this.timePeriodMinutes;
        h = h * 17 + this.thresholdMillis;
        h = h * 17 + this.minTransactionCount;
        h = h * 17 + this.emailAddresses.hashCode();
        h = h * 17 + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AlertConfigDto").add("transactionType", this.transactionType).add("percentile", this.percentile).add("timePeriodMinutes", this.timePeriodMinutes).add("thresholdMillis", this.thresholdMillis).add("minTransactionCount", this.minTransactionCount).add("emailAddresses", this.emailAddresses).add("version", this.version).toString();
    }

    @JsonCreator
    public static AlertConfigDto fromAllAttributes(@JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="percentile") @Nullable Double percentile, @JsonProperty(value="timePeriodMinutes") @Nullable Integer timePeriodMinutes, @JsonProperty(value="thresholdMillis") @Nullable Integer thresholdMillis, @JsonProperty(value="minTransactionCount") @Nullable Integer minTransactionCount, @JsonProperty(value="emailAddresses") @Nullable ImmutableList<String> emailAddresses, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = AlertConfigDto.builder();
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (percentile != null) {
            builder.percentile(percentile);
        }
        if (timePeriodMinutes != null) {
            builder.timePeriodMinutes(timePeriodMinutes);
        }
        if (thresholdMillis != null) {
            builder.thresholdMillis(thresholdMillis);
        }
        if (minTransactionCount != null) {
            builder.minTransactionCount(minTransactionCount);
        }
        if (emailAddresses != null) {
            builder.addAllEmailAddresses(emailAddresses);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static AlertConfigDto copyOf(AlertJsonService.AlertConfigDtoBase instance) {
        if (instance instanceof AlertConfigDto) {
            return (AlertConfigDto)instance;
        }
        return AlertConfigDto.builder().transactionType(instance.transactionType()).percentile(instance.percentile()).timePeriodMinutes(instance.timePeriodMinutes()).thresholdMillis(instance.thresholdMillis()).minTransactionCount(instance.minTransactionCount()).addAllEmailAddresses(instance.emailAddresses()).version(instance.version()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 31L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 1L;
        private static final long INITIALIZED_BIT_PERCENTILE = 2L;
        private static final long INITIALIZED_BIT_TIME_PERIOD_MINUTES = 4L;
        private static final long INITIALIZED_BIT_THRESHOLD_MILLIS = 8L;
        private static final long INITIALIZED_BIT_MIN_TRANSACTION_COUNT = 16L;
        private static final long NONDEFAULT_BIT_VERSION = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String transactionType;
        private double percentile;
        private int timePeriodMinutes;
        private int thresholdMillis;
        private int minTransactionCount;
        private ImmutableList.Builder<String> emailAddressesBuilder = ImmutableList.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder transactionType(String transactionType) {
            this.checkNotIsSet(this.transactionTypeIsSet(), "transactionType");
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder percentile(double percentile) {
            this.checkNotIsSet(this.percentileIsSet(), "percentile");
            this.percentile = percentile;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder timePeriodMinutes(int timePeriodMinutes) {
            this.checkNotIsSet(this.timePeriodMinutesIsSet(), "timePeriodMinutes");
            this.timePeriodMinutes = timePeriodMinutes;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder thresholdMillis(int thresholdMillis) {
            this.checkNotIsSet(this.thresholdMillisIsSet(), "thresholdMillis");
            this.thresholdMillis = thresholdMillis;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder minTransactionCount(int minTransactionCount) {
            this.checkNotIsSet(this.minTransactionCountIsSet(), "minTransactionCount");
            this.minTransactionCount = minTransactionCount;
            this.initializedBitset |= 0x10L;
            return this;
        }

        public final Builder addEmailAddresses(String element) {
            this.emailAddressesBuilder.add((Object)element);
            return this;
        }

        public final Builder addEmailAddresses(String ... elements) {
            this.emailAddressesBuilder.add(elements);
            return this;
        }

        public final Builder addAllEmailAddresses(Iterable<String> elements) {
            this.emailAddressesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder version(@Nullable String version) {
            this.checkNotIsSet(this.versionIsSet(), "version");
            this.version = version;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public AlertConfigDto build() {
            this.checkRequiredAttributes();
            return new AlertConfigDto(this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, (ImmutableList)this.emailAddressesBuilder.build(), this.version);
        }

        private boolean versionIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean percentileIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean timePeriodMinutesIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean thresholdMillisIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean minTransactionCountIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of AlertConfigDto is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 31L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            if (!this.percentileIsSet()) {
                attributes.add("percentile");
            }
            if (!this.timePeriodMinutesIsSet()) {
                attributes.add("timePeriodMinutes");
            }
            if (!this.thresholdMillisIsSet()) {
                attributes.add("thresholdMillis");
            }
            if (!this.minTransactionCountIsSet()) {
                attributes.add("minTransactionCount");
            }
            return "Cannot build AlertConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

