/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.AlertConfig;
import org.glowroot.config.ConfigService;
import org.glowroot.local.ui.AlertConfigDto;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.JsonServiceException;
import org.glowroot.local.ui.POST;
import org.glowroot.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class AlertJsonService {
    private static final Logger logger = LoggerFactory.getLogger(AlertJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final ConfigService configService;

    AlertJsonService(ConfigService configService) {
        this.configService = configService;
    }

    @GET(value="/backend/config/alerts")
    String getAlertList() throws JsonProcessingException {
        ArrayList<AlertConfigDto> alertConfigDtos = Lists.newArrayList();
        List<AlertConfig> alertConfigs = this.configService.getAlertConfigs();
        alertConfigs = AlertConfig.orderingByName.immutableSortedCopy(alertConfigs);
        for (AlertConfig alertConfig : alertConfigs) {
            alertConfigDtos.add(AlertConfigDtoBase.fromConfig(alertConfig));
        }
        return mapper.writeValueAsString(alertConfigDtos);
    }

    @GET(value="/backend/config/alerts/([0-9a-f]{40})")
    String getAlert(String version) throws JsonProcessingException {
        AlertConfig alertConfig = this.configService.getAlertConfig(version);
        if (alertConfig == null) {
            throw new JsonServiceException(HttpResponseStatus.NOT_FOUND);
        }
        return mapper.writeValueAsString(AlertConfigDtoBase.fromConfig(alertConfig));
    }

    @POST(value="/backend/config/alerts/add")
    String addAlert(String content) throws Exception {
        AlertConfigDto alertConfigDto = mapper.readValue(content, AlertConfigDto.class);
        AlertConfig alertConfig = alertConfigDto.toConfig();
        try {
            this.configService.insertAlertConfig(alertConfig);
        }
        catch (ConfigService.DuplicateMBeanObjectNameException e) {
            logger.debug(e.getMessage(), e);
            throw new JsonServiceException(HttpResponseStatus.CONFLICT, "mbeanObjectName");
        }
        return mapper.writeValueAsString(AlertConfigDtoBase.fromConfig(alertConfig));
    }

    @POST(value="/backend/config/alerts/update")
    String updateAlert(String content) throws IOException {
        AlertConfigDto alertConfigDto = mapper.readValue(content, AlertConfigDto.class);
        AlertConfig alertConfig = alertConfigDto.toConfig();
        String version = alertConfigDto.version();
        Preconditions.checkNotNull(version, "Missing required request property: version");
        this.configService.updateAlertConfig(alertConfig, version);
        return mapper.writeValueAsString(AlertConfigDtoBase.fromConfig(alertConfig));
    }

    @POST(value="/backend/config/alerts/remove")
    void removeAlert(String content) throws IOException {
        String version = mapper.readValue(content, String.class);
        Preconditions.checkNotNull(version);
        this.configService.deleteAlertConfig(version);
    }

    @Value.Immutable
    static abstract class AlertConfigDtoBase {
        AlertConfigDtoBase() {
        }

        public abstract String transactionType();

        public abstract double percentile();

        public abstract int timePeriodMinutes();

        public abstract int thresholdMillis();

        public abstract int minTransactionCount();

        public abstract ImmutableList<String> emailAddresses();

        @Nullable
        abstract String version();

        private static AlertConfigDto fromConfig(AlertConfig alertConfig) {
            return AlertConfigDto.builder().transactionType(alertConfig.transactionType()).percentile(alertConfig.percentile()).timePeriodMinutes(alertConfig.timePeriodMinutes()).thresholdMillis(alertConfig.thresholdMillis()).minTransactionCount(alertConfig.minTransactionCount()).addAllEmailAddresses(alertConfig.emailAddresses()).version(alertConfig.version()).build();
        }

        AlertConfig toConfig() {
            return AlertConfig.builder().transactionType(this.transactionType()).percentile(this.percentile()).timePeriodMinutes(this.timePeriodMinutes()).thresholdMillis(this.thresholdMillis()).minTransactionCount(this.minTransactionCount()).addAllEmailAddresses(this.emailAddresses()).build();
        }
    }
}

