/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.collector.AggregateCollector;
import org.glowroot.collector.AggregateIntervalCollector;
import org.glowroot.collector.ErrorPoint;
import org.glowroot.collector.ErrorSummary;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.ErrorSummaryQuery;
import org.glowroot.local.store.QueryResult;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;

class ErrorCommonService {
    private final AggregateDao aggregateDao;
    @Nullable
    private final AggregateCollector aggregateCollector;
    private final long fixedRollup1Millis;
    private final long fixedRollup2Millis;

    ErrorCommonService(AggregateDao aggregateDao, @Nullable AggregateCollector aggregateCollector, long fixedRollup1Seconds, long fixedRollup2Seconds) {
        this.aggregateDao = aggregateDao;
        this.aggregateCollector = aggregateCollector;
        this.fixedRollup1Millis = fixedRollup1Seconds * 1000L;
        this.fixedRollup2Millis = fixedRollup2Seconds * 1000L;
    }

    ErrorSummary readOverallErrorSummary(String transactionType, long from, long to) throws SQLException {
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from, to);
        if (orderedIntervalCollectors.isEmpty()) {
            return this.aggregateDao.readOverallErrorSummary(transactionType, from, to);
        }
        long revisedTo = ErrorCommonService.getRevisedTo(to, orderedIntervalCollectors);
        ErrorSummary overallSummary = this.aggregateDao.readOverallErrorSummary(transactionType, from, revisedTo);
        for (AggregateIntervalCollector intervalCollector : orderedIntervalCollectors) {
            ErrorSummary liveOverallSummary = intervalCollector.getLiveOverallErrorSummary(transactionType);
            if (liveOverallSummary == null) continue;
            overallSummary = ErrorCommonService.combineErrorSummaries(null, overallSummary, liveOverallSummary);
        }
        return overallSummary;
    }

    QueryResult<ErrorSummary> readTransactionErrorSummaries(ErrorSummaryQuery query) throws SQLException {
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        if (orderedIntervalCollectors.isEmpty()) {
            return this.aggregateDao.readTransactionErrorSummaries(query);
        }
        long revisedTo = ErrorCommonService.getRevisedTo(query.to(), orderedIntervalCollectors);
        ErrorSummaryQuery revisedQuery = query.withTo(revisedTo);
        QueryResult<ErrorSummary> queryResult = this.aggregateDao.readTransactionErrorSummaries(revisedQuery);
        if (orderedIntervalCollectors.isEmpty()) {
            return queryResult;
        }
        return ErrorCommonService.mergeInLiveTransactionErrorSummaries(revisedQuery, queryResult, orderedIntervalCollectors);
    }

    List<ErrorPoint> readErrorPoints(String transactionType, @Nullable String transactionName, long from, long to, long liveCaptureTime) throws Exception {
        int rollupLevel = this.aggregateDao.getRollupLevelForView(from, to);
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from, to);
        long revisedTo = ErrorCommonService.getRevisedTo(to, orderedIntervalCollectors);
        List<ErrorPoint> errorPoints = this.readErrorPointsFromDao(transactionType, transactionName, from, revisedTo, rollupLevel);
        if (rollupLevel == 0) {
            errorPoints = Lists.newArrayList(errorPoints);
            errorPoints.addAll(ErrorCommonService.getLiveErrorPoints(transactionType, transactionName, orderedIntervalCollectors, liveCaptureTime));
            return errorPoints;
        }
        long nonRolledUpFrom = from;
        if (!errorPoints.isEmpty()) {
            long lastRolledUpTime = errorPoints.get(errorPoints.size() - 1).captureTime();
            nonRolledUpFrom = Math.max(nonRolledUpFrom, lastRolledUpTime + 1L);
        }
        ArrayList<ErrorPoint> orderedNonRolledUpErrorPoints = Lists.newArrayList();
        orderedNonRolledUpErrorPoints.addAll(this.readErrorPointsFromDao(transactionType, transactionName, nonRolledUpFrom, revisedTo, 0));
        orderedNonRolledUpErrorPoints.addAll(ErrorCommonService.getLiveErrorPoints(transactionType, transactionName, orderedIntervalCollectors, liveCaptureTime));
        errorPoints = Lists.newArrayList(errorPoints);
        errorPoints.addAll(this.rollUp(orderedNonRolledUpErrorPoints, liveCaptureTime, rollupLevel));
        return errorPoints;
    }

    private List<AggregateIntervalCollector> getOrderedIntervalCollectorsInRange(long from, long to) {
        if (this.aggregateCollector == null) {
            return ImmutableList.of();
        }
        return this.aggregateCollector.getOrderedIntervalCollectorsInRange(from, to);
    }

    private List<ErrorPoint> rollUp(List<ErrorPoint> orderedNonRolledUpErrorPoints, long liveCaptureTime, int rollupLevel) {
        long fixedRollupMillis = rollupLevel == 1 ? this.fixedRollup1Millis : this.fixedRollup2Millis;
        ArrayList<ErrorPoint> rolledUpErrorPoints = Lists.newArrayList();
        long currRollupTime = Long.MIN_VALUE;
        long currErrorCount = 0L;
        long currTransactionCount = 0L;
        for (ErrorPoint errorPoint : orderedNonRolledUpErrorPoints) {
            long rollupTime = (long)Math.ceil((double)errorPoint.captureTime() / (double)fixedRollupMillis) * fixedRollupMillis;
            if (rollupTime != currRollupTime && currTransactionCount != 0L) {
                rolledUpErrorPoints.add(ErrorPoint.of(Math.min(currRollupTime, liveCaptureTime), currErrorCount, currTransactionCount));
                currErrorCount = 0L;
                currTransactionCount = 0L;
            }
            currRollupTime = rollupTime;
            currErrorCount += errorPoint.errorCount();
            currTransactionCount += errorPoint.transactionCount();
        }
        if (currTransactionCount != 0L) {
            rolledUpErrorPoints.add(ErrorPoint.of(Math.min(currRollupTime, liveCaptureTime), currErrorCount, currTransactionCount));
        }
        return rolledUpErrorPoints;
    }

    private List<ErrorPoint> readErrorPointsFromDao(String transactionType, @Nullable String transactionName, long from, long to, int rollupLevel) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.readOverallErrorPoints(transactionType, from, to, rollupLevel);
        }
        return this.aggregateDao.readTransactionErrorPoints(transactionType, transactionName, from, to, rollupLevel);
    }

    private static long getRevisedTo(long to, List<AggregateIntervalCollector> orderedIntervalCollectors) {
        if (orderedIntervalCollectors.isEmpty()) {
            return to;
        }
        return orderedIntervalCollectors.get(0).getEndTime() - 1L;
    }

    private static List<ErrorPoint> getLiveErrorPoints(String transactionType, @Nullable String transactionName, List<AggregateIntervalCollector> intervalCollectors, long liveCaptureTime) throws IOException {
        ArrayList<ErrorPoint> errorPoints = Lists.newArrayList();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            ErrorPoint liveErrorPoint = intervalCollector.getLiveErrorPoint(transactionType, transactionName, liveCaptureTime);
            if (liveErrorPoint == null) continue;
            errorPoints.add(liveErrorPoint);
        }
        return errorPoints;
    }

    private static ErrorSummary combineErrorSummaries(@Nullable String transactionName, ErrorSummary summary1, ErrorSummary summary2) {
        return ErrorSummary.builder().transactionName(transactionName).errorCount(summary1.errorCount() + summary2.errorCount()).transactionCount(summary1.transactionCount() + summary2.transactionCount()).build();
    }

    private static QueryResult<ErrorSummary> mergeInLiveTransactionErrorSummaries(ErrorSummaryQuery query, QueryResult<ErrorSummary> queryResult, List<AggregateIntervalCollector> intervalCollectors) {
        boolean bl;
        List<ErrorSummary> errorSummaries = queryResult.records();
        HashMap<String, ErrorSummary> errorSummaryMap = Maps.newHashMap();
        for (ErrorSummary errorSummary : errorSummaries) {
            String transactionName = errorSummary.transactionName();
            Preconditions.checkNotNull(transactionName);
            errorSummaryMap.put(transactionName, errorSummary);
        }
        for (AggregateIntervalCollector aggregateIntervalCollector : intervalCollectors) {
            List<ErrorSummary> liveErrorSummaries = aggregateIntervalCollector.getLiveTransactionErrorSummaries(query.transactionType());
            for (ErrorSummary liveErrorSummary : liveErrorSummaries) {
                String transactionName = liveErrorSummary.transactionName();
                Preconditions.checkNotNull(transactionName);
                ErrorSummary errorSummary = (ErrorSummary)errorSummaryMap.get(transactionName);
                if (errorSummary == null) {
                    errorSummaryMap.put(transactionName, liveErrorSummary);
                    continue;
                }
                errorSummaryMap.put(transactionName, ErrorCommonService.combineErrorSummaries(transactionName, errorSummary, liveErrorSummary));
            }
        }
        List<ErrorSummary> mergedErrorSummaries = Lists.newArrayList();
        for (ErrorSummary errorSummary : errorSummaryMap.values()) {
            if (errorSummary.errorCount() <= 0L) continue;
            mergedErrorSummaries.add(errorSummary);
        }
        mergedErrorSummaries = ErrorCommonService.sortErrorSummaries(mergedErrorSummaries, query.sortOrder());
        boolean bl2 = queryResult.moreAvailable();
        if (mergedErrorSummaries.size() > query.limit()) {
            bl = true;
            mergedErrorSummaries = mergedErrorSummaries.subList(0, query.limit());
        }
        return new QueryResult<ErrorSummary>(mergedErrorSummaries, bl);
    }

    private static List<ErrorSummary> sortErrorSummaries(Iterable<ErrorSummary> errorSummaries, AggregateDao.ErrorSummarySortOrder sortOrder) {
        switch (sortOrder) {
            case ERROR_COUNT: {
                return ErrorSummary.orderingByErrorCountDesc.immutableSortedCopy(errorSummaries);
            }
            case ERROR_RATE: {
                return ErrorSummary.orderingByErrorRateDesc.immutableSortedCopy(errorSummaries);
            }
        }
        throw new AssertionError((Object)("Unexpected sort order: " + (Object)((Object)sortOrder)));
    }
}

