/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ErrorJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class ErrorMessageRequest
extends ErrorJsonService.ErrorMessageRequestBase {
    private final long from;
    private final long to;
    private final String transactionType;
    @Nullable
    private final String transactionName;
    private final ImmutableList<String> include;
    private final ImmutableList<String> exclude;
    private final int errorMessageLimit;

    private ErrorMessageRequest(long from, long to, String transactionType, @Nullable String transactionName, ImmutableList<String> include, ImmutableList<String> exclude, int errorMessageLimit) {
        this.from = from;
        this.to = to;
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.include = include;
        this.exclude = exclude;
        this.errorMessageLimit = errorMessageLimit;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="include")
    public ImmutableList<String> include() {
        return this.include;
    }

    @Override
    @JsonProperty(value="exclude")
    public ImmutableList<String> exclude() {
        return this.exclude;
    }

    @Override
    @JsonProperty(value="errorMessageLimit")
    public int errorMessageLimit() {
        return this.errorMessageLimit;
    }

    public final ErrorMessageRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new ErrorMessageRequest(newValue, this.to, this.transactionType, this.transactionName, this.include, this.exclude, this.errorMessageLimit);
    }

    public final ErrorMessageRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new ErrorMessageRequest(this.from, newValue, this.transactionType, this.transactionName, this.include, this.exclude, this.errorMessageLimit);
    }

    public final ErrorMessageRequest withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ErrorMessageRequest(this.from, this.to, newValue, this.transactionName, this.include, this.exclude, this.errorMessageLimit);
    }

    public final ErrorMessageRequest withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new ErrorMessageRequest(this.from, this.to, this.transactionType, newValue, this.include, this.exclude, this.errorMessageLimit);
    }

    public final ErrorMessageRequest withInclude(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ErrorMessageRequest(this.from, this.to, this.transactionType, this.transactionName, newValue, this.exclude, this.errorMessageLimit);
    }

    public final ErrorMessageRequest withInclude(Iterable<String> elements) {
        if (this.include == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ErrorMessageRequest(this.from, this.to, this.transactionType, this.transactionName, newValue, this.exclude, this.errorMessageLimit);
    }

    public final ErrorMessageRequest withExclude(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ErrorMessageRequest(this.from, this.to, this.transactionType, this.transactionName, this.include, newValue, this.errorMessageLimit);
    }

    public final ErrorMessageRequest withExclude(Iterable<String> elements) {
        if (this.exclude == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ErrorMessageRequest(this.from, this.to, this.transactionType, this.transactionName, this.include, newValue, this.errorMessageLimit);
    }

    public final ErrorMessageRequest withErrorMessageLimit(int value) {
        if (this.errorMessageLimit == value) {
            return this;
        }
        int newValue = value;
        return new ErrorMessageRequest(this.from, this.to, this.transactionType, this.transactionName, this.include, this.exclude, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ErrorMessageRequest && this.equalTo((ErrorMessageRequest)another);
    }

    private boolean equalTo(ErrorMessageRequest another) {
        return this.from == another.from && this.to == another.to && this.transactionType.equals(another.transactionType) && Objects.equal(this.transactionName, another.transactionName) && this.include.equals(another.include) && this.exclude.equals(another.exclude) && this.errorMessageLimit == another.errorMessageLimit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + Objects.hashCode(this.transactionName);
        h = h * 17 + this.include.hashCode();
        h = h * 17 + this.exclude.hashCode();
        h = h * 17 + this.errorMessageLimit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ErrorMessageRequest").add("from", this.from).add("to", this.to).add("transactionType", this.transactionType).add("transactionName", this.transactionName).add("include", this.include).add("exclude", this.exclude).add("errorMessageLimit", this.errorMessageLimit).toString();
    }

    @JsonCreator
    public static ErrorMessageRequest fromAllAttributes(@JsonProperty(value="from") @Nullable Long from, @JsonProperty(value="to") @Nullable Long to, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionName") @Nullable String transactionName, @JsonProperty(value="include") @Nullable ImmutableList<String> include, @JsonProperty(value="exclude") @Nullable ImmutableList<String> exclude, @JsonProperty(value="errorMessageLimit") @Nullable Integer errorMessageLimit) {
        Builder builder = ErrorMessageRequest.builder();
        if (from != null) {
            builder.from(from);
        }
        if (to != null) {
            builder.to(to);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionName != null) {
            builder.transactionName(transactionName);
        }
        if (include != null) {
            builder.addAllInclude(include);
        }
        if (exclude != null) {
            builder.addAllExclude(exclude);
        }
        if (errorMessageLimit != null) {
            builder.errorMessageLimit(errorMessageLimit);
        }
        return builder.build();
    }

    static ErrorMessageRequest copyOf(ErrorJsonService.ErrorMessageRequestBase instance) {
        if (instance instanceof ErrorMessageRequest) {
            return (ErrorMessageRequest)instance;
        }
        return ErrorMessageRequest.builder().from(instance.from()).to(instance.to()).transactionType(instance.transactionType()).transactionName(instance.transactionName()).addAllInclude(instance.include()).addAllExclude(instance.exclude()).errorMessageLimit(instance.errorMessageLimit()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_FROM = 1L;
        private static final long INITIALIZED_BIT_TO = 2L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 4L;
        private static final long INITIALIZED_BIT_ERROR_MESSAGE_LIMIT = 8L;
        private static final long NONDEFAULT_BIT_TRANSACTION_NAME = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        private long from;
        private long to;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionName;
        private ImmutableList.Builder<String> includeBuilder = ImmutableList.builder();
        private ImmutableList.Builder<String> excludeBuilder = ImmutableList.builder();
        private int errorMessageLimit;

        private Builder() {
        }

        public final Builder from(long from) {
            this.checkNotIsSet(this.fromIsSet(), "from");
            this.from = from;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.checkNotIsSet(this.toIsSet(), "to");
            this.to = to;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.checkNotIsSet(this.transactionTypeIsSet(), "transactionType");
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.checkNotIsSet(this.transactionNameIsSet(), "transactionName");
            this.transactionName = transactionName;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder addInclude(String element) {
            this.includeBuilder.add((Object)element);
            return this;
        }

        public final Builder addInclude(String ... elements) {
            this.includeBuilder.add(elements);
            return this;
        }

        public final Builder addAllInclude(Iterable<String> elements) {
            this.includeBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder addExclude(String element) {
            this.excludeBuilder.add((Object)element);
            return this;
        }

        public final Builder addExclude(String ... elements) {
            this.excludeBuilder.add(elements);
            return this;
        }

        public final Builder addAllExclude(Iterable<String> elements) {
            this.excludeBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder errorMessageLimit(int errorMessageLimit) {
            this.checkNotIsSet(this.errorMessageLimitIsSet(), "errorMessageLimit");
            this.errorMessageLimit = errorMessageLimit;
            this.initializedBitset |= 8L;
            return this;
        }

        public ErrorMessageRequest build() {
            this.checkRequiredAttributes();
            return new ErrorMessageRequest(this.from, this.to, this.transactionType, this.transactionName, (ImmutableList)this.includeBuilder.build(), (ImmutableList)this.excludeBuilder.build(), this.errorMessageLimit);
        }

        private boolean transactionNameIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean errorMessageLimitIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ErrorMessageRequest is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            if (!this.errorMessageLimitIsSet()) {
                attributes.add("errorMessageLimit");
            }
            return "Cannot build ErrorMessageRequest, some of required attributes are not set " + attributes;
        }
    }
}

