/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.JvmJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class GaugePointRequest
extends JvmJsonService.GaugePointRequestBase {
    private final long from;
    private final long to;
    private final ImmutableList<String> gaugeNames;

    private GaugePointRequest(long from, long to, ImmutableList<String> gaugeNames) {
        this.from = from;
        this.to = to;
        this.gaugeNames = gaugeNames;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="gaugeNames")
    public ImmutableList<String> gaugeNames() {
        return this.gaugeNames;
    }

    public final GaugePointRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new GaugePointRequest(newValue, this.to, this.gaugeNames);
    }

    public final GaugePointRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new GaugePointRequest(this.from, newValue, this.gaugeNames);
    }

    public final GaugePointRequest withGaugeNames(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new GaugePointRequest(this.from, this.to, newValue);
    }

    public final GaugePointRequest withGaugeNames(Iterable<String> elements) {
        if (this.gaugeNames == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new GaugePointRequest(this.from, this.to, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GaugePointRequest && this.equalTo((GaugePointRequest)another);
    }

    private boolean equalTo(GaugePointRequest another) {
        return this.from == another.from && this.to == another.to && this.gaugeNames.equals(another.gaugeNames);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + this.gaugeNames.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GaugePointRequest").add("from", this.from).add("to", this.to).add("gaugeNames", this.gaugeNames).toString();
    }

    @JsonCreator
    public static GaugePointRequest fromAllAttributes(@JsonProperty(value="from") @Nullable Long from, @JsonProperty(value="to") @Nullable Long to, @JsonProperty(value="gaugeNames") @Nullable ImmutableList<String> gaugeNames) {
        Builder builder = GaugePointRequest.builder();
        if (from != null) {
            builder.from(from);
        }
        if (to != null) {
            builder.to(to);
        }
        if (gaugeNames != null) {
            builder.addAllGaugeNames(gaugeNames);
        }
        return builder.build();
    }

    static GaugePointRequest copyOf(JvmJsonService.GaugePointRequestBase instance) {
        if (instance instanceof GaugePointRequest) {
            return (GaugePointRequest)instance;
        }
        return GaugePointRequest.builder().from(instance.from()).to(instance.to()).addAllGaugeNames(instance.gaugeNames()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_FROM = 1L;
        private static final long INITIALIZED_BIT_TO = 2L;
        private long initializedBitset;
        private long from;
        private long to;
        private ImmutableList.Builder<String> gaugeNamesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(long from) {
            this.checkNotIsSet(this.fromIsSet(), "from");
            this.from = from;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.checkNotIsSet(this.toIsSet(), "to");
            this.to = to;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addGaugeNames(String element) {
            this.gaugeNamesBuilder.add((Object)element);
            return this;
        }

        public final Builder addGaugeNames(String ... elements) {
            this.gaugeNamesBuilder.add(elements);
            return this;
        }

        public final Builder addAllGaugeNames(Iterable<String> elements) {
            this.gaugeNamesBuilder.addAll((Iterable)elements);
            return this;
        }

        public GaugePointRequest build() {
            this.checkRequiredAttributes();
            return new GaugePointRequest(this.from, this.to, (ImmutableList)this.gaugeNamesBuilder.build());
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of GaugePointRequest is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            return "Cannot build GaugePointRequest, some of required attributes are not set " + attributes;
        }
    }
}

