/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.common.Clock;
import org.glowroot.config.AnonymousAccess;
import org.glowroot.config.ConfigService;
import org.glowroot.local.ui.HttpServices;
import org.glowroot.local.ui.LayoutService;
import org.glowroot.local.ui.PasswordHash;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.FullHttpRequest;
import org.glowroot.shaded.netty.handler.codec.http.FullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpRequest;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.netty.handler.codec.http.HttpVersion;
import org.glowroot.shaded.netty.handler.codec.http.cookie.Cookie;
import org.glowroot.shaded.netty.handler.codec.http.cookie.DefaultCookie;
import org.glowroot.shaded.netty.handler.codec.http.cookie.ServerCookieDecoder;
import org.glowroot.shaded.netty.handler.codec.http.cookie.ServerCookieEncoder;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class HttpSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(HttpSessionManager.class);
    private final ConfigService configService;
    private final Clock clock;
    private final LayoutService layoutJsonService;
    private final SecureRandom secureRandom = new SecureRandom();
    private final Map<String, Long> adminSessionExpirations = Maps.newConcurrentMap();
    private final Map<String, Long> readOnlySessionExpirations = Maps.newConcurrentMap();

    HttpSessionManager(ConfigService configService, Clock clock, LayoutService layoutJsonService) {
        this.configService = configService;
        this.clock = clock;
        this.layoutJsonService = layoutJsonService;
    }

    FullHttpResponse login(FullHttpRequest request, boolean admin) throws IOException {
        boolean success;
        String password = request.content().toString(Charsets.ISO_8859_1);
        String existingPasswordHash = admin ? this.configService.getUserInterfaceConfig().adminPasswordHash() : this.configService.getUserInterfaceConfig().readOnlyPasswordHash();
        try {
            success = HttpSessionManager.validatePassword(password, existingPasswordHash);
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), e);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        if (success) {
            String text = this.layoutJsonService.getLayout();
            FullHttpResponse response = HttpServices.createJsonResponse(text, HttpResponseStatus.OK);
            this.createSession(response, admin);
            return response;
        }
        String text = "{\"incorrectPassword\":true}";
        return HttpServices.createJsonResponse(text, HttpResponseStatus.OK);
    }

    boolean hasReadAccess(HttpRequest request) {
        if (this.configService.getUserInterfaceConfig().anonymousAccess() != AnonymousAccess.NONE) {
            return true;
        }
        String sessionId = this.getSessionId(request);
        if (sessionId == null) {
            return false;
        }
        if (this.isValidNonExpired(sessionId, true)) {
            return true;
        }
        return this.isValidNonExpired(sessionId, false);
    }

    boolean hasAdminAccess(HttpRequest request) {
        if (this.configService.getUserInterfaceConfig().anonymousAccess() == AnonymousAccess.ADMIN) {
            return true;
        }
        String sessionId = this.getSessionId(request);
        if (sessionId == null) {
            return false;
        }
        return this.isValidNonExpired(sessionId, true);
    }

    @Nullable
    String getAuthenticatedUser(HttpRequest request) {
        String sessionId = this.getSessionId(request);
        if (sessionId == null) {
            return null;
        }
        if (this.isValidNonExpired(sessionId, true)) {
            return "admin";
        }
        if (this.isValidNonExpired(sessionId, false)) {
            return "read-only";
        }
        return null;
    }

    FullHttpResponse signOut(HttpRequest request) {
        String sessionId = this.getSessionId(request);
        if (sessionId != null) {
            this.adminSessionExpirations.remove(sessionId);
            this.readOnlySessionExpirations.remove(sessionId);
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.deleteSessionCookie(response);
        return response;
    }

    void createSession(HttpResponse response, boolean admin) {
        String sessionId = new BigInteger(130, this.secureRandom).toString(32);
        this.updateSessionExpiration(sessionId, admin);
        DefaultCookie cookie = new DefaultCookie("GLOWROOT_SESSION_ID", sessionId);
        cookie.setHttpOnly(true);
        cookie.setPath("/");
        response.headers().add("Set-Cookie", (Object)ServerCookieEncoder.STRICT.encode((Cookie)cookie));
        this.purgeExpiredSessions();
    }

    void deleteSessionCookie(HttpResponse response) {
        DefaultCookie cookie = new DefaultCookie("GLOWROOT_SESSION_ID", "");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(0L);
        cookie.setPath("/");
        response.headers().add("Set-Cookie", (Object)ServerCookieEncoder.STRICT.encode((Cookie)cookie));
    }

    void clearAllSessions() {
        this.adminSessionExpirations.clear();
        this.readOnlySessionExpirations.clear();
    }

    @Nullable
    String getSessionId(HttpRequest request) {
        String cookieHeader = request.headers().get("Cookie");
        if (cookieHeader == null) {
            return null;
        }
        Set<Cookie> cookies = ServerCookieDecoder.STRICT.decode(cookieHeader);
        for (Cookie cookie : cookies) {
            if (!cookie.name().equals("GLOWROOT_SESSION_ID")) continue;
            return cookie.value();
        }
        return null;
    }

    private void purgeExpiredSessions() {
        long currentTimeMillis = this.clock.currentTimeMillis();
        HttpSessionManager.purgeExpiredSessions(currentTimeMillis, this.adminSessionExpirations);
        HttpSessionManager.purgeExpiredSessions(currentTimeMillis, this.readOnlySessionExpirations);
    }

    private boolean isValidNonExpired(String sessionId, boolean admin) {
        Map<String, Long> sessionExpirations = admin ? this.adminSessionExpirations : this.readOnlySessionExpirations;
        Long expires = sessionExpirations.get(sessionId);
        if (expires == null || this.clock.currentTimeMillis() > expires) {
            return false;
        }
        this.updateSessionExpiration(sessionId, admin);
        return true;
    }

    private void updateSessionExpiration(String sessionId, boolean admin) {
        Map<String, Long> sessionExpirations = admin ? this.adminSessionExpirations : this.readOnlySessionExpirations;
        int timeoutMinutes = this.configService.getUserInterfaceConfig().sessionTimeoutMinutes();
        if (timeoutMinutes == 0) {
            sessionExpirations.put(sessionId, Long.MAX_VALUE);
        } else {
            sessionExpirations.put(sessionId, this.clock.currentTimeMillis() + TimeUnit.MINUTES.toMillis(timeoutMinutes));
        }
    }

    private static void purgeExpiredSessions(long currentTimeMillis, Map<String, Long> sessionExpirations) {
        Iterator<Map.Entry<String, Long>> i = sessionExpirations.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue() >= currentTimeMillis) continue;
            i.remove();
        }
    }

    private static boolean validatePassword(String password, String passwordHash) throws GeneralSecurityException {
        if (passwordHash.isEmpty()) {
            return password.isEmpty();
        }
        return PasswordHash.validatePassword(password, passwordHash);
    }
}

