/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.api.weaving.MethodModifier;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.CaptureKind;
import org.glowroot.config.ConfigService;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.local.ui.ClassNamesRequest;
import org.glowroot.local.ui.ClasspathCache;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.InstrumentationConfigDto;
import org.glowroot.local.ui.InstrumentationConfigResponse;
import org.glowroot.local.ui.InstrumentationErrorResponse;
import org.glowroot.local.ui.InstrumentationListResponse;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.JsonServiceException;
import org.glowroot.local.ui.MethodNamesRequest;
import org.glowroot.local.ui.MethodSignature;
import org.glowroot.local.ui.MethodSignaturesRequest;
import org.glowroot.local.ui.POST;
import org.glowroot.local.ui.QueryStrings;
import org.glowroot.local.ui.UiAnalyzedMethod;
import org.glowroot.local.ui.UiAnalyzedMethodBase;
import org.glowroot.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Splitter;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.cache.CacheLoader;
import org.glowroot.shaded.google.common.cache.LoadingCache;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.transaction.AdviceCache;
import org.glowroot.transaction.TransactionModule;
import org.glowroot.weaving.AnalyzedWorld;
import org.immutables.value.Value;

@JsonService
class InstrumentationJsonService {
    private static final String DUMMY_KEY = "KEY";
    private static final ObjectMapper mapper = ObjectMappers.create();
    private static final Splitter splitter = Splitter.on(' ').omitEmptyStrings();
    private final ConfigService configService;
    private final AdviceCache adviceCache;
    private final TransactionModule transactionModule;
    private final AnalyzedWorld analyzedWorld;
    @Nullable
    private final Instrumentation instrumentation;
    private final LoadingCache<String, ClasspathCache> classpathCache = CacheBuilder.newBuilder().softValues().maximumSize(1L).build(new CacheLoader<String, ClasspathCache>(){

        @Override
        public ClasspathCache load(String key) throws Exception {
            return new ClasspathCache(InstrumentationJsonService.this.analyzedWorld, InstrumentationJsonService.this.instrumentation);
        }
    });

    InstrumentationJsonService(ConfigService configService, AdviceCache adviceCache, TransactionModule transactionModule, AnalyzedWorld analyzedWorld, @Nullable Instrumentation instrumentation) {
        this.configService = configService;
        this.adviceCache = adviceCache;
        this.transactionModule = transactionModule;
        this.analyzedWorld = analyzedWorld;
        this.instrumentation = instrumentation;
    }

    @GET(value="/backend/config/instrumentation")
    String getInstrumentationConfigs() throws Exception {
        List<InstrumentationConfig> configs = this.configService.getInstrumentationConfigs();
        configs = InstrumentationConfig.ordering.immutableSortedCopy(configs);
        ArrayList<InstrumentationConfigDto> dtos = Lists.newArrayList();
        for (InstrumentationConfig config : configs) {
            dtos.add(InstrumentationConfigDtoBase.fromConfig(config));
        }
        return mapper.writeValueAsString(InstrumentationListResponse.builder().addAllConfigs(dtos).jvmOutOfSync(this.adviceCache.isOutOfSync(this.configService.getInstrumentationConfigs())).jvmRetransformClassesSupported(this.transactionModule.isJvmRetransformClassesSupported()).build());
    }

    @GET(value="/backend/config/instrumentation/([0-9a-f]{40})")
    String getInstrumentationConfig(String version) throws JsonProcessingException {
        InstrumentationConfig config = this.configService.getInstrumentationConfig(version);
        if (config == null) {
            throw new JsonServiceException(HttpResponseStatus.NOT_FOUND);
        }
        List<MethodSignature> methodSignatures = this.getMethodSignatures(config.className(), config.methodName());
        return mapper.writeValueAsString(InstrumentationConfigResponse.builder().config(InstrumentationConfigDtoBase.fromConfig(config)).addAllMethodSignatures(methodSignatures).build());
    }

    @GET(value="/backend/config/preload-classpath-cache")
    void preloadClasspathCache() throws IOException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                InstrumentationJsonService.this.getClasspathCache().updateCache();
            }
        });
        thread.setDaemon(true);
        thread.setName("Glowroot-Temporary-Thread");
        thread.start();
    }

    @GET(value="/backend/config/matching-class-names")
    String getMatchingClassNames(String queryString) throws Exception {
        ClassNamesRequest request = QueryStrings.decode(queryString, ClassNamesRequest.class);
        ImmutableList<String> matchingClassNames = this.getClasspathCache().getMatchingClassNames(request.partialClassName(), request.limit());
        return mapper.writeValueAsString(matchingClassNames);
    }

    @GET(value="/backend/config/matching-method-names")
    String getMatchingMethodNames(String queryString) throws Exception {
        MethodNamesRequest request = QueryStrings.decode(queryString, MethodNamesRequest.class);
        ImmutableList<String> matchingMethodNames = this.getMatchingMethodNames(request.className(), request.partialMethodName(), request.limit());
        return mapper.writeValueAsString(matchingMethodNames);
    }

    @GET(value="/backend/config/method-signatures")
    String getMethodSignatures(String queryString) throws Exception {
        MethodSignaturesRequest request = QueryStrings.decode(queryString, MethodSignaturesRequest.class);
        List<MethodSignature> methodSignatures = this.getMethodSignatures(request.className(), request.methodName());
        return mapper.writeValueAsString(methodSignatures);
    }

    @POST(value="/backend/config/instrumentation/add")
    String addInstrumentationConfig(String content) throws Exception {
        InstrumentationConfigDto configDto = mapper.readValue(content, InstrumentationConfigDto.class);
        InstrumentationConfig config = configDto.toConfig();
        ImmutableList<String> errors = config.validationErrors();
        if (!errors.isEmpty()) {
            return mapper.writeValueAsString(InstrumentationErrorResponse.builder().addAllErrors(errors).build());
        }
        String version = this.configService.insertInstrumentationConfig(config);
        return this.getInstrumentationConfig(version);
    }

    @POST(value="/backend/config/instrumentation/update")
    String updateInstrumentationConfig(String content) throws IOException {
        InstrumentationConfigDto configDto = mapper.readValue(content, InstrumentationConfigDto.class);
        InstrumentationConfig config = configDto.toConfig();
        String version = configDto.version();
        Preconditions.checkNotNull(version, "Missing required request property: version");
        version = this.configService.updateInstrumentationConfig(config, version);
        return this.getInstrumentationConfig(version);
    }

    @POST(value="/backend/config/instrumentation/remove")
    void removeInstrumentationConfig(String content) throws IOException {
        String version = mapper.readValue(content, String.class);
        Preconditions.checkNotNull(version);
        this.configService.deleteInstrumentationConfig(version);
    }

    private ClasspathCache getClasspathCache() {
        return this.classpathCache.getUnchecked(DUMMY_KEY);
    }

    private ImmutableList<String> getMatchingMethodNames(String className, String partialMethodName, int limit) {
        String partialMethodNameUpper = partialMethodName.toUpperCase(Locale.ENGLISH);
        HashSet<String> methodNames = Sets.newHashSet();
        for (UiAnalyzedMethod analyzedMethod : this.getClasspathCache().getAnalyzedMethods(className)) {
            String methodName = analyzedMethod.name();
            if (methodName.equals("<init>") || methodName.equals("<clinit>") || !methodName.toUpperCase(Locale.ENGLISH).contains(partialMethodNameUpper)) continue;
            methodNames.add(methodName);
        }
        ImmutableList<String> sortedMethodNames = Ordering.from(String.CASE_INSENSITIVE_ORDER).immutableSortedCopy(methodNames);
        if (methodNames.size() > limit) {
            return sortedMethodNames.subList(0, limit);
        }
        return sortedMethodNames;
    }

    private List<MethodSignature> getMethodSignatures(String className, String methodName) {
        if (methodName.contains("*") || methodName.contains("|")) {
            return ImmutableList.of();
        }
        List<UiAnalyzedMethod> analyzedMethods = this.getAnalyzedMethods(className, methodName);
        ArrayList<MethodSignature> methodSignatures = Lists.newArrayList();
        for (UiAnalyzedMethod analyzedMethod : analyzedMethods) {
            MethodSignature.Builder builder = MethodSignature.builder();
            builder.name(analyzedMethod.name());
            builder.addAllParameterTypes(analyzedMethod.parameterTypes());
            builder.returnType(analyzedMethod.returnType());
            int reducedModifiers = analyzedMethod.modifiers() & 0xFFFFFFEF & 0xFFFFFFDF;
            String modifierNames = Modifier.toString(reducedModifiers);
            for (String modifier : splitter.split(modifierNames)) {
                builder.addModifiers(modifier.toLowerCase(Locale.ENGLISH));
            }
            methodSignatures.add(builder.build());
        }
        return methodSignatures;
    }

    private List<UiAnalyzedMethod> getAnalyzedMethods(String className, String methodName) {
        HashSet<UiAnalyzedMethod> analyzedMethods = Sets.newHashSet();
        for (UiAnalyzedMethod analyzedMethod : this.getClasspathCache().getAnalyzedMethods(className)) {
            if (!analyzedMethod.name().equals(methodName)) continue;
            analyzedMethods.add(analyzedMethod);
        }
        return UiAnalyzedMethodBase.ordering.sortedCopy(analyzedMethods);
    }

    @Value.Immutable
    static abstract class InstrumentationConfigDtoBase {
        InstrumentationConfigDtoBase() {
        }

        abstract String className();

        abstract String methodName();

        abstract ImmutableList<String> methodParameterTypes();

        abstract Optional<String> methodReturnType();

        abstract ImmutableList<MethodModifier> methodModifiers();

        abstract CaptureKind captureKind();

        abstract Optional<String> timerName();

        abstract Optional<String> traceEntryTemplate();

        @Nullable
        abstract Long traceEntryStackThresholdMillis();

        abstract Optional<Boolean> traceEntryCaptureSelfNested();

        abstract Optional<String> transactionType();

        abstract Optional<String> transactionNameTemplate();

        abstract Optional<String> transactionUserTemplate();

        abstract Map<String, String> transactionCustomAttributeTemplates();

        @Nullable
        abstract Long traceStoreThresholdMillis();

        abstract Optional<String> enabledProperty();

        abstract Optional<String> traceEntryEnabledProperty();

        @Nullable
        abstract String version();

        private static InstrumentationConfigDto fromConfig(InstrumentationConfig config) {
            return InstrumentationConfigDto.builder().className(config.className()).methodName(config.methodName()).addAllMethodParameterTypes(config.methodParameterTypes()).methodReturnType(config.methodReturnType()).addAllMethodModifiers(config.methodModifiers()).captureKind(config.captureKind()).timerName(config.timerName()).traceEntryTemplate(config.traceEntryTemplate()).traceEntryStackThresholdMillis(config.traceEntryStackThresholdMillis()).traceEntryCaptureSelfNested(config.traceEntryCaptureSelfNested()).transactionType(config.transactionType()).transactionNameTemplate(config.transactionNameTemplate()).transactionUserTemplate(config.transactionUserTemplate()).putAllTransactionCustomAttributeTemplates(config.transactionCustomAttributeTemplates()).traceStoreThresholdMillis(config.traceStoreThresholdMillis()).enabledProperty(config.enabledProperty()).traceEntryEnabledProperty(config.traceEntryEnabledProperty()).version(config.version()).build();
        }

        InstrumentationConfig toConfig() {
            return InstrumentationConfig.builder().className(this.className()).methodName(this.methodName()).addAllMethodParameterTypes(this.methodParameterTypes()).methodReturnType(this.methodReturnType().or("")).addAllMethodModifiers(this.methodModifiers()).captureKind(this.captureKind()).timerName(this.timerName().or("")).traceEntryTemplate(this.traceEntryTemplate().or("")).traceEntryStackThresholdMillis(this.traceEntryStackThresholdMillis()).traceEntryCaptureSelfNested(this.traceEntryCaptureSelfNested().or(false)).transactionType(this.transactionType().or("")).transactionNameTemplate(this.transactionNameTemplate().or("")).transactionUserTemplate(this.transactionUserTemplate().or("")).putAllTransactionCustomAttributeTemplates(this.transactionCustomAttributeTemplates()).traceStoreThresholdMillis(this.traceStoreThresholdMillis()).enabledProperty(this.enabledProperty().or("")).traceEntryEnabledProperty(this.traceEntryEnabledProperty().or("")).build();
        }
    }

    @Value.Immutable
    static abstract class InstrumentationErrorResponseBase {
        InstrumentationErrorResponseBase() {
        }

        abstract ImmutableList<String> errors();
    }

    @Value.Immutable
    static abstract class InstrumentationConfigResponseBase {
        InstrumentationConfigResponseBase() {
        }

        abstract InstrumentationConfigDto config();

        abstract ImmutableList<MethodSignature> methodSignatures();
    }

    @Value.Immutable
    static abstract class InstrumentationListResponseBase {
        InstrumentationListResponseBase() {
        }

        abstract ImmutableList<InstrumentationConfigDto> configs();

        abstract boolean jvmOutOfSync();

        abstract boolean jvmRetransformClassesSupported();
    }

    @Value.Immutable
    static abstract class MethodSignatureBase {
        MethodSignatureBase() {
        }

        abstract String name();

        abstract ImmutableList<String> parameterTypes();

        abstract String returnType();

        abstract ImmutableList<String> modifiers();
    }

    @Value.Immutable
    static abstract class MethodSignaturesRequestBase {
        MethodSignaturesRequestBase() {
        }

        abstract String className();

        abstract String methodName();
    }

    @Value.Immutable
    static abstract class MethodNamesRequestBase {
        MethodNamesRequestBase() {
        }

        abstract String className();

        abstract String partialMethodName();

        abstract int limit();
    }

    @Value.Immutable
    static abstract class ClassNamesRequestBase {
        ClassNamesRequestBase() {
        }

        abstract String partialClassName();

        abstract int limit();
    }
}

