/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.HttpServerHandler;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class JsonServiceMapping
extends HttpServerHandler.JsonServiceMappingBase {
    private final HttpServerHandler.HttpMethod httpMethod;
    private final String path;
    private final Object service;
    private final String methodName;
    private final Pattern pattern;

    private JsonServiceMapping(HttpServerHandler.HttpMethod httpMethod, String path, Object service, String methodName) {
        this.httpMethod = httpMethod;
        this.path = path;
        this.service = service;
        this.methodName = methodName;
        this.pattern = Preconditions.checkNotNull(super.pattern());
    }

    @Override
    @JsonProperty(value="httpMethod")
    public HttpServerHandler.HttpMethod httpMethod() {
        return this.httpMethod;
    }

    @Override
    @JsonProperty(value="path")
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty(value="service")
    public Object service() {
        return this.service;
    }

    @Override
    @JsonProperty(value="methodName")
    public String methodName() {
        return this.methodName;
    }

    @Override
    @JsonProperty(value="pattern")
    public Pattern pattern() {
        return this.pattern;
    }

    public final JsonServiceMapping withHttpMethod(HttpServerHandler.HttpMethod value) {
        if (this.httpMethod == value) {
            return this;
        }
        HttpServerHandler.HttpMethod newValue = Preconditions.checkNotNull(value);
        return new JsonServiceMapping(newValue, this.path, this.service, this.methodName);
    }

    public final JsonServiceMapping withPath(String value) {
        if (this.path == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new JsonServiceMapping(this.httpMethod, newValue, this.service, this.methodName);
    }

    public final JsonServiceMapping withService(Object value) {
        if (this.service == value) {
            return this;
        }
        Object newValue = Preconditions.checkNotNull(value);
        return new JsonServiceMapping(this.httpMethod, this.path, newValue, this.methodName);
    }

    public final JsonServiceMapping withMethodName(String value) {
        if (this.methodName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new JsonServiceMapping(this.httpMethod, this.path, this.service, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof JsonServiceMapping && this.equalTo((JsonServiceMapping)another);
    }

    private boolean equalTo(JsonServiceMapping another) {
        return this.httpMethod.equals((Object)another.httpMethod) && this.path.equals(another.path) && this.service.equals(another.service) && this.methodName.equals(another.methodName) && this.pattern.equals(another.pattern);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.httpMethod.hashCode();
        h = h * 17 + this.path.hashCode();
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.methodName.hashCode();
        h = h * 17 + this.pattern.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("JsonServiceMapping").add("httpMethod", (Object)this.httpMethod).add("path", this.path).add("service", this.service).add("methodName", this.methodName).add("pattern", this.pattern).toString();
    }

    @JsonCreator
    public static JsonServiceMapping fromAllAttributes(@JsonProperty(value="httpMethod") @Nullable HttpServerHandler.HttpMethod httpMethod, @JsonProperty(value="path") @Nullable String path, @JsonProperty(value="service") @Nullable Object service, @JsonProperty(value="methodName") @Nullable String methodName) {
        Builder builder = JsonServiceMapping.builder();
        if (httpMethod != null) {
            builder.httpMethod(httpMethod);
        }
        if (path != null) {
            builder.path(path);
        }
        if (service != null) {
            builder.service(service);
        }
        if (methodName != null) {
            builder.methodName(methodName);
        }
        return builder.build();
    }

    static JsonServiceMapping copyOf(HttpServerHandler.JsonServiceMappingBase instance) {
        if (instance instanceof JsonServiceMapping) {
            return (JsonServiceMapping)instance;
        }
        return JsonServiceMapping.builder().httpMethod(instance.httpMethod()).path(instance.path()).service(instance.service()).methodName(instance.methodName()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_HTTP_METHOD = 1L;
        private static final long INITIALIZED_BIT_PATH = 2L;
        private static final long INITIALIZED_BIT_SERVICE = 4L;
        private static final long INITIALIZED_BIT_METHOD_NAME = 8L;
        private long initializedBitset;
        @Nullable
        private HttpServerHandler.HttpMethod httpMethod;
        @Nullable
        private String path;
        @Nullable
        private Object service;
        @Nullable
        private String methodName;

        private Builder() {
        }

        public final Builder httpMethod(HttpServerHandler.HttpMethod httpMethod) {
            this.checkNotIsSet(this.httpMethodIsSet(), "httpMethod");
            this.httpMethod = Preconditions.checkNotNull(httpMethod);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder path(String path) {
            this.checkNotIsSet(this.pathIsSet(), "path");
            this.path = Preconditions.checkNotNull(path);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder service(Object service) {
            this.checkNotIsSet(this.serviceIsSet(), "service");
            this.service = Preconditions.checkNotNull(service);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder methodName(String methodName) {
            this.checkNotIsSet(this.methodNameIsSet(), "methodName");
            this.methodName = Preconditions.checkNotNull(methodName);
            this.initializedBitset |= 8L;
            return this;
        }

        public JsonServiceMapping build() {
            this.checkRequiredAttributes();
            return new JsonServiceMapping(this.httpMethod, this.path, this.service, this.methodName);
        }

        private boolean httpMethodIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean pathIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean serviceIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean methodNameIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of JsonServiceMapping is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.httpMethodIsSet()) {
                attributes.add("httpMethod");
            }
            if (!this.pathIsSet()) {
                attributes.add("path");
            }
            if (!this.serviceIsSet()) {
                attributes.add("service");
            }
            if (!this.methodNameIsSet()) {
                attributes.add("methodName");
            }
            return "Cannot build JsonServiceMapping, some of required attributes are not set " + attributes;
        }
    }
}

