/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.JvmJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class MBeanAttributeMapRequest
extends JvmJsonService.MBeanAttributeMapRequestBase {
    private final String objectName;

    private MBeanAttributeMapRequest(String objectName) {
        this.objectName = objectName;
    }

    @Override
    @JsonProperty(value="objectName")
    public String objectName() {
        return this.objectName;
    }

    public final MBeanAttributeMapRequest withObjectName(String value) {
        if (this.objectName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MBeanAttributeMapRequest(newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MBeanAttributeMapRequest && this.equalTo((MBeanAttributeMapRequest)another);
    }

    private boolean equalTo(MBeanAttributeMapRequest another) {
        return this.objectName.equals(another.objectName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.objectName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MBeanAttributeMapRequest").add("objectName", this.objectName).toString();
    }

    @JsonCreator
    public static MBeanAttributeMapRequest fromAllAttributes(@JsonProperty(value="objectName") @Nullable String objectName) {
        Builder builder = MBeanAttributeMapRequest.builder();
        if (objectName != null) {
            builder.objectName(objectName);
        }
        return builder.build();
    }

    static MBeanAttributeMapRequest copyOf(JvmJsonService.MBeanAttributeMapRequestBase instance) {
        if (instance instanceof MBeanAttributeMapRequest) {
            return (MBeanAttributeMapRequest)instance;
        }
        return MBeanAttributeMapRequest.builder().objectName(instance.objectName()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_OBJECT_NAME = 1L;
        private long initializedBitset;
        @Nullable
        private String objectName;

        private Builder() {
        }

        public final Builder objectName(String objectName) {
            this.checkNotIsSet(this.objectNameIsSet(), "objectName");
            this.objectName = Preconditions.checkNotNull(objectName);
            this.initializedBitset |= 1L;
            return this;
        }

        public MBeanAttributeMapRequest build() {
            this.checkRequiredAttributes();
            return new MBeanAttributeMapRequest(this.objectName);
        }

        private boolean objectNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of MBeanAttributeMapRequest is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.objectNameIsSet()) {
                attributes.add("objectName");
            }
            return "Cannot build MBeanAttributeMapRequest, some of required attributes are not set " + attributes;
        }
    }
}

