/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.AggregateMerging;
import org.glowroot.local.ui.PercentileValue;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class PercentileMergedAggregate
extends AggregateMerging.PercentileMergedAggregateBase {
    private final long totalMicros;
    private final long transactionCount;
    private final ImmutableList<PercentileValue> percentileValues;

    private PercentileMergedAggregate(long totalMicros, long transactionCount, ImmutableList<PercentileValue> percentileValues) {
        this.totalMicros = totalMicros;
        this.transactionCount = transactionCount;
        this.percentileValues = percentileValues;
    }

    @Override
    @JsonProperty(value="totalMicros")
    public long totalMicros() {
        return this.totalMicros;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    @Override
    @JsonProperty(value="percentileValues")
    public ImmutableList<PercentileValue> percentileValues() {
        return this.percentileValues;
    }

    public final PercentileMergedAggregate withTotalMicros(long value) {
        if (this.totalMicros == value) {
            return this;
        }
        long newValue = value;
        return new PercentileMergedAggregate(newValue, this.transactionCount, this.percentileValues);
    }

    public final PercentileMergedAggregate withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        long newValue = value;
        return new PercentileMergedAggregate(this.totalMicros, newValue, this.percentileValues);
    }

    public final PercentileMergedAggregate withPercentileValues(PercentileValue ... elements) {
        ImmutableList<PercentileValue> newValue = ImmutableList.copyOf(elements);
        return new PercentileMergedAggregate(this.totalMicros, this.transactionCount, newValue);
    }

    public final PercentileMergedAggregate withPercentileValues(Iterable<? extends PercentileValue> elements) {
        if (this.percentileValues == elements) {
            return this;
        }
        ImmutableList<PercentileValue> newValue = ImmutableList.copyOf(elements);
        return new PercentileMergedAggregate(this.totalMicros, this.transactionCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PercentileMergedAggregate && this.equalTo((PercentileMergedAggregate)another);
    }

    private boolean equalTo(PercentileMergedAggregate another) {
        return this.totalMicros == another.totalMicros && this.transactionCount == another.transactionCount && this.percentileValues.equals(another.percentileValues);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.totalMicros);
        h = h * 17 + Longs.hashCode(this.transactionCount);
        h = h * 17 + this.percentileValues.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PercentileMergedAggregate").add("totalMicros", this.totalMicros).add("transactionCount", this.transactionCount).add("percentileValues", this.percentileValues).toString();
    }

    @JsonCreator
    public static PercentileMergedAggregate fromAllAttributes(@JsonProperty(value="totalMicros") @Nullable Long totalMicros, @JsonProperty(value="transactionCount") @Nullable Long transactionCount, @JsonProperty(value="percentileValues") @Nullable ImmutableList<PercentileValue> percentileValues) {
        Builder builder = PercentileMergedAggregate.builder();
        if (totalMicros != null) {
            builder.totalMicros(totalMicros);
        }
        if (transactionCount != null) {
            builder.transactionCount(transactionCount);
        }
        if (percentileValues != null) {
            builder.addAllPercentileValues(percentileValues);
        }
        return builder.build();
    }

    public static PercentileMergedAggregate copyOf(AggregateMerging.PercentileMergedAggregateBase instance) {
        if (instance instanceof PercentileMergedAggregate) {
            return (PercentileMergedAggregate)instance;
        }
        return PercentileMergedAggregate.builder().totalMicros(instance.totalMicros()).transactionCount(instance.transactionCount()).addAllPercentileValues(instance.percentileValues()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_TOTAL_MICROS = 1L;
        private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 2L;
        private long initializedBitset;
        private long totalMicros;
        private long transactionCount;
        private ImmutableList.Builder<PercentileValue> percentileValuesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder totalMicros(long totalMicros) {
            this.checkNotIsSet(this.totalMicrosIsSet(), "totalMicros");
            this.totalMicros = totalMicros;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.checkNotIsSet(this.transactionCountIsSet(), "transactionCount");
            this.transactionCount = transactionCount;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addPercentileValues(PercentileValue element) {
            this.percentileValuesBuilder.add((Object)element);
            return this;
        }

        public final Builder addPercentileValues(PercentileValue ... elements) {
            this.percentileValuesBuilder.add(elements);
            return this;
        }

        public final Builder addAllPercentileValues(Iterable<? extends PercentileValue> elements) {
            this.percentileValuesBuilder.addAll(elements);
            return this;
        }

        public PercentileMergedAggregate build() {
            this.checkRequiredAttributes();
            return new PercentileMergedAggregate(this.totalMicros, this.transactionCount, (ImmutableList)this.percentileValuesBuilder.build());
        }

        private boolean totalMicrosIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean transactionCountIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of PercentileMergedAggregate is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.totalMicrosIsSet()) {
                attributes.add("totalMicros");
            }
            if (!this.transactionCountIsSet()) {
                attributes.add("transactionCount");
            }
            return "Cannot build PercentileMergedAggregate, some of required attributes are not set " + attributes;
        }
    }
}

