/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class PluginResponse
extends ConfigJsonService.PluginResponseBase {
    private final String id;
    private final String name;
    private final boolean enabled;

    private PluginResponse(String id, String name, boolean enabled) {
        this.id = id;
        this.name = name;
        this.enabled = enabled;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    public final PluginResponse withId(String value) {
        if (this.id == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PluginResponse(newValue, this.name, this.enabled);
    }

    public final PluginResponse withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PluginResponse(this.id, newValue, this.enabled);
    }

    public final PluginResponse withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        boolean newValue = value;
        return new PluginResponse(this.id, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PluginResponse && this.equalTo((PluginResponse)another);
    }

    private boolean equalTo(PluginResponse another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.enabled == another.enabled;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Booleans.hashCode(this.enabled);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginResponse").add("id", this.id).add("name", this.name).add("enabled", this.enabled).toString();
    }

    @JsonCreator
    public static PluginResponse fromAllAttributes(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="name") @Nullable String name, @JsonProperty(value="enabled") @Nullable Boolean enabled) {
        Builder builder = PluginResponse.builder();
        if (id != null) {
            builder.id(id);
        }
        if (name != null) {
            builder.name(name);
        }
        if (enabled != null) {
            builder.enabled(enabled);
        }
        return builder.build();
    }

    static PluginResponse copyOf(ConfigJsonService.PluginResponseBase instance) {
        if (instance instanceof PluginResponse) {
            return (PluginResponse)instance;
        }
        return PluginResponse.builder().id(instance.id()).name(instance.name()).enabled(instance.enabled()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_ID = 1L;
        private static final long INITIALIZED_BIT_NAME = 2L;
        private static final long INITIALIZED_BIT_ENABLED = 4L;
        private long initializedBitset;
        @Nullable
        private String id;
        @Nullable
        private String name;
        private boolean enabled;

        private Builder() {
        }

        public final Builder id(String id) {
            this.checkNotIsSet(this.idIsSet(), "id");
            this.id = Preconditions.checkNotNull(id);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder name(String name) {
            this.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.checkNotIsSet(this.enabledIsSet(), "enabled");
            this.enabled = enabled;
            this.initializedBitset |= 4L;
            return this;
        }

        public PluginResponse build() {
            this.checkRequiredAttributes();
            return new PluginResponse(this.id, this.name, this.enabled);
        }

        private boolean idIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean enabledIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of PluginResponse is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.enabledIsSet()) {
                attributes.add("enabled");
            }
            return "Cannot build PluginResponse, some of required attributes are not set " + attributes;
        }
    }
}

