/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.JvmJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class RequestWithDirectory
extends JvmJsonService.RequestWithDirectoryBase {
    private final String directory;

    private RequestWithDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    @JsonProperty(value="directory")
    public String directory() {
        return this.directory;
    }

    public final RequestWithDirectory withDirectory(String value) {
        if (this.directory == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new RequestWithDirectory(newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof RequestWithDirectory && this.equalTo((RequestWithDirectory)another);
    }

    private boolean equalTo(RequestWithDirectory another) {
        return this.directory.equals(another.directory);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.directory.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("RequestWithDirectory").add("directory", this.directory).toString();
    }

    @JsonCreator
    public static RequestWithDirectory fromAllAttributes(@JsonProperty(value="directory") @Nullable String directory) {
        Builder builder = RequestWithDirectory.builder();
        if (directory != null) {
            builder.directory(directory);
        }
        return builder.build();
    }

    static RequestWithDirectory copyOf(JvmJsonService.RequestWithDirectoryBase instance) {
        if (instance instanceof RequestWithDirectory) {
            return (RequestWithDirectory)instance;
        }
        return RequestWithDirectory.builder().directory(instance.directory()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_DIRECTORY = 1L;
        private long initializedBitset;
        @Nullable
        private String directory;

        private Builder() {
        }

        public final Builder directory(String directory) {
            this.checkNotIsSet(this.directoryIsSet(), "directory");
            this.directory = Preconditions.checkNotNull(directory);
            this.initializedBitset |= 1L;
            return this;
        }

        public RequestWithDirectory build() {
            this.checkRequiredAttributes();
            return new RequestWithDirectory(this.directory);
        }

        private boolean directoryIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RequestWithDirectory is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.directoryIsSet()) {
                attributes.add("directory");
            }
            return "Cannot build RequestWithDirectory, some of required attributes are not set " + attributes;
        }
    }
}

