/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ErrorJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class TabBarDataRequest
extends ErrorJsonService.TabBarDataRequestBase {
    private final long from;
    private final long to;
    private final String transactionType;
    @Nullable
    private final String transactionName;

    private TabBarDataRequest(long from, long to, String transactionType, @Nullable String transactionName) {
        this.from = from;
        this.to = to;
        this.transactionType = transactionType;
        this.transactionName = transactionName;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    public final TabBarDataRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new TabBarDataRequest(newValue, this.to, this.transactionType, this.transactionName);
    }

    public final TabBarDataRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new TabBarDataRequest(this.from, newValue, this.transactionType, this.transactionName);
    }

    public final TabBarDataRequest withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TabBarDataRequest(this.from, this.to, newValue, this.transactionName);
    }

    public final TabBarDataRequest withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new TabBarDataRequest(this.from, this.to, this.transactionType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TabBarDataRequest && this.equalTo((TabBarDataRequest)another);
    }

    private boolean equalTo(TabBarDataRequest another) {
        return this.from == another.from && this.to == another.to && this.transactionType.equals(another.transactionType) && Objects.equal(this.transactionName, another.transactionName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + Objects.hashCode(this.transactionName);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TabBarDataRequest").add("from", this.from).add("to", this.to).add("transactionType", this.transactionType).add("transactionName", this.transactionName).toString();
    }

    @JsonCreator
    public static TabBarDataRequest fromAllAttributes(@JsonProperty(value="from") @Nullable Long from, @JsonProperty(value="to") @Nullable Long to, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionName") @Nullable String transactionName) {
        Builder builder = TabBarDataRequest.builder();
        if (from != null) {
            builder.from(from);
        }
        if (to != null) {
            builder.to(to);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionName != null) {
            builder.transactionName(transactionName);
        }
        return builder.build();
    }

    static TabBarDataRequest copyOf(ErrorJsonService.TabBarDataRequestBase instance) {
        if (instance instanceof TabBarDataRequest) {
            return (TabBarDataRequest)instance;
        }
        return TabBarDataRequest.builder().from(instance.from()).to(instance.to()).transactionType(instance.transactionType()).transactionName(instance.transactionName()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_FROM = 1L;
        private static final long INITIALIZED_BIT_TO = 2L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 4L;
        private static final long NONDEFAULT_BIT_TRANSACTION_NAME = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        private long from;
        private long to;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionName;

        private Builder() {
        }

        public final Builder from(long from) {
            this.checkNotIsSet(this.fromIsSet(), "from");
            this.from = from;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.checkNotIsSet(this.toIsSet(), "to");
            this.to = to;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.checkNotIsSet(this.transactionTypeIsSet(), "transactionType");
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.checkNotIsSet(this.transactionNameIsSet(), "transactionName");
            this.transactionName = transactionName;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public TabBarDataRequest build() {
            this.checkRequiredAttributes();
            return new TabBarDataRequest(this.from, this.to, this.transactionType, this.transactionName);
        }

        private boolean transactionNameIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TabBarDataRequest is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            return "Cannot build TabBarDataRequest, some of required attributes are not set " + attributes;
        }
    }
}

