/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AnonymousAccess;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class UserInterfaceConfigDto
extends ConfigJsonService.UserInterfaceConfigDtoBase {
    private final int port;
    private final boolean adminPasswordEnabled;
    private final boolean readOnlyPasswordEnabled;
    private final AnonymousAccess anonymousAccess;
    private final String currentAdminPassword;
    private final String newAdminPassword;
    private final String newReadOnlyPassword;
    private final int sessionTimeoutMinutes;
    private final String version;

    private UserInterfaceConfigDto(Builder builder) {
        this.port = builder.port;
        this.adminPasswordEnabled = builder.adminPasswordEnabled;
        this.readOnlyPasswordEnabled = builder.readOnlyPasswordEnabled;
        this.anonymousAccess = builder.anonymousAccess;
        this.sessionTimeoutMinutes = builder.sessionTimeoutMinutes;
        this.version = builder.version;
        this.currentAdminPassword = builder.currentAdminPassword != null ? builder.currentAdminPassword : Preconditions.checkNotNull(super.currentAdminPassword());
        this.newAdminPassword = builder.newAdminPassword != null ? builder.newAdminPassword : Preconditions.checkNotNull(super.newAdminPassword());
        this.newReadOnlyPassword = builder.newReadOnlyPassword != null ? builder.newReadOnlyPassword : Preconditions.checkNotNull(super.newReadOnlyPassword());
    }

    private UserInterfaceConfigDto(int port, boolean adminPasswordEnabled, boolean readOnlyPasswordEnabled, AnonymousAccess anonymousAccess, String currentAdminPassword, String newAdminPassword, String newReadOnlyPassword, int sessionTimeoutMinutes, String version) {
        this.port = port;
        this.adminPasswordEnabled = adminPasswordEnabled;
        this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
        this.anonymousAccess = anonymousAccess;
        this.currentAdminPassword = currentAdminPassword;
        this.newAdminPassword = newAdminPassword;
        this.newReadOnlyPassword = newReadOnlyPassword;
        this.sessionTimeoutMinutes = sessionTimeoutMinutes;
        this.version = version;
    }

    @Override
    @JsonProperty(value="port")
    public int port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="adminPasswordEnabled")
    public boolean adminPasswordEnabled() {
        return this.adminPasswordEnabled;
    }

    @Override
    @JsonProperty(value="readOnlyPasswordEnabled")
    public boolean readOnlyPasswordEnabled() {
        return this.readOnlyPasswordEnabled;
    }

    @Override
    @JsonProperty(value="anonymousAccess")
    public AnonymousAccess anonymousAccess() {
        return this.anonymousAccess;
    }

    @Override
    @JsonProperty(value="currentAdminPassword")
    public String currentAdminPassword() {
        return this.currentAdminPassword;
    }

    @Override
    @JsonProperty(value="newAdminPassword")
    public String newAdminPassword() {
        return this.newAdminPassword;
    }

    @Override
    @JsonProperty(value="newReadOnlyPassword")
    public String newReadOnlyPassword() {
        return this.newReadOnlyPassword;
    }

    @Override
    @JsonProperty(value="sessionTimeoutMinutes")
    public int sessionTimeoutMinutes() {
        return this.sessionTimeoutMinutes;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final UserInterfaceConfigDto withPort(int value) {
        if (this.port == value) {
            return this;
        }
        int newValue = value;
        return new UserInterfaceConfigDto(newValue, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.currentAdminPassword, this.newAdminPassword, this.newReadOnlyPassword, this.sessionTimeoutMinutes, this.version);
    }

    public final UserInterfaceConfigDto withAdminPasswordEnabled(boolean value) {
        if (this.adminPasswordEnabled == value) {
            return this;
        }
        boolean newValue = value;
        return new UserInterfaceConfigDto(this.port, newValue, this.readOnlyPasswordEnabled, this.anonymousAccess, this.currentAdminPassword, this.newAdminPassword, this.newReadOnlyPassword, this.sessionTimeoutMinutes, this.version);
    }

    public final UserInterfaceConfigDto withReadOnlyPasswordEnabled(boolean value) {
        if (this.readOnlyPasswordEnabled == value) {
            return this;
        }
        boolean newValue = value;
        return new UserInterfaceConfigDto(this.port, this.adminPasswordEnabled, newValue, this.anonymousAccess, this.currentAdminPassword, this.newAdminPassword, this.newReadOnlyPassword, this.sessionTimeoutMinutes, this.version);
    }

    public final UserInterfaceConfigDto withAnonymousAccess(AnonymousAccess value) {
        if (this.anonymousAccess == value) {
            return this;
        }
        AnonymousAccess newValue = Preconditions.checkNotNull(value);
        return new UserInterfaceConfigDto(this.port, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, newValue, this.currentAdminPassword, this.newAdminPassword, this.newReadOnlyPassword, this.sessionTimeoutMinutes, this.version);
    }

    public final UserInterfaceConfigDto withCurrentAdminPassword(String value) {
        if (this.currentAdminPassword == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UserInterfaceConfigDto(this.port, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, newValue, this.newAdminPassword, this.newReadOnlyPassword, this.sessionTimeoutMinutes, this.version);
    }

    public final UserInterfaceConfigDto withNewAdminPassword(String value) {
        if (this.newAdminPassword == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UserInterfaceConfigDto(this.port, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.currentAdminPassword, newValue, this.newReadOnlyPassword, this.sessionTimeoutMinutes, this.version);
    }

    public final UserInterfaceConfigDto withNewReadOnlyPassword(String value) {
        if (this.newReadOnlyPassword == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UserInterfaceConfigDto(this.port, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.currentAdminPassword, this.newAdminPassword, newValue, this.sessionTimeoutMinutes, this.version);
    }

    public final UserInterfaceConfigDto withSessionTimeoutMinutes(int value) {
        if (this.sessionTimeoutMinutes == value) {
            return this;
        }
        int newValue = value;
        return new UserInterfaceConfigDto(this.port, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.currentAdminPassword, this.newAdminPassword, this.newReadOnlyPassword, newValue, this.version);
    }

    public final UserInterfaceConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UserInterfaceConfigDto(this.port, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.currentAdminPassword, this.newAdminPassword, this.newReadOnlyPassword, this.sessionTimeoutMinutes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof UserInterfaceConfigDto && this.equalTo((UserInterfaceConfigDto)another);
    }

    private boolean equalTo(UserInterfaceConfigDto another) {
        return this.port == another.port && this.adminPasswordEnabled == another.adminPasswordEnabled && this.readOnlyPasswordEnabled == another.readOnlyPasswordEnabled && this.anonymousAccess.equals((Object)another.anonymousAccess) && this.currentAdminPassword.equals(another.currentAdminPassword) && this.newAdminPassword.equals(another.newAdminPassword) && this.newReadOnlyPassword.equals(another.newReadOnlyPassword) && this.sessionTimeoutMinutes == another.sessionTimeoutMinutes && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.port;
        h = h * 17 + Booleans.hashCode(this.adminPasswordEnabled);
        h = h * 17 + Booleans.hashCode(this.readOnlyPasswordEnabled);
        h = h * 17 + this.anonymousAccess.hashCode();
        h = h * 17 + this.currentAdminPassword.hashCode();
        h = h * 17 + this.newAdminPassword.hashCode();
        h = h * 17 + this.newReadOnlyPassword.hashCode();
        h = h * 17 + this.sessionTimeoutMinutes;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("UserInterfaceConfigDto").add("port", this.port).add("adminPasswordEnabled", this.adminPasswordEnabled).add("readOnlyPasswordEnabled", this.readOnlyPasswordEnabled).add("anonymousAccess", (Object)this.anonymousAccess).add("currentAdminPassword", this.currentAdminPassword).add("newAdminPassword", this.newAdminPassword).add("newReadOnlyPassword", this.newReadOnlyPassword).add("sessionTimeoutMinutes", this.sessionTimeoutMinutes).add("version", this.version).toString();
    }

    @JsonCreator
    public static UserInterfaceConfigDto fromAllAttributes(@JsonProperty(value="port") @Nullable Integer port, @JsonProperty(value="adminPasswordEnabled") @Nullable Boolean adminPasswordEnabled, @JsonProperty(value="readOnlyPasswordEnabled") @Nullable Boolean readOnlyPasswordEnabled, @JsonProperty(value="anonymousAccess") @Nullable AnonymousAccess anonymousAccess, @JsonProperty(value="currentAdminPassword") @Nullable String currentAdminPassword, @JsonProperty(value="newAdminPassword") @Nullable String newAdminPassword, @JsonProperty(value="newReadOnlyPassword") @Nullable String newReadOnlyPassword, @JsonProperty(value="sessionTimeoutMinutes") @Nullable Integer sessionTimeoutMinutes, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = UserInterfaceConfigDto.builder();
        if (port != null) {
            builder.port(port);
        }
        if (adminPasswordEnabled != null) {
            builder.adminPasswordEnabled(adminPasswordEnabled);
        }
        if (readOnlyPasswordEnabled != null) {
            builder.readOnlyPasswordEnabled(readOnlyPasswordEnabled);
        }
        if (anonymousAccess != null) {
            builder.anonymousAccess(anonymousAccess);
        }
        if (currentAdminPassword != null) {
            builder.currentAdminPassword(currentAdminPassword);
        }
        if (newAdminPassword != null) {
            builder.newAdminPassword(newAdminPassword);
        }
        if (newReadOnlyPassword != null) {
            builder.newReadOnlyPassword(newReadOnlyPassword);
        }
        if (sessionTimeoutMinutes != null) {
            builder.sessionTimeoutMinutes(sessionTimeoutMinutes);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static UserInterfaceConfigDto copyOf(ConfigJsonService.UserInterfaceConfigDtoBase instance) {
        if (instance instanceof UserInterfaceConfigDto) {
            return (UserInterfaceConfigDto)instance;
        }
        return UserInterfaceConfigDto.builder().port(instance.port()).adminPasswordEnabled(instance.adminPasswordEnabled()).readOnlyPasswordEnabled(instance.readOnlyPasswordEnabled()).anonymousAccess(instance.anonymousAccess()).currentAdminPassword(instance.currentAdminPassword()).newAdminPassword(instance.newAdminPassword()).newReadOnlyPassword(instance.newReadOnlyPassword()).sessionTimeoutMinutes(instance.sessionTimeoutMinutes()).version(instance.version()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 63L;
        private static final long INITIALIZED_BIT_PORT = 1L;
        private static final long INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED = 2L;
        private static final long INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED = 4L;
        private static final long INITIALIZED_BIT_ANONYMOUS_ACCESS = 8L;
        private static final long INITIALIZED_BIT_SESSION_TIMEOUT_MINUTES = 16L;
        private static final long INITIALIZED_BIT_VERSION = 32L;
        private static final long NONDEFAULT_BIT_CURRENT_ADMIN_PASSWORD = 1L;
        private static final long NONDEFAULT_BIT_NEW_ADMIN_PASSWORD = 2L;
        private static final long NONDEFAULT_BIT_NEW_READ_ONLY_PASSWORD = 4L;
        private long initializedBitset;
        private long nondefaultBitset;
        private int port;
        private boolean adminPasswordEnabled;
        private boolean readOnlyPasswordEnabled;
        @Nullable
        private AnonymousAccess anonymousAccess;
        @Nullable
        private String currentAdminPassword;
        @Nullable
        private String newAdminPassword;
        @Nullable
        private String newReadOnlyPassword;
        private int sessionTimeoutMinutes;
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder port(int port) {
            this.checkNotIsSet(this.portIsSet(), "port");
            this.port = port;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder adminPasswordEnabled(boolean adminPasswordEnabled) {
            this.checkNotIsSet(this.adminPasswordEnabledIsSet(), "adminPasswordEnabled");
            this.adminPasswordEnabled = adminPasswordEnabled;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder readOnlyPasswordEnabled(boolean readOnlyPasswordEnabled) {
            this.checkNotIsSet(this.readOnlyPasswordEnabledIsSet(), "readOnlyPasswordEnabled");
            this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder anonymousAccess(AnonymousAccess anonymousAccess) {
            this.checkNotIsSet(this.anonymousAccessIsSet(), "anonymousAccess");
            this.anonymousAccess = Preconditions.checkNotNull(anonymousAccess);
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder currentAdminPassword(String currentAdminPassword) {
            this.checkNotIsSet(this.currentAdminPasswordIsSet(), "currentAdminPassword");
            this.currentAdminPassword = Preconditions.checkNotNull(currentAdminPassword);
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder newAdminPassword(String newAdminPassword) {
            this.checkNotIsSet(this.newAdminPasswordIsSet(), "newAdminPassword");
            this.newAdminPassword = Preconditions.checkNotNull(newAdminPassword);
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder newReadOnlyPassword(String newReadOnlyPassword) {
            this.checkNotIsSet(this.newReadOnlyPasswordIsSet(), "newReadOnlyPassword");
            this.newReadOnlyPassword = Preconditions.checkNotNull(newReadOnlyPassword);
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder sessionTimeoutMinutes(int sessionTimeoutMinutes) {
            this.checkNotIsSet(this.sessionTimeoutMinutesIsSet(), "sessionTimeoutMinutes");
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
            this.initializedBitset |= 0x10L;
            return this;
        }

        public final Builder version(String version) {
            this.checkNotIsSet(this.versionIsSet(), "version");
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 0x20L;
            return this;
        }

        public UserInterfaceConfigDto build() {
            this.checkRequiredAttributes();
            return new UserInterfaceConfigDto(this);
        }

        private boolean currentAdminPasswordIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean newAdminPasswordIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean newReadOnlyPasswordIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean portIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean adminPasswordEnabledIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean readOnlyPasswordEnabledIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean anonymousAccessIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean sessionTimeoutMinutesIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 0x20L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of UserInterfaceConfigDto is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 63L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.portIsSet()) {
                attributes.add("port");
            }
            if (!this.adminPasswordEnabledIsSet()) {
                attributes.add("adminPasswordEnabled");
            }
            if (!this.readOnlyPasswordEnabledIsSet()) {
                attributes.add("readOnlyPasswordEnabled");
            }
            if (!this.anonymousAccessIsSet()) {
                attributes.add("anonymousAccess");
            }
            if (!this.sessionTimeoutMinutesIsSet()) {
                attributes.add("sessionTimeoutMinutes");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build UserInterfaceConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

