/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.command.ddl;

import org.glowroot.shaded.h2.command.ddl.DefineCommand;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.engine.User;
import org.glowroot.shaded.h2.expression.Expression;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.security.SHA256;
import org.glowroot.shaded.h2.util.StringUtils;

public class CreateUser
extends DefineCommand {
    private String userName;
    private boolean admin;
    private Expression password;
    private Expression salt;
    private Expression hash;
    private boolean ifNotExists;
    private String comment;

    public CreateUser(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setPassword(Expression expression) {
        this.password = expression;
    }

    private char[] getCharArray(Expression expression) {
        return expression.optimize(this.session).getValue(this.session).getString().toCharArray();
    }

    private byte[] getByteArray(Expression expression) {
        return StringUtils.convertHexToBytes(expression.optimize(this.session).getValue(this.session).getString());
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (database.findRole(this.userName) != null) {
            throw DbException.get(90069, this.userName);
        }
        if (database.findUser(this.userName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90033, this.userName);
        }
        int n = this.getObjectId();
        User user = new User(database, n, this.userName, false);
        user.setAdmin(this.admin);
        user.setComment(this.comment);
        if (this.hash != null && this.salt != null) {
            user.setSaltAndHash(this.getByteArray(this.salt), this.getByteArray(this.hash));
        } else if (this.password != null) {
            char[] cArray = this.getCharArray(this.password);
            byte[] byArray = this.userName.length() == 0 && cArray.length == 0 ? new byte[]{} : SHA256.getKeyPasswordHash(this.userName, cArray);
            user.setUserPasswordHash(byArray);
        } else {
            throw DbException.throwInternalError();
        }
        database.addDatabaseObject(this.session, user);
        return 0;
    }

    public void setSalt(Expression expression) {
        this.salt = expression;
    }

    public void setHash(Expression expression) {
        this.hash = expression;
    }

    public void setAdmin(boolean bl) {
        this.admin = bl;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public int getType() {
        return 32;
    }
}

