/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.index;

import java.util.ArrayList;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.index.Cursor;
import org.glowroot.shaded.h2.result.Row;
import org.glowroot.shaded.h2.result.SearchRow;
import org.glowroot.shaded.h2.table.RegularTable;

public class NonUniqueHashCursor
implements Cursor {
    private final Session session;
    private final ArrayList<Long> positions;
    private final RegularTable tableData;
    private int index = -1;

    public NonUniqueHashCursor(Session session, RegularTable regularTable, ArrayList<Long> arrayList) {
        this.session = session;
        this.tableData = regularTable;
        this.positions = arrayList;
    }

    @Override
    public Row get() {
        if (this.index < 0 || this.index >= this.positions.size()) {
            return null;
        }
        return this.tableData.getRow(this.session, this.positions.get(this.index));
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        return this.positions != null && ++this.index < this.positions.size();
    }

    @Override
    public boolean previous() {
        return this.positions != null && --this.index >= 0;
    }
}

