/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.store;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import org.glowroot.shaded.h2.engine.ConnectionInfo;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.store.fs.FilePathRec;
import org.glowroot.shaded.h2.store.fs.FileUtils;
import org.glowroot.shaded.h2.store.fs.Recorder;
import org.glowroot.shaded.h2.tools.Recover;
import org.glowroot.shaded.h2.util.IOUtils;
import org.glowroot.shaded.h2.util.New;
import org.glowroot.shaded.h2.util.StringUtils;
import org.glowroot.shaded.h2.util.Utils;

public class RecoverTester
implements Recorder {
    private static RecoverTester instance;
    private String testDatabase = "memFS:reopen";
    private int writeCount = Utils.getProperty("h2.recoverTestOffset", 0);
    private int testEvery = Utils.getProperty("h2.recoverTest", 64);
    private final long maxFileSize = (long)Utils.getProperty("h2.recoverTestMaxFileSize", Integer.MAX_VALUE) * 1024L * 1024L;
    private int verifyCount;
    private final HashSet<String> knownErrors = New.hashSet();
    private volatile boolean testing;

    public static synchronized void init(String string) {
        RecoverTester recoverTester = RecoverTester.getInstance();
        if (StringUtils.isNumber(string)) {
            recoverTester.setTestEvery(Integer.parseInt(string));
        }
        FilePathRec.setRecorder(recoverTester);
    }

    public static synchronized RecoverTester getInstance() {
        if (instance == null) {
            instance = new RecoverTester();
        }
        return instance;
    }

    @Override
    public void log(int n, String string, byte[] byArray, long l) {
        if (n != 8 && n != 7) {
            return;
        }
        if (!string.endsWith(".h2.db") && !string.endsWith(".mv.db")) {
            return;
        }
        ++this.writeCount;
        if (this.writeCount % this.testEvery != 0) {
            return;
        }
        if (FileUtils.size(string) > this.maxFileSize) {
            return;
        }
        if (this.testing) {
            return;
        }
        this.testing = true;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(FileUtils.newOutputStream(string + ".log", true)));
            this.testDatabase(string, printWriter);
        }
        catch (IOException iOException) {
            try {
                throw DbException.convertIOException(iOException, null);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(printWriter);
                this.testing = false;
                throw throwable;
            }
        }
        IOUtils.closeSilently(printWriter);
        this.testing = false;
    }

    private synchronized void testDatabase(String string, PrintWriter printWriter) {
        printWriter.println("+ write #" + this.writeCount + " verify #" + this.verifyCount);
        try {
            IOUtils.copyFiles(string, this.testDatabase + ".h2.db");
            String string2 = string.substring(0, string.length() - ".h2.db".length()) + ".mv.db";
            if (FileUtils.exists(string2)) {
                IOUtils.copyFiles(string2, this.testDatabase + ".mv.db");
            }
            ++this.verifyCount;
            Properties properties = new Properties();
            properties.setProperty("user", "");
            properties.setProperty("password", "");
            ConnectionInfo connectionInfo = new ConnectionInfo("jdbc:h2:" + this.testDatabase + ";FILE_LOCK=NO;TRACE_LEVEL_FILE=0", properties);
            Database database = new Database(connectionInfo, null);
            Session session = database.getSystemSession();
            session.prepare("script to '" + this.testDatabase + ".sql'").query(0);
            session.prepare("shutdown immediately").update();
            database.removeSession(null);
            return;
        }
        catch (DbException dbException) {
            SQLException sQLException = DbException.toSQLException(dbException);
            int n = sQLException.getErrorCode();
            if (n == 28000) {
                return;
            }
            if (n == 90049) {
                return;
            }
            dbException.printStackTrace(System.out);
        }
        catch (Exception exception) {
            int n = 0;
            if (exception instanceof SQLException) {
                n = ((SQLException)exception).getErrorCode();
            }
            if (n == 28000) {
                return;
            }
            if (n == 90049) {
                return;
            }
            exception.printStackTrace(System.out);
        }
        printWriter.println("begin ------------------------------ " + this.writeCount);
        try {
            Recover.execute(string.substring(0, string.lastIndexOf(47)), null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.testDatabase = this.testDatabase + "X";
        try {
            IOUtils.copyFiles(string, this.testDatabase + ".h2.db");
            Properties properties = new Properties();
            ConnectionInfo connectionInfo = new ConnectionInfo("jdbc:h2:" + this.testDatabase + ";FILE_LOCK=NO", properties);
            Database database = new Database(connectionInfo, null);
            database.removeSession(null);
        }
        catch (Exception exception) {
            SQLException sQLException;
            int n = 0;
            if (exception instanceof DbException) {
                sQLException = ((DbException)exception).getSQLException();
                n = sQLException.getErrorCode();
            }
            if (n == 28000) {
                return;
            }
            if (n == 90049) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            StackTraceElement[] stackTraceElementArray = sQLException.getStackTrace();
            for (int i = 0; i < 10 && i < stackTraceElementArray.length; ++i) {
                stringBuilder.append(stackTraceElementArray[i].toString()).append('\n');
            }
            String string3 = stringBuilder.toString();
            if (!this.knownErrors.contains(string3)) {
                printWriter.println(this.writeCount + " code: " + n + " " + sQLException.toString());
                sQLException.printStackTrace(System.out);
                this.knownErrors.add(string3);
            }
            printWriter.println(this.writeCount + " code: " + n);
        }
    }

    public void setTestEvery(int n) {
        this.testEvery = n;
    }
}

