/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.glowroot.shaded.h2.engine.Constants;
import org.glowroot.shaded.h2.engine.SysProperties;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.store.fs.FileUtils;
import org.glowroot.shaded.h2.util.IOUtils;
import org.glowroot.shaded.h2.util.New;
import org.glowroot.shaded.h2.util.StringUtils;
import org.glowroot.shaded.h2.util.Task;
import org.glowroot.shaded.h2.util.Utils;

public class SourceCompiler {
    static final JavaCompiler JAVA_COMPILER;
    private static final Class<?> JAVAC_SUN;
    private static final String COMPILE_DIR;
    final HashMap<String, String> sources = New.hashMap();
    final HashMap<String, Class<?>> compiled = New.hashMap();
    boolean useJavaSystemCompiler = SysProperties.JAVA_SYSTEM_COMPILER;

    public void setSource(String string, String string2) {
        this.sources.put(string, string2);
        this.compiled.clear();
    }

    public void setJavaSystemCompiler(boolean bl) {
        this.useJavaSystemCompiler = bl;
    }

    public Class<?> getClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.compiled.get(string);
        if (clazz != null) {
            return clazz;
        }
        String string2 = this.sources.get(string);
        if (SourceCompiler.isGroovySource(string2)) {
            Class<?> clazz2 = GroovyCompiler.parseClass(string2, string);
            this.compiled.put(string, clazz2);
            return clazz2;
        }
        ClassLoader classLoader = new ClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> findClass(String string) throws ClassNotFoundException {
                Class<?> clazz = SourceCompiler.this.compiled.get(string);
                if (clazz == null) {
                    byte[] byArray;
                    String string2;
                    String string3 = SourceCompiler.this.sources.get(string);
                    String string4 = null;
                    int n = string.lastIndexOf(46);
                    if (n >= 0) {
                        string4 = string.substring(0, n);
                        string2 = string.substring(n + 1);
                    } else {
                        string2 = string;
                    }
                    String string5 = SourceCompiler.getCompleteSourceCode(string4, string2, string3);
                    clazz = JAVA_COMPILER != null && SourceCompiler.this.useJavaSystemCompiler ? SourceCompiler.this.javaxToolsJavac(string4, string2, string5) : ((byArray = SourceCompiler.this.javacCompile(string4, string2, string5)) == null ? this.findSystemClass(string) : this.defineClass(string, byArray, 0, byArray.length));
                    SourceCompiler.this.compiled.put(string, clazz);
                }
                return clazz;
            }
        };
        return classLoader.loadClass(string);
    }

    private static boolean isGroovySource(String string) {
        return string.startsWith("//groovy") || string.startsWith("@groovy");
    }

    public Method getMethod(String string) throws ClassNotFoundException {
        Method[] methodArray;
        Class<?> clazz = this.getClass(string);
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            String string2;
            int n = method.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n) || (string2 = method.getName()).startsWith("_") || method.getName().equals("main")) continue;
            return method;
        }
        return null;
    }

    byte[] javacCompile(String string, String string2, String string3) {
        File file = new File(COMPILE_DIR);
        if (string != null) {
            file = new File(file, string.replace('.', '/'));
            FileUtils.createDirectories(file.getAbsolutePath());
        }
        File file2 = new File(file, string2 + ".java");
        File file3 = new File(file, string2 + ".class");
        try {
            OutputStream outputStream = FileUtils.newOutputStream(file2.getAbsolutePath(), false);
            Writer writer = IOUtils.getBufferedWriter(outputStream);
            file3.delete();
            writer.write(string3);
            writer.close();
            if (JAVAC_SUN != null) {
                SourceCompiler.javacSun(file2);
            } else {
                SourceCompiler.javacProcess(file2);
            }
            byte[] byArray = new byte[(int)file3.length()];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file3));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
        finally {
            file2.delete();
            file3.delete();
        }
    }

    static String getCompleteSourceCode(String string, String string2, String string3) {
        if (string3.startsWith("package ")) {
            return string3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append("package ").append(string).append(";\n");
        }
        int n = string3.indexOf("@CODE");
        String string4 = "import java.util.*;\nimport java.math.*;\nimport java.sql.*;\n";
        if (n >= 0) {
            string4 = string3.substring(0, n);
            string3 = string3.substring("@CODE".length() + n);
        }
        stringBuilder.append(string4);
        stringBuilder.append("public class ").append(string2).append(" {\n    public static ").append(string3).append("\n}\n");
        return stringBuilder.toString();
    }

    Class<?> javaxToolsJavac(String string, String string2, String string3) {
        String string4 = string + "." + string2;
        StringWriter stringWriter = new StringWriter();
        ClassFileManager classFileManager = new ClassFileManager(JAVA_COMPILER.getStandardFileManager(null, null, null));
        ArrayList<StringJavaFileObject> arrayList = new ArrayList<StringJavaFileObject>();
        arrayList.add(new StringJavaFileObject(string4, string3));
        JAVA_COMPILER.getTask(stringWriter, classFileManager, null, null, null, arrayList).call();
        String string5 = stringWriter.toString();
        SourceCompiler.throwSyntaxError(string5);
        try {
            return classFileManager.getClassLoader(null).loadClass(string4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw DbException.convert(classNotFoundException);
        }
    }

    private static void javacProcess(File file) {
        SourceCompiler.exec("javac", "-sourcepath", COMPILE_DIR, "-d", COMPILE_DIR, "-encoding", "UTF-8", file.getAbsolutePath());
    }

    private static int exec(String ... stringArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.environment().remove("JAVA_TOOL_OPTIONS");
            processBuilder.command(stringArray);
            Process process = processBuilder.start();
            SourceCompiler.copyInThread(process.getInputStream(), byteArrayOutputStream);
            SourceCompiler.copyInThread(process.getErrorStream(), byteArrayOutputStream);
            process.waitFor();
            String string = new String(byteArrayOutputStream.toByteArray(), Constants.UTF8);
            SourceCompiler.throwSyntaxError(string);
            return process.exitValue();
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    private static void copyInThread(final InputStream inputStream, final OutputStream outputStream) {
        new Task(){

            @Override
            public void call() throws IOException {
                IOUtils.copy(inputStream, outputStream);
            }
        }.execute();
    }

    private static void javacSun(File file) {
        PrintStream printStream = System.err;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
        try {
            System.setErr(printStream2);
            Method method = JAVAC_SUN.getMethod("compile", String[].class);
            Object obj = JAVAC_SUN.newInstance();
            method.invoke(obj, new Object[]{new String[]{"-sourcepath", COMPILE_DIR, "-d", COMPILE_DIR, "-encoding", "UTF-8", file.getAbsolutePath()}});
            String string = new String(byteArrayOutputStream.toByteArray(), Constants.UTF8);
            SourceCompiler.throwSyntaxError(string);
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
        finally {
            System.setErr(printStream);
        }
    }

    private static void throwSyntaxError(String string) {
        if (!string.startsWith("Note:") && string.length() > 0) {
            string = StringUtils.replaceAll(string, COMPILE_DIR, "");
            throw DbException.get(42000, string);
        }
    }

    static {
        Class<?> clazz;
        JavaCompiler javaCompiler;
        COMPILE_DIR = Utils.getProperty("java.io.tmpdir", ".");
        try {
            javaCompiler = ToolProvider.getSystemJavaCompiler();
        }
        catch (Exception exception) {
            javaCompiler = null;
        }
        JAVA_COMPILER = javaCompiler;
        try {
            clazz = Class.forName("com.sun.tools.javac.Main");
        }
        catch (Exception exception) {
            clazz = null;
        }
        JAVAC_SUN = clazz;
    }

    static class ClassFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        JavaClassObject classObject;

        public ClassFileManager(StandardJavaFileManager standardJavaFileManager) {
            super(standardJavaFileManager);
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return new SecureClassLoader(){

                @Override
                protected Class<?> findClass(String string) throws ClassNotFoundException {
                    byte[] byArray = ClassFileManager.this.classObject.getBytes();
                    return super.defineClass(string, byArray, 0, byArray.length);
                }
            };
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
            this.classObject = new JavaClassObject(string, kind);
            return this.classObject;
        }
    }

    static class JavaClassObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();

        public JavaClassObject(String string, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + string.replace('.', '/') + kind.extension), kind);
        }

        public byte[] getBytes() {
            return this.out.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.out;
        }
    }

    static class StringJavaFileObject
    extends SimpleJavaFileObject {
        private final String sourceCode;

        public StringJavaFileObject(String string, String string2) {
            super(URI.create("string:///" + string.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.sourceCode = string2;
        }

        @Override
        public CharSequence getCharContent(boolean bl) {
            return this.sourceCode;
        }
    }

    private static final class GroovyCompiler {
        private static final Object LOADER;
        private static final Throwable INIT_FAIL_EXCEPTION;

        private GroovyCompiler() {
        }

        public static Class<?> parseClass(String string, String string2) {
            if (LOADER == null) {
                throw new RuntimeException("Compile fail: no Groovy jar in the classpath", INIT_FAIL_EXCEPTION);
            }
            try {
                Object object = Utils.newInstance("groovy.lang.GroovyCodeSource", string, string2 + ".groovy", "UTF-8");
                Utils.callMethod(object, "setCachable", false);
                Class clazz = (Class)Utils.callMethod(LOADER, "parseClass", object);
                return clazz;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        static {
            Object object = null;
            Exception exception = null;
            try {
                Class<?> clazz = Class.forName("org.codehaus.groovy.control.customizers.ImportCustomizer");
                Object object2 = Utils.newInstance("org.codehaus.groovy.control.customizers.ImportCustomizer", new Object[0]);
                String[] stringArray = new String[]{"java.sql.Connection", "java.sql.Types", "java.sql.ResultSet", "groovy.sql.Sql", "org.glowroot.shaded.h2.tools.SimpleResultSet"};
                Utils.callMethod(object2, "addImports", new Object[]{stringArray});
                Object object3 = Array.newInstance(clazz, 1);
                Array.set(object3, 0, object2);
                Object object4 = Utils.newInstance("org.codehaus.groovy.control.CompilerConfiguration", new Object[0]);
                Utils.callMethod(object4, "addCompilationCustomizers", object3);
                ClassLoader classLoader = GroovyCompiler.class.getClassLoader();
                object = Utils.newInstance("groovy.lang.GroovyClassLoader", classLoader, object4);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            LOADER = object;
            INIT_FAIL_EXCEPTION = exception;
        }
    }
}

