/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.netty.handler.codec.sctp;

import java.util.List;
import org.glowroot.shaded.netty.buffer.ByteBuf;
import org.glowroot.shaded.netty.channel.ChannelHandlerContext;
import org.glowroot.shaded.netty.channel.sctp.SctpMessage;
import org.glowroot.shaded.netty.handler.codec.MessageToMessageEncoder;

public class SctpOutboundByteStreamHandler
extends MessageToMessageEncoder<ByteBuf> {
    private final int streamIdentifier;
    private final int protocolIdentifier;
    private final boolean unordered;

    public SctpOutboundByteStreamHandler(int streamIdentifier, int protocolIdentifier) {
        this(streamIdentifier, protocolIdentifier, false);
    }

    public SctpOutboundByteStreamHandler(int streamIdentifier, int protocolIdentifier, boolean unordered) {
        this.streamIdentifier = streamIdentifier;
        this.protocolIdentifier = protocolIdentifier;
        this.unordered = unordered;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(new SctpMessage(this.streamIdentifier, this.protocolIdentifier, this.unordered, msg.retain()));
    }
}

