/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.qos.logback.classic.joran.action;

import org.glowroot.shaded.qos.logback.classic.LoggerContext;
import org.glowroot.shaded.qos.logback.classic.turbo.ReconfigureOnChangeFilter;
import org.glowroot.shaded.qos.logback.classic.util.EnvUtil;
import org.glowroot.shaded.qos.logback.core.joran.action.Action;
import org.glowroot.shaded.qos.logback.core.joran.spi.InterpretationContext;
import org.glowroot.shaded.qos.logback.core.status.OnConsoleStatusListener;
import org.glowroot.shaded.qos.logback.core.util.ContextUtil;
import org.glowroot.shaded.qos.logback.core.util.Duration;
import org.glowroot.shaded.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class ConfigurationAction
extends Action {
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String SCAN_ATTR = "scan";
    static final String SCAN_PERIOD_ATTR = "scanPeriod";
    static final String DEBUG_SYSTEM_PROPERTY_KEY = "logback.debug";
    long threshold = 0L;

    @Override
    public void begin(InterpretationContext ic, String name, Attributes attributes) {
        this.threshold = System.currentTimeMillis();
        String debugAttrib = this.getSystemProperty(DEBUG_SYSTEM_PROPERTY_KEY);
        if (debugAttrib == null) {
            debugAttrib = ic.subst(attributes.getValue(INTERNAL_DEBUG_ATTR));
        }
        if (OptionHelper.isEmpty(debugAttrib) || debugAttrib.equalsIgnoreCase("false") || debugAttrib.equalsIgnoreCase("null")) {
            this.addInfo("debug attribute not set");
        } else {
            OnConsoleStatusListener.addNewInstanceToContext(this.context);
        }
        this.processScanAttrib(ic, attributes);
        ContextUtil contextUtil = new ContextUtil(this.context);
        contextUtil.addHostNameAsProperty();
        if (EnvUtil.isGroovyAvailable()) {
            LoggerContext lc = (LoggerContext)this.context;
            contextUtil.addGroovyPackages(lc.getFrameworkPackages());
        }
        ic.pushObject(this.getContext());
    }

    String getSystemProperty(String name) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    void processScanAttrib(InterpretationContext ic, Attributes attributes) {
        String scanAttrib = ic.subst(attributes.getValue(SCAN_ATTR));
        if (!OptionHelper.isEmpty(scanAttrib) && !"false".equalsIgnoreCase(scanAttrib)) {
            ReconfigureOnChangeFilter rocf = new ReconfigureOnChangeFilter();
            rocf.setContext(this.context);
            String scanPeriodAttrib = ic.subst(attributes.getValue(SCAN_PERIOD_ATTR));
            if (!OptionHelper.isEmpty(scanPeriodAttrib)) {
                try {
                    Duration duration = Duration.valueOf(scanPeriodAttrib);
                    rocf.setRefreshPeriod(duration.getMilliseconds());
                    this.addInfo("Setting ReconfigureOnChangeFilter scanning period to " + duration);
                }
                catch (NumberFormatException nfe) {
                    this.addError("Error while converting [" + scanAttrib + "] to long", nfe);
                }
            }
            rocf.start();
            LoggerContext lc = (LoggerContext)this.context;
            this.addInfo("Adding ReconfigureOnChangeFilter as a turbo filter");
            lc.addTurboFilter(rocf);
        }
    }

    @Override
    public void end(InterpretationContext ec, String name) {
        this.addInfo("End of configuration.");
        ec.popObject();
    }
}

