/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import org.glowroot.common.ScheduledRunnable;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.model.Transaction;

class ImmediateTraceStoreRunnable
extends ScheduledRunnable {
    private static final Logger logger = LoggerFactory.getLogger(ImmediateTraceStoreRunnable.class);
    private final Transaction transaction;
    private final TransactionCollector transactionCollector;
    private volatile boolean transactionPreviouslyCompleted;

    ImmediateTraceStoreRunnable(Transaction transaction, TransactionCollector transactionCollector) {
        this.transaction = transaction;
        this.transactionCollector = transactionCollector;
    }

    @Override
    public void runInternal() {
        logger.debug("run(): trace.id={}", (Object)this.transaction.getId());
        if (this.transaction.isCompleted()) {
            if (this.transactionPreviouslyCompleted) {
                throw new ScheduledRunnable.TerminateSubsequentExecutionsException();
            }
            this.transactionPreviouslyCompleted = true;
            return;
        }
        this.transactionCollector.storePartialTrace(this.transaction);
    }
}

