/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.model.ProfileNode;

@ParametersAreNonnullByDefault
@Immutable
final class MatchedNodePair
extends ProfileNode.MatchedNodePairBase {
    private final ProfileNode leftNode;
    private final ProfileNode rightNode;

    private MatchedNodePair(ProfileNode leftNode, ProfileNode rightNode) {
        this.leftNode = leftNode;
        this.rightNode = rightNode;
    }

    @Override
    @JsonProperty(value="leftNode")
    public ProfileNode leftNode() {
        return this.leftNode;
    }

    @Override
    @JsonProperty(value="rightNode")
    public ProfileNode rightNode() {
        return this.rightNode;
    }

    public final MatchedNodePair withLeftNode(ProfileNode value) {
        if (this.leftNode == value) {
            return this;
        }
        ProfileNode newValue = Preconditions.checkNotNull(value);
        return new MatchedNodePair(newValue, this.rightNode);
    }

    public final MatchedNodePair withRightNode(ProfileNode value) {
        if (this.rightNode == value) {
            return this;
        }
        ProfileNode newValue = Preconditions.checkNotNull(value);
        return new MatchedNodePair(this.leftNode, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MatchedNodePair && this.equalTo((MatchedNodePair)another);
    }

    private boolean equalTo(MatchedNodePair another) {
        return this.leftNode.equals(another.leftNode) && this.rightNode.equals(another.rightNode);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.leftNode.hashCode();
        h = h * 17 + this.rightNode.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MatchedNodePair").add("leftNode", this.leftNode).add("rightNode", this.rightNode).toString();
    }

    @JsonCreator
    public static MatchedNodePair fromAllAttributes(@JsonProperty(value="leftNode") @Nullable ProfileNode leftNode, @JsonProperty(value="rightNode") @Nullable ProfileNode rightNode) {
        Builder builder = MatchedNodePair.builder();
        if (leftNode != null) {
            builder.leftNode(leftNode);
        }
        if (rightNode != null) {
            builder.rightNode(rightNode);
        }
        return builder.build();
    }

    public static MatchedNodePair of(ProfileNode leftNode, ProfileNode rightNode) {
        return new MatchedNodePair(leftNode, rightNode);
    }

    static MatchedNodePair copyOf(ProfileNode.MatchedNodePairBase instance) {
        if (instance instanceof MatchedNodePair) {
            return (MatchedNodePair)instance;
        }
        return MatchedNodePair.builder().leftNode(instance.leftNode()).rightNode(instance.rightNode()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_LEFT_NODE = 1L;
        private static final long INITIALIZED_BIT_RIGHT_NODE = 2L;
        private long initializedBitset;
        @Nullable
        private ProfileNode leftNode;
        @Nullable
        private ProfileNode rightNode;

        private Builder() {
        }

        public final Builder leftNode(ProfileNode leftNode) {
            this.checkNotIsSet(this.leftNodeIsSet(), "leftNode");
            this.leftNode = Preconditions.checkNotNull(leftNode);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder rightNode(ProfileNode rightNode) {
            this.checkNotIsSet(this.rightNodeIsSet(), "rightNode");
            this.rightNode = Preconditions.checkNotNull(rightNode);
            this.initializedBitset |= 2L;
            return this;
        }

        public MatchedNodePair build() {
            this.checkRequiredAttributes();
            return new MatchedNodePair(this.leftNode, this.rightNode);
        }

        private boolean leftNodeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean rightNodeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of MatchedNodePair is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.leftNodeIsSet()) {
                attributes.add("leftNode");
            }
            if (!this.rightNodeIsSet()) {
                attributes.add("rightNode");
            }
            return "Cannot build MatchedNodePair, some of required attributes are not set " + attributes;
        }
    }
}

