/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.common.Styles;
import org.glowroot.common.Traverser;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.core.JsonParser;
import org.glowroot.shaded.fasterxml.jackson.core.JsonToken;
import org.glowroot.shaded.fasterxml.jackson.core.SerializableString;
import org.glowroot.shaded.fasterxml.jackson.core.io.SerializedString;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.model.MatchedNodePair;
import org.immutables.value.Value;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ProfileNode
implements Iterable<ProfileNode> {
    @Nullable
    private final Object stackTraceElementObj;
    @Nullable
    private final String leafThreadState;
    private long sampleCount;
    @Nullable
    private ImmutableList<String> timerNames;
    @Nullable
    private Object childNodes;
    private int ellipsedSampleCount;
    private boolean matched;

    public static ProfileNode createSyntheticRoot() {
        return new ProfileNode(null, null);
    }

    public static ProfileNode create(Object stackTraceElementObj, @Nullable String leafThreadState) {
        return new ProfileNode(stackTraceElementObj, leafThreadState);
    }

    private ProfileNode(@Nullable Object stackTraceElementObj, @Nullable String leafThreadState) {
        this.stackTraceElementObj = stackTraceElementObj;
        this.leafThreadState = leafThreadState;
    }

    public void addChildNode(ProfileNode node) {
        if (this.childNodes == null) {
            this.childNodes = node;
        } else if (this.childNodes instanceof ProfileNode) {
            ArrayList<ProfileNode> list = Lists.newArrayListWithCapacity(2);
            list.add((ProfileNode)Preconditions.checkNotNull(this.childNodes));
            list.add(node);
            this.childNodes = list;
        } else {
            ((List)this.childNodes).add(node);
        }
    }

    public void setTimerNames(ImmutableList<String> timerNames) {
        this.timerNames = timerNames;
    }

    public void incrementSampleCount(long num) {
        this.sampleCount += num;
    }

    public void incrementEllipsedSampleCount(int sampleCount) {
        this.ellipsedSampleCount += sampleCount;
    }

    public void setMatched() {
        this.matched = true;
    }

    public void setSampleCount(long sampleCount) {
        this.sampleCount = sampleCount;
    }

    @Nullable
    public Object getStackTraceElementObj() {
        return this.stackTraceElementObj;
    }

    public boolean isSyntheticRootNode() {
        return this.stackTraceElementObj == null;
    }

    public String getStackTraceElementStr() {
        if (this.stackTraceElementObj instanceof String) {
            return (String)this.stackTraceElementObj;
        }
        if (this.stackTraceElementObj == null) {
            return "";
        }
        return this.stackTraceElementObj.toString();
    }

    @Nullable
    public String getLeafThreadState() {
        return this.leafThreadState;
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public ImmutableList<String> getTimerNames() {
        return this.timerNames == null ? ImmutableList.of() : this.timerNames;
    }

    public Iterable<ProfileNode> getChildNodes() {
        return this;
    }

    @Override
    public Iterator<ProfileNode> iterator() {
        final Object childNodes = this.childNodes;
        if (childNodes == null) {
            return ImmutableList.of().iterator();
        }
        if (childNodes instanceof ProfileNode) {
            return new Iterator<ProfileNode>(){
                private boolean done;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public ProfileNode next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return (ProfileNode)Preconditions.checkNotNull(childNodes);
                }

                @Override
                public void remove() {
                    ProfileNode.this.childNodes = null;
                }
            };
        }
        return ((List)childNodes).iterator();
    }

    public boolean isChildNodesEmpty() {
        if (this.childNodes == null) {
            return true;
        }
        if (this.childNodes instanceof ProfileNode) {
            return false;
        }
        return ((List)this.childNodes).isEmpty();
    }

    @EnsuresNonNullIf(expression={"childNodes"}, result=true)
    public boolean hasOneChildNode() {
        if (this.childNodes == null) {
            return false;
        }
        if (this.childNodes instanceof ProfileNode) {
            return true;
        }
        return ((List)this.childNodes).size() == 1;
    }

    @RequiresNonNull(value={"childNodes"})
    public ProfileNode getOnlyChildNode() {
        if (this.childNodes instanceof ProfileNode) {
            return (ProfileNode)this.childNodes;
        }
        return (ProfileNode)((List)this.childNodes).get(0);
    }

    public int getEllipsedSampleCount() {
        return this.ellipsedSampleCount;
    }

    public boolean isMatched() {
        return this.matched;
    }

    public void mergeMatchedNode(ProfileNode anotherSyntheticRootNode) {
        Preconditions.checkState(this.stackTraceElementObj == null);
        ProfileNode.merge(this, anotherSyntheticRootNode);
    }

    public boolean isSameStackTraceElement(StackTraceElement stackTraceElement) {
        if (this.stackTraceElementObj instanceof StackTraceElement) {
            return this.stackTraceElementObj.equals(stackTraceElement);
        }
        if (this.stackTraceElementObj == null) {
            return false;
        }
        return this.stackTraceElementObj.equals(stackTraceElement.toString());
    }

    private static void merge(ProfileNode leftRootNode, ProfileNode rightRootNode) {
        ArrayDeque<MatchedNodePair> stack = new ArrayDeque<MatchedNodePair>();
        stack.add(MatchedNodePair.of(leftRootNode, rightRootNode));
        while (!stack.isEmpty()) {
            MatchedNodePair matchedPair = (MatchedNodePair)stack.pop();
            ProfileNode leftNode = matchedPair.leftNode();
            ProfileNode rightNode = matchedPair.rightNode();
            ProfileNode.mergeNodeShallow(leftNode, rightNode);
            for (ProfileNode rightChildNode : rightNode.getChildNodes()) {
                ProfileNode matchingLeftChildNode = ProfileNode.findMatch(leftNode.getChildNodes(), rightChildNode);
                if (matchingLeftChildNode == null) {
                    leftNode.addChildNode(rightChildNode);
                    continue;
                }
                stack.push(MatchedNodePair.of(matchingLeftChildNode, rightChildNode));
            }
        }
    }

    @Nullable
    private static ProfileNode findMatch(Iterable<ProfileNode> leftChildNodes, ProfileNode rightChildNode) {
        for (ProfileNode leftChildNode : leftChildNodes) {
            if (!ProfileNode.matches(leftChildNode, rightChildNode)) continue;
            return leftChildNode;
        }
        return null;
    }

    private static void mergeNodeShallow(ProfileNode leftNode, ProfileNode rightNode) {
        leftNode.incrementSampleCount(rightNode.getSampleCount());
        ImmutableList<String> timerNames = rightNode.getTimerNames();
        if (timerNames.size() > leftNode.getTimerNames().size()) {
            leftNode.setTimerNames(timerNames);
        }
    }

    public static boolean matches(ProfileNode leftNode, ProfileNode rightNode) {
        if (!Objects.equal(leftNode.leafThreadState, rightNode.leafThreadState)) {
            return false;
        }
        if (leftNode.stackTraceElementObj instanceof StackTraceElement) {
            return rightNode.isSameStackTraceElement((StackTraceElement)leftNode.stackTraceElementObj);
        }
        if (rightNode.stackTraceElementObj instanceof StackTraceElement) {
            return leftNode.isSameStackTraceElement((StackTraceElement)rightNode.stackTraceElementObj);
        }
        return Objects.equal(leftNode.stackTraceElementObj, rightNode.stackTraceElementObj);
    }

    @Value.Immutable
    @Styles.AllParameters
    static abstract class MatchedNodePairBase {
        MatchedNodePairBase() {
        }

        abstract ProfileNode leftNode();

        abstract ProfileNode rightNode();
    }

    private static class ProfileReader {
        private static final SerializableString stackTraceElementName = new SerializedString("stackTraceElement");
        private final JsonParser parser;
        private final Deque<ProfileNode> stack = new ArrayDeque<ProfileNode>();

        private ProfileReader(JsonParser parser) {
            this.parser = parser;
        }

        public ProfileNode read() throws IOException {
            ProfileNode rootNode = null;
            while (true) {
                JsonToken token;
                if ((token = this.parser.getCurrentToken()) == JsonToken.END_ARRAY) {
                    Preconditions.checkState(this.parser.nextToken() == JsonToken.END_OBJECT);
                    this.stack.pop();
                    if (this.stack.isEmpty()) break;
                    this.parser.nextToken();
                    continue;
                }
                Preconditions.checkState(token == JsonToken.START_OBJECT);
                ProfileNode node = this.readNodeFields();
                ProfileNode parentNode = this.stack.peek();
                if (parentNode == null) {
                    rootNode = node;
                } else {
                    parentNode.addChildNode(node);
                }
                token = this.parser.getCurrentToken();
                if (token == JsonToken.FIELD_NAME && this.parser.getText().equals("childNodes")) {
                    Preconditions.checkState(this.parser.nextToken() == JsonToken.START_ARRAY);
                    this.parser.nextToken();
                    this.stack.push(node);
                    continue;
                }
                Preconditions.checkState(token == JsonToken.END_OBJECT);
                if (this.stack.isEmpty()) break;
                this.parser.nextToken();
            }
            return Preconditions.checkNotNull(rootNode);
        }

        private ProfileNode readNodeFields() throws IOException {
            Preconditions.checkState(this.parser.nextFieldName(stackTraceElementName));
            String stackTraceElement = this.parser.nextTextValue();
            String leafThreadState = null;
            JsonToken token = this.parser.nextToken();
            if (token == JsonToken.FIELD_NAME && this.parser.getText().equals("leafThreadState")) {
                leafThreadState = this.parser.nextTextValue();
                token = this.parser.nextToken();
            }
            ProfileNode node = new ProfileNode(stackTraceElement, leafThreadState);
            if (token == JsonToken.FIELD_NAME && this.parser.getText().equals("sampleCount")) {
                node.sampleCount = this.parser.nextLongValue(0L);
                token = this.parser.nextToken();
            }
            if (token == JsonToken.FIELD_NAME && this.parser.getText().equals("timerNames")) {
                Preconditions.checkState(this.parser.nextToken() == JsonToken.START_ARRAY);
                ArrayList<String> timerNames = Lists.newArrayList();
                while (this.parser.nextToken() != JsonToken.END_ARRAY) {
                    timerNames.add(this.parser.getText());
                }
                node.setTimerNames(ImmutableList.copyOf(timerNames));
                token = this.parser.nextToken();
            }
            return node;
        }
    }

    private static class ProfileWriter
    extends Traverser<ProfileNode, IOException> {
        private final JsonGenerator jg;

        private ProfileWriter(ProfileNode rootNode, JsonGenerator jg) throws IOException {
            super(rootNode);
            this.jg = jg;
        }

        private void write() throws IOException {
            this.traverse();
        }

        @Override
        public List<ProfileNode> visit(ProfileNode node) throws IOException {
            ImmutableList<ProfileNode> childNodes;
            int ellipsedSampleCount;
            this.jg.writeStartObject();
            this.jg.writeStringField("stackTraceElement", node.getStackTraceElementStr());
            String leafThreadState = node.getLeafThreadState();
            if (leafThreadState != null) {
                this.jg.writeStringField("leafThreadState", leafThreadState);
            }
            this.jg.writeNumberField("sampleCount", node.getSampleCount());
            ImmutableList<String> timerNames = node.getTimerNames();
            if (!timerNames.isEmpty()) {
                this.jg.writeArrayFieldStart("timerNames");
                for (String timerName : timerNames) {
                    this.jg.writeString(timerName);
                }
                this.jg.writeEndArray();
            }
            if ((ellipsedSampleCount = node.getEllipsedSampleCount()) != 0) {
                this.jg.writeNumberField("ellipsedSampleCount", ellipsedSampleCount);
            }
            if (!(childNodes = ImmutableList.copyOf(node.getChildNodes())).isEmpty()) {
                this.jg.writeArrayFieldStart("childNodes");
            }
            return childNodes;
        }

        @Override
        public void revisitAfterChildren(ProfileNode node) throws IOException {
            if (!node.isChildNodesEmpty()) {
                this.jg.writeEndArray();
            }
            this.jg.writeEndObject();
        }
    }

    static class Deserializer
    extends JsonDeserializer<ProfileNode> {
        Deserializer() {
        }

        @Override
        public ProfileNode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new ProfileReader(p).read();
        }
    }

    static class Serializer
    extends JsonSerializer<ProfileNode> {
        Serializer() {
        }

        @Override
        public void serialize(ProfileNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            new ProfileWriter(value, gen).write();
        }
    }
}

