/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.transaction.model.TimerNameImplBase;

@ParametersAreNonnullByDefault
@Immutable
public final class TimerNameImpl
extends TimerNameImplBase {
    private final String name;
    private final boolean extended;
    @Nullable
    private final TimerNameImpl extendedTimer;
    private final int specialHashCode;

    private TimerNameImpl(String name) {
        this.name = Preconditions.checkNotNull(name);
        this.extended = super.extended();
        this.extendedTimer = super.extendedTimer();
        this.specialHashCode = super.specialHashCode();
    }

    private TimerNameImpl(Builder builder) {
        this.name = builder.name;
        this.extended = builder.extendedIsSet() ? builder.extended : super.extended();
        this.extendedTimer = super.extendedTimer();
        this.specialHashCode = super.specialHashCode();
    }

    private TimerNameImpl(String name, boolean extended) {
        this.name = name;
        this.extended = extended;
        this.extendedTimer = super.extendedTimer();
        this.specialHashCode = super.specialHashCode();
    }

    @Override
    @JsonProperty(value="name")
    @VisibleForTesting
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="extended")
    public boolean extended() {
        return this.extended;
    }

    @Override
    @JsonProperty(value="extendedTimer")
    public TimerNameImpl extendedTimer() {
        return this.extendedTimer;
    }

    @Override
    @JsonProperty(value="specialHashCode")
    public int specialHashCode() {
        return this.specialHashCode;
    }

    public final TimerNameImpl withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TimerNameImpl(newValue, this.extended);
    }

    public final TimerNameImpl withExtended(boolean value) {
        if (this.extended == value) {
            return this;
        }
        boolean newValue = value;
        return new TimerNameImpl(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TimerNameImpl && this.equalTo((TimerNameImpl)another);
    }

    private boolean equalTo(TimerNameImpl another) {
        return this.name.equals(another.name) && this.extended == another.extended && Objects.equal(this.extendedTimer, another.extendedTimer) && this.specialHashCode == another.specialHashCode;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Booleans.hashCode(this.extended);
        h = h * 17 + Objects.hashCode(this.extendedTimer);
        h = h * 17 + this.specialHashCode;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TimerNameImpl").add("name", this.name).add("extended", this.extended).add("extendedTimer", this.extendedTimer).add("specialHashCode", this.specialHashCode).toString();
    }

    @JsonCreator
    public static TimerNameImpl fromAllAttributes(@JsonProperty(value="name") @Nullable @VisibleForTesting String name, @JsonProperty(value="extended") @Nullable Boolean extended) {
        Builder builder = TimerNameImpl.builder();
        if (name != null) {
            builder.name(name);
        }
        if (extended != null) {
            builder.extended(extended);
        }
        return builder.build();
    }

    public static TimerNameImpl of(String name) {
        return new TimerNameImpl(name);
    }

    public static TimerNameImpl copyOf(TimerNameImplBase instance) {
        if (instance instanceof TimerNameImpl) {
            return (TimerNameImpl)instance;
        }
        return TimerNameImpl.builder().name(instance.name()).extended(instance.extended()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long NONDEFAULT_BIT_EXTENDED = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String name;
        private boolean extended;

        private Builder() {
        }

        public final Builder name(String name) {
            this.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder extended(boolean extended) {
            this.checkNotIsSet(this.extendedIsSet(), "extended");
            this.extended = extended;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public TimerNameImpl build() {
            this.checkRequiredAttributes();
            return new TimerNameImpl(this);
        }

        private boolean extendedIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TimerNameImpl is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build TimerNameImpl, some of required attributes are not set " + attributes;
        }
    }
}

