/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AnalyzedMethodBase;

@ParametersAreNonnullByDefault
@Immutable
final class AnalyzedMethod
extends AnalyzedMethodBase {
    private final String name;
    private final ImmutableList<String> parameterTypes;
    private final String returnType;
    private final int modifiers;
    @Nullable
    private final String signature;
    private final ImmutableList<String> exceptions;
    private final ImmutableList<Advice> advisors;

    private AnalyzedMethod(String name, ImmutableList<String> parameterTypes, String returnType, int modifiers, @Nullable String signature, ImmutableList<String> exceptions, ImmutableList<Advice> advisors) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.modifiers = modifiers;
        this.signature = signature;
        this.exceptions = exceptions;
        this.advisors = advisors;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="parameterTypes")
    public ImmutableList<String> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    @JsonProperty(value="returnType")
    public String returnType() {
        return this.returnType;
    }

    @Override
    @JsonProperty(value="modifiers")
    public int modifiers() {
        return this.modifiers;
    }

    @Override
    @JsonProperty(value="signature")
    public String signature() {
        return this.signature;
    }

    @Override
    @JsonProperty(value="exceptions")
    public ImmutableList<String> exceptions() {
        return this.exceptions;
    }

    @Override
    @JsonProperty(value="advisors")
    public ImmutableList<Advice> advisors() {
        return this.advisors;
    }

    public final AnalyzedMethod withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new AnalyzedMethod(newValue, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors);
    }

    public final AnalyzedMethod withParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedMethod(this.name, newValue, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors);
    }

    public final AnalyzedMethod withParameterTypes(Iterable<String> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedMethod(this.name, newValue, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors);
    }

    public final AnalyzedMethod withReturnType(String value) {
        if (this.returnType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new AnalyzedMethod(this.name, this.parameterTypes, newValue, this.modifiers, this.signature, this.exceptions, this.advisors);
    }

    public final AnalyzedMethod withModifiers(int value) {
        if (this.modifiers == value) {
            return this;
        }
        int newValue = value;
        return new AnalyzedMethod(this.name, this.parameterTypes, this.returnType, newValue, this.signature, this.exceptions, this.advisors);
    }

    public final AnalyzedMethod withSignature(@Nullable String value) {
        if (this.signature == value) {
            return this;
        }
        String newValue = value;
        return new AnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, newValue, this.exceptions, this.advisors);
    }

    public final AnalyzedMethod withExceptions(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, newValue, this.advisors);
    }

    public final AnalyzedMethod withExceptions(Iterable<String> elements) {
        if (this.exceptions == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, newValue, this.advisors);
    }

    public final AnalyzedMethod withAdvisors(Advice ... elements) {
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, newValue);
    }

    public final AnalyzedMethod withAdvisors(Iterable<? extends Advice> elements) {
        if (this.advisors == elements) {
            return this;
        }
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AnalyzedMethod && this.equalTo((AnalyzedMethod)another);
    }

    private boolean equalTo(AnalyzedMethod another) {
        return this.name.equals(another.name) && this.parameterTypes.equals(another.parameterTypes) && this.returnType.equals(another.returnType) && this.modifiers == another.modifiers && Objects.equal(this.signature, another.signature) && this.exceptions.equals(another.exceptions) && this.advisors.equals(another.advisors);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.parameterTypes.hashCode();
        h = h * 17 + this.returnType.hashCode();
        h = h * 17 + this.modifiers;
        h = h * 17 + Objects.hashCode(this.signature);
        h = h * 17 + this.exceptions.hashCode();
        h = h * 17 + this.advisors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AnalyzedMethod").add("name", this.name).add("parameterTypes", this.parameterTypes).add("returnType", this.returnType).add("modifiers", this.modifiers).add("signature", this.signature).add("exceptions", this.exceptions).add("advisors", this.advisors).toString();
    }

    @JsonCreator
    public static AnalyzedMethod fromAllAttributes(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="parameterTypes") @Nullable ImmutableList<String> parameterTypes, @JsonProperty(value="returnType") @Nullable String returnType, @JsonProperty(value="modifiers") @Nullable Integer modifiers, @JsonProperty(value="signature") @Nullable String signature, @JsonProperty(value="exceptions") @Nullable ImmutableList<String> exceptions, @JsonProperty(value="advisors") @Nullable ImmutableList<Advice> advisors) {
        Builder builder = AnalyzedMethod.builder();
        if (name != null) {
            builder.name(name);
        }
        if (parameterTypes != null) {
            builder.addAllParameterTypes(parameterTypes);
        }
        if (returnType != null) {
            builder.returnType(returnType);
        }
        if (modifiers != null) {
            builder.modifiers(modifiers);
        }
        if (signature != null) {
            builder.signature(signature);
        }
        if (exceptions != null) {
            builder.addAllExceptions(exceptions);
        }
        if (advisors != null) {
            builder.addAllAdvisors(advisors);
        }
        return builder.build();
    }

    static AnalyzedMethod copyOf(AnalyzedMethodBase instance) {
        if (instance instanceof AnalyzedMethod) {
            return (AnalyzedMethod)instance;
        }
        return AnalyzedMethod.builder().name(instance.name()).addAllParameterTypes(instance.parameterTypes()).returnType(instance.returnType()).modifiers(instance.modifiers()).signature(instance.signature()).addAllExceptions(instance.exceptions()).addAllAdvisors(instance.advisors()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_RETURN_TYPE = 2L;
        private static final long INITIALIZED_BIT_MODIFIERS = 4L;
        private static final long NONDEFAULT_BIT_SIGNATURE = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> parameterTypesBuilder = ImmutableList.builder();
        @Nullable
        private String returnType;
        private int modifiers;
        @Nullable
        private String signature;
        private ImmutableList.Builder<String> exceptionsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<Advice> advisorsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder name(String name) {
            this.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addParameterTypes(String element) {
            this.parameterTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addParameterTypes(String ... elements) {
            this.parameterTypesBuilder.add(elements);
            return this;
        }

        public final Builder addAllParameterTypes(Iterable<String> elements) {
            this.parameterTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder returnType(String returnType) {
            this.checkNotIsSet(this.returnTypeIsSet(), "returnType");
            this.returnType = Preconditions.checkNotNull(returnType);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder modifiers(int modifiers) {
            this.checkNotIsSet(this.modifiersIsSet(), "modifiers");
            this.modifiers = modifiers;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder signature(@Nullable String signature) {
            this.checkNotIsSet(this.signatureIsSet(), "signature");
            this.signature = signature;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder addExceptions(String element) {
            this.exceptionsBuilder.add((Object)element);
            return this;
        }

        public final Builder addExceptions(String ... elements) {
            this.exceptionsBuilder.add(elements);
            return this;
        }

        public final Builder addAllExceptions(Iterable<String> elements) {
            this.exceptionsBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder addAdvisors(Advice element) {
            this.advisorsBuilder.add((Object)element);
            return this;
        }

        public final Builder addAdvisors(Advice ... elements) {
            this.advisorsBuilder.add(elements);
            return this;
        }

        public final Builder addAllAdvisors(Iterable<? extends Advice> elements) {
            this.advisorsBuilder.addAll(elements);
            return this;
        }

        public AnalyzedMethod build() {
            this.checkRequiredAttributes();
            return new AnalyzedMethod(this.name, (ImmutableList)this.parameterTypesBuilder.build(), this.returnType, this.modifiers, this.signature, (ImmutableList)this.exceptionsBuilder.build(), (ImmutableList)this.advisorsBuilder.build());
        }

        private boolean signatureIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean returnTypeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean modifiersIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of AnalyzedMethod is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.returnTypeIsSet()) {
                attributes.add("returnType");
            }
            if (!this.modifiersIsSet()) {
                attributes.add("modifiers");
            }
            return "Cannot build AnalyzedMethod, some of required attributes are not set " + attributes;
        }
    }
}

