/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.glowroot.common.ClassNames;
import org.glowroot.common.Reflections;
import org.glowroot.common.Styles;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Supplier;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.cache.CacheLoader;
import org.glowroot.shaded.google.common.cache.LoadingCache;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.io.Resources;
import org.glowroot.shaded.objectweb.asm.ClassReader;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceMatcher;
import org.glowroot.weaving.AnalyzedClass;
import org.glowroot.weaving.AnalyzedMethod;
import org.glowroot.weaving.AnalyzingClassVisitor;
import org.glowroot.weaving.ExtraBootResourceFinder;
import org.glowroot.weaving.MixinType;
import org.glowroot.weaving.ParseContext;
import org.glowroot.weaving.ShimType;
import org.glowroot.weaving.WeavingClassVisitor;
import org.immutables.value.Value;

public class AnalyzedWorld {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzedWorld.class);
    private static final Method findLoadedClassMethod;
    private final LoadingCache<ClassLoader, ConcurrentMap<String, AnalyzedClass>> world = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<ClassLoader, ConcurrentMap<String, AnalyzedClass>>(){

        @Override
        public ConcurrentMap<String, AnalyzedClass> load(ClassLoader loader) {
            return new ConcurrentHashMap<String, AnalyzedClass>();
        }
    });
    private final ConcurrentMap<String, AnalyzedClass> bootstrapLoaderWorld = new ConcurrentHashMap<String, AnalyzedClass>();
    private final Supplier<List<Advice>> advisors;
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;
    @Nullable
    private final ExtraBootResourceFinder extraBootResourceFinder;

    public AnalyzedWorld(Supplier<List<Advice>> advisors, List<ShimType> shimTypes, List<MixinType> mixinTypes, @Nullable ExtraBootResourceFinder extraBootResourceFinder) {
        this.advisors = advisors;
        this.shimTypes = ImmutableList.copyOf(shimTypes);
        this.mixinTypes = ImmutableList.copyOf(mixinTypes);
        this.extraBootResourceFinder = extraBootResourceFinder;
    }

    public List<Class<?>> getClassesWithReweavableAdvice(boolean remove) {
        ArrayList<Class<?>> classes = Lists.newArrayList();
        for (ClassLoader loader : this.world.asMap().keySet()) {
            classes.addAll(this.getClassesWithReweavableAdvice(loader, remove));
        }
        classes.addAll(this.getClassesWithReweavableAdvice(null, remove));
        return classes;
    }

    public void removeClasses(List<Class<?>> classes) {
        for (Map map : this.world.asMap().values()) {
            for (Class<?> clazz : classes) {
                map.remove(clazz.getName());
            }
        }
        for (Class clazz : classes) {
            this.bootstrapLoaderWorld.remove(clazz.getName());
        }
    }

    public ImmutableList<ClassLoader> getClassLoaders() {
        return ImmutableList.copyOf(this.world.asMap().keySet());
    }

    void add(AnalyzedClass analyzedClass, @Nullable ClassLoader loader) {
        ConcurrentMap<String, AnalyzedClass> loaderAnalyzedClasses = this.getAnalyzedClasses(loader);
        loaderAnalyzedClasses.put(analyzedClass.name(), analyzedClass);
    }

    List<AnalyzedClass> getAnalyzedHierarchy(@Nullable String className, @Nullable ClassLoader loader, ParseContext parseContext) {
        if (className == null || className.equals("java.lang.Object")) {
            return ImmutableList.of();
        }
        return this.getSuperClasses(className, loader, parseContext);
    }

    AnalyzedClass getAnalyzedClass(String className, @Nullable ClassLoader loader) throws ClassNotFoundException, IOException {
        return this.getOrCreateAnalyzedClass(className, loader);
    }

    private List<AnalyzedClass> getSuperClasses(String className, @Nullable ClassLoader loader, ParseContext parseContext) {
        AnalyzedClass analyzedClass;
        try {
            analyzedClass = this.getOrCreateAnalyzedClass(className, loader);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            return ImmutableList.of();
        }
        catch (ClassNotFoundException e) {
            logger.debug("type {} not found while parsing type {}", className, parseContext, e);
            return ImmutableList.of();
        }
        ArrayList<AnalyzedClass> superTypes = Lists.newArrayList();
        superTypes.add(analyzedClass);
        String superName = analyzedClass.superName();
        if (superName != null && !superName.equals("java.lang.Object")) {
            superTypes.addAll(this.getSuperClasses(superName, loader, parseContext));
        }
        for (String interfaceName : analyzedClass.interfaceNames()) {
            superTypes.addAll(this.getSuperClasses(interfaceName, loader, parseContext));
        }
        return superTypes;
    }

    private AnalyzedClass getOrCreateAnalyzedClass(String className, @Nullable ClassLoader loader) throws ClassNotFoundException, IOException {
        ClassLoader analyzedClassLoader = this.getAnalyzedLoader(className, loader);
        ConcurrentMap<String, AnalyzedClass> loaderAnalyzedClasses = this.getAnalyzedClasses(analyzedClassLoader);
        AnalyzedClass analyzedClass = (AnalyzedClass)loaderAnalyzedClasses.get(className);
        if (analyzedClass == null) {
            ConcurrentMap<String, AnalyzedClass> currLoaderAnalyzedClasses;
            if (loader != analyzedClassLoader && (analyzedClass = (AnalyzedClass)(currLoaderAnalyzedClasses = this.getAnalyzedClasses(loader)).get(className)) != null) {
                analyzedClass = this.putAnalyzedClass(loaderAnalyzedClasses, analyzedClass);
                currLoaderAnalyzedClasses.remove(className);
                return analyzedClass;
            }
            analyzedClass = this.createAnalyzedClass(className, analyzedClassLoader);
            analyzedClass = this.putAnalyzedClass(loaderAnalyzedClasses, analyzedClass);
        }
        return analyzedClass;
    }

    private AnalyzedClass putAnalyzedClass(ConcurrentMap<String, AnalyzedClass> loaderAnalyzedClasses, AnalyzedClass analyzedClass) {
        AnalyzedClass existingAnalyzedClass = loaderAnalyzedClasses.putIfAbsent(analyzedClass.name(), analyzedClass);
        if (existingAnalyzedClass != null) {
            return existingAnalyzedClass;
        }
        return analyzedClass;
    }

    private List<Class<?>> getClassesWithReweavableAdvice(@Nullable ClassLoader loader, boolean remove) {
        ArrayList<Class<?>> classes = Lists.newArrayList();
        ConcurrentMap<String, AnalyzedClass> loaderAnalyzedClasses = this.getAnalyzedClasses(loader);
        for (Map.Entry entry : loaderAnalyzedClasses.entrySet()) {
            if (!((AnalyzedClass)entry.getValue()).hasReweavableAdvice()) continue;
            try {
                classes.add(Class.forName((String)entry.getKey(), false, loader));
            }
            catch (ClassNotFoundException e) {
                logger.warn(e.getMessage(), e);
            }
        }
        if (remove) {
            for (Class clazz : classes) {
                loaderAnalyzedClasses.remove(clazz.getName());
            }
        }
        return classes;
    }

    @Nullable
    private ClassLoader getAnalyzedLoader(String className, @Nullable ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        Class clazz = null;
        try {
            clazz = (Class)Reflections.invoke(findLoadedClassMethod, (Object)loader, className);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        ClassLoader analyzedLoader = loader;
        if (clazz != null) {
            analyzedLoader = clazz.getClassLoader();
        }
        return analyzedLoader;
    }

    private AnalyzedClass createAnalyzedClass(String className, @Nullable ClassLoader loader) throws ClassNotFoundException, IOException {
        URL url;
        String path = ClassNames.toInternalName(className) + ".class";
        if (loader == null) {
            url = ClassLoader.getSystemResource(path);
        } else {
            AnalyzedClass parentLoaderAnalyzedClass;
            url = loader.getResource(path);
            if (url != null && (parentLoaderAnalyzedClass = this.tryToReuseFromParentLoader(className, loader, path, url)) != null) {
                return parentLoaderAnalyzedClass;
            }
        }
        if (url == null && this.extraBootResourceFinder != null) {
            url = this.extraBootResourceFinder.findResource(path);
        }
        if (url == null) {
            return this.createAnalyzedClassPlanB(className, loader);
        }
        AnalyzingClassVisitor cv = new AnalyzingClassVisitor(this.advisors.get(), this.shimTypes, this.mixinTypes, loader, this, null);
        byte[] bytes = Resources.toByteArray(url);
        ClassReader cr = new ClassReader(bytes);
        try {
            cr.accept(cv, 1);
        }
        catch (WeavingClassVisitor.ShortCircuitException shortCircuitException) {
            // empty catch block
        }
        AnalyzedClass analyzedClass = cv.getAnalyzedClass();
        Preconditions.checkNotNull(analyzedClass);
        return analyzedClass;
    }

    @Nullable
    private AnalyzedClass tryToReuseFromParentLoader(String className, ClassLoader originalLoader, String path, URL url) {
        ClassLoader loader = originalLoader;
        while (loader != null) {
            AnalyzedClass parentLoaderAnalyzedClass;
            ClassLoader parentLoader = loader.getParent();
            URL parentLoaderUrl = parentLoader == null ? ClassLoader.getSystemResource(path) : parentLoader.getResource(path);
            if (parentLoaderUrl != null && parentLoaderUrl.toExternalForm().equals(url.toExternalForm()) && (parentLoaderAnalyzedClass = (AnalyzedClass)this.getAnalyzedClasses(parentLoader).get(className)) != null) {
                return parentLoaderAnalyzedClass;
            }
            loader = parentLoader;
        }
        return null;
    }

    private AnalyzedClass createAnalyzedClassPlanB(String className, @Nullable ClassLoader loader) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className, false, loader);
        AnalyzedClass analyzedClass = (AnalyzedClass)this.getAnalyzedClasses(clazz.getClassLoader()).get(className);
        if (analyzedClass == null) {
            analyzedClass = AnalyzedWorld.createAnalyzedClassPlanC(clazz, this.advisors.get());
            for (AnalyzedMethod analyzedMethod : analyzedClass.analyzedMethods()) {
                if (analyzedMethod.advisors().isEmpty()) continue;
                logger.warn("{} was not woven with requested advice (it was first encountered during the weaving of one of its {} and the resource {}.class could not be found in class loader {}, so {} had to be explicitly loaded using Class.forName() in the middle of weaving the {}, which means it was not woven itself since weaving is not re-entrant)", clazz.getName(), analyzedClass.isInterface() ? "implementations" : "subclasses", ClassNames.toInternalName(clazz.getName()), loader, clazz.getName(), analyzedClass.isInterface() ? "implementation" : "subclass");
                break;
            }
        }
        return analyzedClass;
    }

    private ConcurrentMap<String, AnalyzedClass> getAnalyzedClasses(@Nullable ClassLoader loader) {
        if (loader == null) {
            return this.bootstrapLoaderWorld;
        }
        return this.world.getUnchecked(loader);
    }

    private static AnalyzedClass createAnalyzedClassPlanC(Class<?> clazz, List<Advice> advisors) {
        AnalyzedClass.Builder classBuilder = AnalyzedClass.builder();
        classBuilder.modifiers(clazz.getModifiers());
        classBuilder.name(clazz.getName());
        Class<?> superClass = clazz.getSuperclass();
        String superName = superClass == null ? null : superClass.getName();
        classBuilder.superName(superName);
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            classBuilder.addInterfaceNames(interfaceClass.getName());
        }
        ImmutableList<AdviceMatcher> adviceMatchers = AdviceMatcher.getAdviceMatchers(clazz.getName(), advisors);
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.isSynthetic()) continue;
            ArrayList<Type> parameterTypes = Lists.newArrayList();
            for (Class<?> parameterType : method.getParameterTypes()) {
                parameterTypes.add(Type.getType(parameterType));
            }
            Type returnType = Type.getType(method.getReturnType());
            List<Advice> matchingAdvisors = AnalyzedWorld.getMatchingAdvisors(method.getModifiers(), method.getName(), parameterTypes, returnType, adviceMatchers);
            if (matchingAdvisors.isEmpty()) continue;
            AnalyzedMethod.Builder methodBuilder = AnalyzedMethod.builder();
            methodBuilder.name(method.getName());
            for (Type parameterType : parameterTypes) {
                methodBuilder.addParameterTypes(parameterType.getClassName());
            }
            methodBuilder.returnType(returnType.getClassName());
            methodBuilder.modifiers(method.getModifiers());
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                methodBuilder.addExceptions(exceptionType.getName());
            }
            methodBuilder.addAllAdvisors(matchingAdvisors);
            classBuilder.addAnalyzedMethods(methodBuilder.build());
        }
        return classBuilder.build();
    }

    private static List<Advice> getMatchingAdvisors(int access, String name, List<Type> parameterTypes, Type returnType, List<AdviceMatcher> adviceMatchers) {
        ArrayList<Advice> matchingAdvisors = Lists.newArrayList();
        for (AdviceMatcher adviceMatcher : adviceMatchers) {
            if (!adviceMatcher.isMethodLevelMatch(name, parameterTypes, returnType, access)) continue;
            matchingAdvisors.add(adviceMatcher.advice());
        }
        return matchingAdvisors;
    }

    static {
        try {
            findLoadedClassMethod = Reflections.getDeclaredMethod(ClassLoader.class, "findLoadedClass", String.class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    static abstract class ParseContextBase {
        ParseContextBase() {
        }

        abstract String className();

        @Nullable
        abstract CodeSource codeSource();

        public String toString() {
            CodeSource codeSource = this.codeSource();
            if (codeSource == null) {
                return this.className();
            }
            return this.className() + " (" + codeSource.getLocation() + ")";
        }
    }
}

