/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class ExtraBootResourceFinder {
    private static final Logger logger = LoggerFactory.getLogger(ExtraBootResourceFinder.class);
    private final ImmutableList<File> jarFiles;

    public ExtraBootResourceFinder(List<File> jarFiles) {
        this.jarFiles = ImmutableList.copyOf(jarFiles);
    }

    @Nullable
    URL findResource(String name) {
        for (File pluginJar : this.jarFiles) {
            try {
                URL url = new URL("jar:" + pluginJar.toURI() + "!/" + name);
                url.openStream().close();
                return url;
            }
            catch (IOException e) {
                logger.trace(e.getMessage(), e);
            }
        }
        return null;
    }
}

