/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.WeavingClassVisitor;

@ParametersAreNonnullByDefault
@Immutable
final class MethodMetaGroup
extends WeavingClassVisitor.MethodMetaGroupBase {
    private final Type returnType;
    private final ImmutableList<Type> parameterTypes;
    private final int uniqueNum;
    private final ImmutableSet<Type> methodMetaTypes;

    private MethodMetaGroup(Type returnType, ImmutableList<Type> parameterTypes, int uniqueNum, ImmutableSet<Type> methodMetaTypes) {
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.uniqueNum = uniqueNum;
        this.methodMetaTypes = methodMetaTypes;
    }

    @Override
    @JsonProperty(value="returnType")
    public Type returnType() {
        return this.returnType;
    }

    @Override
    @JsonProperty(value="parameterTypes")
    public ImmutableList<Type> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    @JsonProperty(value="uniqueNum")
    public int uniqueNum() {
        return this.uniqueNum;
    }

    @Override
    @JsonProperty(value="methodMetaTypes")
    public ImmutableSet<Type> methodMetaTypes() {
        return this.methodMetaTypes;
    }

    public final MethodMetaGroup withReturnType(Type value) {
        if (this.returnType == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value);
        return new MethodMetaGroup(newValue, this.parameterTypes, this.uniqueNum, this.methodMetaTypes);
    }

    public final MethodMetaGroup withParameterTypes(Type ... elements) {
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new MethodMetaGroup(this.returnType, newValue, this.uniqueNum, this.methodMetaTypes);
    }

    public final MethodMetaGroup withParameterTypes(Iterable<? extends Type> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new MethodMetaGroup(this.returnType, newValue, this.uniqueNum, this.methodMetaTypes);
    }

    public final MethodMetaGroup withUniqueNum(int value) {
        if (this.uniqueNum == value) {
            return this;
        }
        int newValue = value;
        return new MethodMetaGroup(this.returnType, this.parameterTypes, newValue, this.methodMetaTypes);
    }

    public final MethodMetaGroup withMethodMetaTypes(Type ... elements) {
        ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
        return new MethodMetaGroup(this.returnType, this.parameterTypes, this.uniqueNum, newValue);
    }

    public final MethodMetaGroup withMethodMetaTypes(Iterable<? extends Type> elements) {
        if (this.methodMetaTypes == elements) {
            return this;
        }
        ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
        return new MethodMetaGroup(this.returnType, this.parameterTypes, this.uniqueNum, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MethodMetaGroup && this.equalTo((MethodMetaGroup)another);
    }

    private boolean equalTo(MethodMetaGroup another) {
        return this.returnType.equals(another.returnType) && this.parameterTypes.equals(another.parameterTypes) && this.uniqueNum == another.uniqueNum && this.methodMetaTypes.equals(another.methodMetaTypes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.returnType.hashCode();
        h = h * 17 + this.parameterTypes.hashCode();
        h = h * 17 + this.uniqueNum;
        h = h * 17 + this.methodMetaTypes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MethodMetaGroup").add("returnType", this.returnType).add("parameterTypes", this.parameterTypes).add("uniqueNum", this.uniqueNum).add("methodMetaTypes", this.methodMetaTypes).toString();
    }

    @JsonCreator
    public static MethodMetaGroup fromAllAttributes(@JsonProperty(value="returnType") @Nullable Type returnType, @JsonProperty(value="parameterTypes") @Nullable ImmutableList<Type> parameterTypes, @JsonProperty(value="uniqueNum") @Nullable Integer uniqueNum, @JsonProperty(value="methodMetaTypes") @Nullable ImmutableSet<Type> methodMetaTypes) {
        Builder builder = MethodMetaGroup.builder();
        if (returnType != null) {
            builder.returnType(returnType);
        }
        if (parameterTypes != null) {
            builder.addAllParameterTypes(parameterTypes);
        }
        if (uniqueNum != null) {
            builder.uniqueNum(uniqueNum);
        }
        if (methodMetaTypes != null) {
            builder.addAllMethodMetaTypes(methodMetaTypes);
        }
        return builder.build();
    }

    static MethodMetaGroup copyOf(WeavingClassVisitor.MethodMetaGroupBase instance) {
        if (instance instanceof MethodMetaGroup) {
            return (MethodMetaGroup)instance;
        }
        return MethodMetaGroup.builder().returnType(instance.returnType()).addAllParameterTypes(instance.parameterTypes()).uniqueNum(instance.uniqueNum()).addAllMethodMetaTypes(instance.methodMetaTypes()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_RETURN_TYPE = 1L;
        private static final long INITIALIZED_BIT_UNIQUE_NUM = 2L;
        private long initializedBitset;
        @Nullable
        private Type returnType;
        private ImmutableList.Builder<Type> parameterTypesBuilder = ImmutableList.builder();
        private int uniqueNum;
        private ImmutableSet.Builder<Type> methodMetaTypesBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder returnType(Type returnType) {
            this.checkNotIsSet(this.returnTypeIsSet(), "returnType");
            this.returnType = Preconditions.checkNotNull(returnType);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addParameterTypes(Type element) {
            this.parameterTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addParameterTypes(Type ... elements) {
            this.parameterTypesBuilder.add(elements);
            return this;
        }

        public final Builder addAllParameterTypes(Iterable<? extends Type> elements) {
            this.parameterTypesBuilder.addAll(elements);
            return this;
        }

        public final Builder uniqueNum(int uniqueNum) {
            this.checkNotIsSet(this.uniqueNumIsSet(), "uniqueNum");
            this.uniqueNum = uniqueNum;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addMethodMetaTypes(Type element) {
            this.methodMetaTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethodMetaTypes(Type ... elements) {
            this.methodMetaTypesBuilder.add(elements);
            return this;
        }

        public final Builder addAllMethodMetaTypes(Iterable<? extends Type> elements) {
            this.methodMetaTypesBuilder.addAll(elements);
            return this;
        }

        public MethodMetaGroup build() {
            this.checkRequiredAttributes();
            return new MethodMetaGroup(this.returnType, (ImmutableList)this.parameterTypesBuilder.build(), this.uniqueNum, (ImmutableSet)this.methodMetaTypesBuilder.build());
        }

        private boolean returnTypeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean uniqueNumIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of MethodMetaGroup is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.returnTypeIsSet()) {
                attributes.add("returnType");
            }
            if (!this.uniqueNumIsSet()) {
                attributes.add("uniqueNum");
            }
            return "Cannot build MethodMetaGroup, some of required attributes are not set " + attributes;
        }
    }
}

