/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.security.CodeSource;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.weaving.AnalyzedWorld;

@ParametersAreNonnullByDefault
@Immutable
final class ParseContext
extends AnalyzedWorld.ParseContextBase {
    private final String className;
    @Nullable
    private final CodeSource codeSource;

    private ParseContext(String className, @Nullable CodeSource codeSource) {
        this.className = className;
        this.codeSource = codeSource;
    }

    @Override
    @JsonProperty(value="className")
    public String className() {
        return this.className;
    }

    @Override
    @JsonProperty(value="codeSource")
    public CodeSource codeSource() {
        return this.codeSource;
    }

    public final ParseContext withClassName(String value) {
        if (this.className == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ParseContext(newValue, this.codeSource);
    }

    public final ParseContext withCodeSource(@Nullable CodeSource value) {
        if (this.codeSource == value) {
            return this;
        }
        CodeSource newValue = value;
        return new ParseContext(this.className, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ParseContext && this.equalTo((ParseContext)another);
    }

    private boolean equalTo(ParseContext another) {
        return this.className.equals(another.className) && Objects.equal(this.codeSource, another.codeSource);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.className.hashCode();
        h = h * 17 + Objects.hashCode(this.codeSource);
        return h;
    }

    @JsonCreator
    public static ParseContext fromAllAttributes(@JsonProperty(value="className") @Nullable String className, @JsonProperty(value="codeSource") @Nullable CodeSource codeSource) {
        Builder builder = ParseContext.builder();
        if (className != null) {
            builder.className(className);
        }
        if (codeSource != null) {
            builder.codeSource(codeSource);
        }
        return builder.build();
    }

    public static ParseContext of(String className, @Nullable CodeSource codeSource) {
        return new ParseContext(className, codeSource);
    }

    static ParseContext copyOf(AnalyzedWorld.ParseContextBase instance) {
        if (instance instanceof ParseContext) {
            return (ParseContext)instance;
        }
        return ParseContext.builder().className(instance.className()).codeSource(instance.codeSource()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_CLASS_NAME = 1L;
        private static final long NONDEFAULT_BIT_CODE_SOURCE = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String className;
        @Nullable
        private CodeSource codeSource;

        private Builder() {
        }

        public final Builder className(String className) {
            this.checkNotIsSet(this.classNameIsSet(), "className");
            this.className = Preconditions.checkNotNull(className);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder codeSource(@Nullable CodeSource codeSource) {
            this.checkNotIsSet(this.codeSourceIsSet(), "codeSource");
            this.codeSource = codeSource;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public ParseContext build() {
            this.checkRequiredAttributes();
            return new ParseContext(this.className, this.codeSource);
        }

        private boolean codeSourceIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean classNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ParseContext is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.classNameIsSet()) {
                attributes.add("className");
            }
            return "Cannot build ParseContext, some of required attributes are not set " + attributes;
        }
    }
}

