/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.ShimTypeBase;

@ParametersAreNonnullByDefault
@Immutable
public final class ShimType
extends ShimTypeBase {
    private final Type iface;
    private final String target;
    private final ImmutableList<Method> shimMethods;

    private ShimType(Type iface, String target, ImmutableList<Method> shimMethods) {
        this.iface = iface;
        this.target = target;
        this.shimMethods = shimMethods;
    }

    @Override
    @JsonProperty(value="iface")
    public Type iface() {
        return this.iface;
    }

    @Override
    @JsonProperty(value="target")
    public String target() {
        return this.target;
    }

    @Override
    @JsonProperty(value="shimMethods")
    public ImmutableList<Method> shimMethods() {
        return this.shimMethods;
    }

    public final ShimType withIface(Type value) {
        if (this.iface == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value);
        return new ShimType(newValue, this.target, this.shimMethods);
    }

    public final ShimType withTarget(String value) {
        if (this.target == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ShimType(this.iface, newValue, this.shimMethods);
    }

    public final ShimType withShimMethods(Method ... elements) {
        ImmutableList<Method> newValue = ImmutableList.copyOf(elements);
        return new ShimType(this.iface, this.target, newValue);
    }

    public final ShimType withShimMethods(Iterable<? extends Method> elements) {
        if (this.shimMethods == elements) {
            return this;
        }
        ImmutableList<Method> newValue = ImmutableList.copyOf(elements);
        return new ShimType(this.iface, this.target, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ShimType && this.equalTo((ShimType)another);
    }

    private boolean equalTo(ShimType another) {
        return this.iface.equals(another.iface) && this.target.equals(another.target) && this.shimMethods.equals(another.shimMethods);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.iface.hashCode();
        h = h * 17 + this.target.hashCode();
        h = h * 17 + this.shimMethods.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ShimType").add("iface", this.iface).add("target", this.target).add("shimMethods", this.shimMethods).toString();
    }

    @JsonCreator
    public static ShimType fromAllAttributes(@JsonProperty(value="iface") @Nullable Type iface, @JsonProperty(value="target") @Nullable String target, @JsonProperty(value="shimMethods") @Nullable ImmutableList<Method> shimMethods) {
        Builder builder = ShimType.builder();
        if (iface != null) {
            builder.iface(iface);
        }
        if (target != null) {
            builder.target(target);
        }
        if (shimMethods != null) {
            builder.addAllShimMethods(shimMethods);
        }
        return builder.build();
    }

    public static ShimType copyOf(ShimTypeBase instance) {
        if (instance instanceof ShimType) {
            return (ShimType)instance;
        }
        return ShimType.builder().iface(instance.iface()).target(instance.target()).addAllShimMethods(instance.shimMethods()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_IFACE = 1L;
        private static final long INITIALIZED_BIT_TARGET = 2L;
        private long initializedBitset;
        @Nullable
        private Type iface;
        @Nullable
        private String target;
        private ImmutableList.Builder<Method> shimMethodsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder iface(Type iface) {
            this.checkNotIsSet(this.ifaceIsSet(), "iface");
            this.iface = Preconditions.checkNotNull(iface);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder target(String target) {
            this.checkNotIsSet(this.targetIsSet(), "target");
            this.target = Preconditions.checkNotNull(target);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addShimMethods(Method element) {
            this.shimMethodsBuilder.add((Object)element);
            return this;
        }

        public final Builder addShimMethods(Method ... elements) {
            this.shimMethodsBuilder.add(elements);
            return this;
        }

        public final Builder addAllShimMethods(Iterable<? extends Method> elements) {
            this.shimMethodsBuilder.addAll(elements);
            return this;
        }

        public ShimType build() {
            this.checkRequiredAttributes();
            return new ShimType(this.iface, this.target, (ImmutableList)this.shimMethodsBuilder.build());
        }

        private boolean ifaceIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean targetIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ShimType is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.ifaceIsSet()) {
                attributes.add("iface");
            }
            if (!this.targetIsSet()) {
                attributes.add("target");
            }
            return "Cannot build ShimType, some of required attributes are not set " + attributes;
        }
    }
}

