/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.io.IOException;
import java.lang.reflect.Method;
import org.glowroot.api.weaving.Shim;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.ShimType;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ShimTypeBase {
    public static ShimType from(Shim shim, Class<?> iface) throws IOException {
        ShimType.Builder builder = ShimType.builder();
        builder.target(shim.value());
        builder.iface(Type.getType(iface));
        for (Method method : iface.getMethods()) {
            if (!method.isAnnotationPresent(Shim.class)) continue;
            builder.addShimMethods(method);
        }
        return builder.build();
    }

    abstract Type iface();

    abstract String target();

    abstract ImmutableList<Method> shimMethods();
}

