package org.glowroot.collector;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonRawValue;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ProfileAggregateBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ProfileAggregate.builder()}.
 * Use static factory method to create immutable instances:
 * {@code ProfileAggregate.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ProfileAggregateBase"})
@Immutable
public final class ProfileAggregate extends ProfileAggregateBase {
  private final long captureTime;
  private final CharSource profile;

  private ProfileAggregate(long captureTime, CharSource profile) {
    this.captureTime = captureTime;
    this.profile = profile;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureTime} attribute
   */
  @JsonProperty("captureTime")
  @Override
  public long captureTime() {
    return captureTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code profile} attribute
   */
  @JsonRawValue
  @JsonProperty("profile")
  @Override
  public CharSource profile() {
    return profile;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ProfileAggregateBase#captureTime() captureTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureTime
   * @return modified copy of the {@code this} object
   */
  public final ProfileAggregate withCaptureTime(long value) {
    if (this.captureTime == value) {
      return this;
    }
    long newValue = value;
    return new ProfileAggregate(newValue, this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ProfileAggregateBase#profile() profile}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for profile
   * @return modified copy of the {@code this} object
   */
  public final ProfileAggregate withProfile(CharSource value) {
    if (this.profile == value) {
      return this;
    }
    CharSource newValue = Preconditions.checkNotNull(value);
    return new ProfileAggregate(this.captureTime, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ProfileAggregate} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ProfileAggregate && equalTo((ProfileAggregate) another));
  }
  
  private boolean equalTo(ProfileAggregate another) {
    return captureTime == another.captureTime
        && profile.equals(another.profile);
  }
  
  /**
   * Computes hash code from attributes: {@code captureTime}, {@code profile}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(captureTime);
    h = h * 17 + profile.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code ProfileAggregate{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ProfileAggregate")
        .add("captureTime", captureTime)
        .add("profile", profile)
        .toString();
  }
  
  @JsonCreator
  public static ProfileAggregate fromAllAttributes(
      @JsonProperty("captureTime") @Nullable Long captureTime,
      @JsonProperty("profile") @Nullable CharSource profile) {
    ProfileAggregate.Builder builder = ProfileAggregate.builder();
    if (captureTime != null) {
      builder.captureTime(captureTime);
    }
    if (profile != null) {
      builder.profile(profile);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code ProfileAggregate} instance.
   * @param captureTime value for {@code captureTime}
   * @param profile value for {@code profile}
   * @return immutable ProfileAggregate instance
   */
  public static org.glowroot.collector.ProfileAggregate of(long captureTime, CharSource profile) {
    return new ProfileAggregate(captureTime, profile);
  }
  
  /**
   * Creates immutable copy of {@link ProfileAggregateBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ProfileAggregate instance
   */
  public static ProfileAggregate copyOf(ProfileAggregateBase instance) {
    if (instance instanceof ProfileAggregate) {
      return (ProfileAggregate) instance;
    }
    return ProfileAggregate.builder()
        .captureTime(instance.captureTime())
        .profile(instance.profile())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.collector.ProfileAggregate}.
   * @return new ProfileAggregate builder
   */
  public static ProfileAggregate.Builder builder() {
    return new ProfileAggregate.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.collector.ProfileAggregate}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_CAPTURE_TIME = 0x1L;
    private static final long INITIALIZED_BIT_PROFILE = 0x2L;
    private long initializedBitset;
  
    private long captureTime;
    private @Nullable CharSource profile;
    private Builder() {}
  
    /**
     * Initializes value for {@link ProfileAggregateBase#captureTime() captureTime}.
     * @param captureTime value for captureTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureTime(long captureTime) {
      checkNotIsSet(captureTimeIsSet(), "captureTime");
      this.captureTime = captureTime;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link ProfileAggregateBase#profile() profile}.
     * @param profile value for profile
     * @return {@code this} builder for chained invocation
     */
    public final Builder profile(CharSource profile) {
      checkNotIsSet(profileIsSet(), "profile");
      this.profile = Preconditions.checkNotNull(profile);
      initializedBitset |= INITIALIZED_BIT_PROFILE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.collector.ProfileAggregate}.
     * @return immutable instance of ProfileAggregate
     */
    public ProfileAggregate build() {
      checkRequiredAttributes();
      return new ProfileAggregate(captureTime, profile);
    }
  
    private boolean captureTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_TIME) != 0;
    }
  
    private boolean profileIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PROFILE) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ProfileAggregate is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!captureTimeIsSet()) {
        attributes.add("captureTime");
      }
      if (!profileIsSet()) {
        attributes.add("profile");
      }
      return "Cannot build ProfileAggregate, some of required attributes are not set " + attributes;
    }
  }
}
