package org.glowroot.common;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SpyingLogbackFilter.ExpectedMessageBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ExpectedMessage.builder()}.
 * Use static factory method to create immutable instances:
 * {@code ExpectedMessage.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SpyingLogbackFilter.ExpectedMessageBase"})
@Immutable
final class ExpectedMessage extends SpyingLogbackFilter.ExpectedMessageBase {
  private final String loggerName;
  private final String partialMessage;

  private ExpectedMessage(String loggerName, String partialMessage) {
    this.loggerName = loggerName;
    this.partialMessage = partialMessage;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code loggerName} attribute
   */
  @JsonProperty("loggerName")
  @Override
  public String loggerName() {
    return loggerName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code partialMessage} attribute
   */
  @JsonProperty("partialMessage")
  @Override
  public String partialMessage() {
    return partialMessage;
  }
  
  /**
   * Copy current immutable object by setting value for {@link SpyingLogbackFilter.ExpectedMessageBase#loggerName() loggerName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for loggerName
   * @return modified copy of the {@code this} object
   */
  public final ExpectedMessage withLoggerName(String value) {
    if (this.loggerName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ExpectedMessage(newValue, this.partialMessage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SpyingLogbackFilter.ExpectedMessageBase#partialMessage() partialMessage}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for partialMessage
   * @return modified copy of the {@code this} object
   */
  public final ExpectedMessage withPartialMessage(String value) {
    if (this.partialMessage == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ExpectedMessage(this.loggerName, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ExpectedMessage} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ExpectedMessage && equalTo((ExpectedMessage) another));
  }
  
  private boolean equalTo(ExpectedMessage another) {
    return loggerName.equals(another.loggerName)
        && partialMessage.equals(another.partialMessage);
  }
  
  /**
   * Computes hash code from attributes: {@code loggerName}, {@code partialMessage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + loggerName.hashCode();
    h = h * 17 + partialMessage.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code ExpectedMessage{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExpectedMessage")
        .add("loggerName", loggerName)
        .add("partialMessage", partialMessage)
        .toString();
  }
  
  @JsonCreator
  public static ExpectedMessage fromAllAttributes(
      @JsonProperty("loggerName") @Nullable String loggerName,
      @JsonProperty("partialMessage") @Nullable String partialMessage) {
    ExpectedMessage.Builder builder = ExpectedMessage.builder();
    if (loggerName != null) {
      builder.loggerName(loggerName);
    }
    if (partialMessage != null) {
      builder.partialMessage(partialMessage);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code ExpectedMessage} instance.
   * @param loggerName value for {@code loggerName}
   * @param partialMessage value for {@code partialMessage}
   * @return immutable ExpectedMessage instance
   */
  public static org.glowroot.common.ExpectedMessage of(String loggerName, String partialMessage) {
    return new ExpectedMessage(loggerName, partialMessage);
  }
  
  /**
   * Creates immutable copy of {@link SpyingLogbackFilter.ExpectedMessageBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ExpectedMessage instance
   */
  static ExpectedMessage copyOf(SpyingLogbackFilter.ExpectedMessageBase instance) {
    if (instance instanceof ExpectedMessage) {
      return (ExpectedMessage) instance;
    }
    return ExpectedMessage.builder()
        .loggerName(instance.loggerName())
        .partialMessage(instance.partialMessage())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.common.ExpectedMessage}.
   * @return new ExpectedMessage builder
   */
  static ExpectedMessage.Builder builder() {
    return new ExpectedMessage.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.common.ExpectedMessage}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_LOGGER_NAME = 0x1L;
    private static final long INITIALIZED_BIT_PARTIAL_MESSAGE = 0x2L;
    private long initializedBitset;
  
    private @Nullable String loggerName;
    private @Nullable String partialMessage;
    private Builder() {}
  
    /**
     * Initializes value for {@link SpyingLogbackFilter.ExpectedMessageBase#loggerName() loggerName}.
     * @param loggerName value for loggerName
     * @return {@code this} builder for chained invocation
     */
    public final Builder loggerName(String loggerName) {
      checkNotIsSet(loggerNameIsSet(), "loggerName");
      this.loggerName = Preconditions.checkNotNull(loggerName);
      initializedBitset |= INITIALIZED_BIT_LOGGER_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link SpyingLogbackFilter.ExpectedMessageBase#partialMessage() partialMessage}.
     * @param partialMessage value for partialMessage
     * @return {@code this} builder for chained invocation
     */
    public final Builder partialMessage(String partialMessage) {
      checkNotIsSet(partialMessageIsSet(), "partialMessage");
      this.partialMessage = Preconditions.checkNotNull(partialMessage);
      initializedBitset |= INITIALIZED_BIT_PARTIAL_MESSAGE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.common.ExpectedMessage}.
     * @return immutable instance of ExpectedMessage
     */
    public org.glowroot.common.ExpectedMessage build() {
      checkRequiredAttributes();
      return new ExpectedMessage(loggerName, partialMessage);
    }
  
    private boolean loggerNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LOGGER_NAME) != 0;
    }
  
    private boolean partialMessageIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PARTIAL_MESSAGE) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ExpectedMessage is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!loggerNameIsSet()) {
        attributes.add("loggerName");
      }
      if (!partialMessageIsSet()) {
        attributes.add("partialMessage");
      }
      return "Cannot build ExpectedMessage, some of required attributes are not set " + attributes;
    }
  }
}
