package org.glowroot.common;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SpyingLogbackFilter.MessageCountBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MessageCount.builder()}.
 * Use static factory method to create immutable instances:
 * {@code MessageCount.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SpyingLogbackFilter.MessageCountBase"})
@Immutable
public final class MessageCount extends SpyingLogbackFilter.MessageCountBase {
  private final int expectedCount;
  private final int unexpectedCount;

  private MessageCount(int expectedCount, int unexpectedCount) {
    this.expectedCount = expectedCount;
    this.unexpectedCount = unexpectedCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code expectedCount} attribute
   */
  @JsonProperty("expectedCount")
  @Override
  public int expectedCount() {
    return expectedCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code unexpectedCount} attribute
   */
  @JsonProperty("unexpectedCount")
  @Override
  public int unexpectedCount() {
    return unexpectedCount;
  }
  
  /**
   * Copy current immutable object by setting value for {@link SpyingLogbackFilter.MessageCountBase#expectedCount() expectedCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for expectedCount
   * @return modified copy of the {@code this} object
   */
  public final MessageCount withExpectedCount(int value) {
    if (this.expectedCount == value) {
      return this;
    }
    int newValue = value;
    return new MessageCount(newValue, this.unexpectedCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SpyingLogbackFilter.MessageCountBase#unexpectedCount() unexpectedCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for unexpectedCount
   * @return modified copy of the {@code this} object
   */
  public final MessageCount withUnexpectedCount(int value) {
    if (this.unexpectedCount == value) {
      return this;
    }
    int newValue = value;
    return new MessageCount(this.expectedCount, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MessageCount} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MessageCount && equalTo((MessageCount) another));
  }
  
  private boolean equalTo(MessageCount another) {
    return expectedCount == another.expectedCount
        && unexpectedCount == another.unexpectedCount;
  }
  
  /**
   * Computes hash code from attributes: {@code expectedCount}, {@code unexpectedCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + expectedCount;
    h = h * 17 + unexpectedCount;
    return h;
  }
  
  /**
   * Prints immutable value {@code MessageCount{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MessageCount")
        .add("expectedCount", expectedCount)
        .add("unexpectedCount", unexpectedCount)
        .toString();
  }
  
  @JsonCreator
  public static MessageCount fromAllAttributes(
      @JsonProperty("expectedCount") @Nullable Integer expectedCount,
      @JsonProperty("unexpectedCount") @Nullable Integer unexpectedCount) {
    MessageCount.Builder builder = MessageCount.builder();
    if (expectedCount != null) {
      builder.expectedCount(expectedCount);
    }
    if (unexpectedCount != null) {
      builder.unexpectedCount(unexpectedCount);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code MessageCount} instance.
   * @param expectedCount value for {@code expectedCount}
   * @param unexpectedCount value for {@code unexpectedCount}
   * @return immutable MessageCount instance
   */
  public static org.glowroot.common.MessageCount of(int expectedCount, int unexpectedCount) {
    return new MessageCount(expectedCount, unexpectedCount);
  }
  
  /**
   * Creates immutable copy of {@link SpyingLogbackFilter.MessageCountBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MessageCount instance
   */
  public static MessageCount copyOf(SpyingLogbackFilter.MessageCountBase instance) {
    if (instance instanceof MessageCount) {
      return (MessageCount) instance;
    }
    return MessageCount.builder()
        .expectedCount(instance.expectedCount())
        .unexpectedCount(instance.unexpectedCount())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.common.MessageCount}.
   * @return new MessageCount builder
   */
  public static MessageCount.Builder builder() {
    return new MessageCount.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.common.MessageCount}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_EXPECTED_COUNT = 0x1L;
    private static final long INITIALIZED_BIT_UNEXPECTED_COUNT = 0x2L;
    private long initializedBitset;
  
    private int expectedCount;
    private int unexpectedCount;
    private Builder() {}
  
    /**
     * Initializes value for {@link SpyingLogbackFilter.MessageCountBase#expectedCount() expectedCount}.
     * @param expectedCount value for expectedCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder expectedCount(int expectedCount) {
      checkNotIsSet(expectedCountIsSet(), "expectedCount");
      this.expectedCount = expectedCount;
      initializedBitset |= INITIALIZED_BIT_EXPECTED_COUNT;
      return this;
    }
  
    /**
     * Initializes value for {@link SpyingLogbackFilter.MessageCountBase#unexpectedCount() unexpectedCount}.
     * @param unexpectedCount value for unexpectedCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder unexpectedCount(int unexpectedCount) {
      checkNotIsSet(unexpectedCountIsSet(), "unexpectedCount");
      this.unexpectedCount = unexpectedCount;
      initializedBitset |= INITIALIZED_BIT_UNEXPECTED_COUNT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.common.MessageCount}.
     * @return immutable instance of MessageCount
     */
    public MessageCount build() {
      checkRequiredAttributes();
      return new MessageCount(expectedCount, unexpectedCount);
    }
  
    private boolean expectedCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_EXPECTED_COUNT) != 0;
    }
  
    private boolean unexpectedCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_UNEXPECTED_COUNT) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of MessageCount is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!expectedCountIsSet()) {
        attributes.add("expectedCount");
      }
      if (!unexpectedCountIsSet()) {
        attributes.add("unexpectedCount");
      }
      return "Cannot build MessageCount, some of required attributes are not set " + attributes;
    }
  }
}
