package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GaugeConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GaugeConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugeConfigBase"})
@Immutable
public final class GaugeConfig extends GaugeConfigBase {
  private final String mbeanObjectName;
  private final ImmutableList<MBeanAttribute> mbeanAttributes;
  private final String version;

  private GaugeConfig(
      String mbeanObjectName,
      ImmutableList<MBeanAttribute> mbeanAttributes) {
    this.mbeanObjectName = mbeanObjectName;
    this.mbeanAttributes = mbeanAttributes;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanObjectName} attribute
   */
  @JsonProperty("mbeanObjectName")
  @Override
  public String mbeanObjectName() {
    return mbeanObjectName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanAttributes} attribute
   */
  @JsonProperty("mbeanAttributes")
  @Override
  public ImmutableList<MBeanAttribute> mbeanAttributes() {
    return mbeanAttributes;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeConfigBase#mbeanObjectName() mbeanObjectName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for mbeanObjectName
   * @return modified copy of the {@code this} object
   */
  public final GaugeConfig withMbeanObjectName(String value) {
    if (this.mbeanObjectName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new GaugeConfig(newValue, this.mbeanAttributes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeConfigBase#mbeanAttributes() mbeanAttributes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugeConfig withMbeanAttributes(MBeanAttribute... elements) {
    ImmutableList<MBeanAttribute> newValue = ImmutableList.copyOf(elements);
    return new GaugeConfig(this.mbeanObjectName, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeConfigBase#mbeanAttributes() mbeanAttributes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of mbeanAttributes elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugeConfig withMbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
    if (this.mbeanAttributes == elements) {
      return this;
    }
    ImmutableList<MBeanAttribute> newValue = ImmutableList.copyOf(elements);
    return new GaugeConfig(this.mbeanObjectName, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GaugeConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GaugeConfig && equalTo((GaugeConfig) another));
  }
  
  private boolean equalTo(GaugeConfig another) {
    return mbeanObjectName.equals(another.mbeanObjectName)
        && mbeanAttributes.equals(another.mbeanAttributes)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code mbeanObjectName}, {@code mbeanAttributes}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + mbeanObjectName.hashCode();
    h = h * 17 + mbeanAttributes.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code GaugeConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GaugeConfig")
        .add("mbeanObjectName", mbeanObjectName)
        .add("mbeanAttributes", mbeanAttributes)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static GaugeConfig fromAllAttributes(
      @JsonProperty("mbeanObjectName") @Nullable String mbeanObjectName,
      @JsonProperty("mbeanAttributes") @Nullable ImmutableList<MBeanAttribute> mbeanAttributes) {
    GaugeConfig.Builder builder = GaugeConfig.builder();
    if (mbeanObjectName != null) {
      builder.mbeanObjectName(mbeanObjectName);
    }
    if (mbeanAttributes != null) {
      builder.addAllMbeanAttributes(mbeanAttributes);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link GaugeConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable GaugeConfig instance
   */
  public static GaugeConfig copyOf(GaugeConfigBase instance) {
    if (instance instanceof GaugeConfig) {
      return (GaugeConfig) instance;
    }
    return GaugeConfig.builder()
        .mbeanObjectName(instance.mbeanObjectName())
        .addAllMbeanAttributes(instance.mbeanAttributes())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.GaugeConfig}.
   * @return new GaugeConfig builder
   */
  public static GaugeConfig.Builder builder() {
    return new GaugeConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.GaugeConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_MBEAN_OBJECT_NAME = 0x1L;
    private long initializedBitset;
  
    private @Nullable String mbeanObjectName;
    private ImmutableList.Builder<MBeanAttribute> mbeanAttributesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link GaugeConfigBase#mbeanObjectName() mbeanObjectName}.
     * @param mbeanObjectName value for mbeanObjectName
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanObjectName(String mbeanObjectName) {
      checkNotIsSet(mbeanObjectNameIsSet(), "mbeanObjectName");
      this.mbeanObjectName = Preconditions.checkNotNull(mbeanObjectName);
      initializedBitset |= INITIALIZED_BIT_MBEAN_OBJECT_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link GaugeConfigBase#mbeanAttributes() mbeanAttributes} list.
     * @param element mbeanAttributes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMbeanAttributes(MBeanAttribute element) {
      mbeanAttributesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link GaugeConfigBase#mbeanAttributes() mbeanAttributes} list.
     * @param elements array of mbeanAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMbeanAttributes(MBeanAttribute... elements) {
      mbeanAttributesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link GaugeConfigBase#mbeanAttributes() mbeanAttributes} list.
     * @param elements iterable of mbeanAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
      mbeanAttributesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.GaugeConfig}.
     * @return immutable instance of GaugeConfig
     */
    public GaugeConfig build() {
      checkRequiredAttributes();
      return new GaugeConfig(mbeanObjectName, mbeanAttributesBuilder.build());
    }
  
    private boolean mbeanObjectNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MBEAN_OBJECT_NAME) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of GaugeConfig is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!mbeanObjectNameIsSet()) {
        attributes.add("mbeanObjectName");
      }
      return "Cannot build GaugeConfig, some of required attributes are not set " + attributes;
    }
  }
}
