package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GaugeConfigBase.MBeanAttributeBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MBeanAttribute.builder()}.
 * Use static factory method to create immutable instances:
 * {@code MBeanAttribute.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugeConfigBase.MBeanAttributeBase"})
@Immutable
public final class MBeanAttribute extends GaugeConfigBase.MBeanAttributeBase {
  private final String name;
  private final boolean everIncreasing;

  private MBeanAttribute(String name, boolean everIncreasing) {
    this.name = name;
    this.everIncreasing = everIncreasing;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code everIncreasing} attribute
   */
  @JsonProperty("everIncreasing")
  @Override
  public boolean everIncreasing() {
    return everIncreasing;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeConfigBase.MBeanAttributeBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final MBeanAttribute withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MBeanAttribute(newValue, this.everIncreasing);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeConfigBase.MBeanAttributeBase#everIncreasing() everIncreasing}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for everIncreasing
   * @return modified copy of the {@code this} object
   */
  public final MBeanAttribute withEverIncreasing(boolean value) {
    if (this.everIncreasing == value) {
      return this;
    }
    boolean newValue = value;
    return new MBeanAttribute(this.name, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MBeanAttribute} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MBeanAttribute && equalTo((MBeanAttribute) another));
  }
  
  private boolean equalTo(MBeanAttribute another) {
    return name.equals(another.name)
        && everIncreasing == another.everIncreasing;
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code everIncreasing}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Booleans.hashCode(everIncreasing);
    return h;
  }
  
  /**
   * Prints immutable value {@code MBeanAttribute{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MBeanAttribute")
        .add("name", name)
        .add("everIncreasing", everIncreasing)
        .toString();
  }
  
  @JsonCreator
  public static MBeanAttribute fromAllAttributes(
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("everIncreasing") @Nullable Boolean everIncreasing) {
    MBeanAttribute.Builder builder = MBeanAttribute.builder();
    if (name != null) {
      builder.name(name);
    }
    if (everIncreasing != null) {
      builder.everIncreasing(everIncreasing);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code MBeanAttribute} instance.
   * @param name value for {@code name}
   * @param everIncreasing value for {@code everIncreasing}
   * @return immutable MBeanAttribute instance
   */
  public static org.glowroot.config.MBeanAttribute of(String name, boolean everIncreasing) {
    return new MBeanAttribute(name, everIncreasing);
  }
  
  /**
   * Creates immutable copy of {@link GaugeConfigBase.MBeanAttributeBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MBeanAttribute instance
   */
  public static MBeanAttribute copyOf(GaugeConfigBase.MBeanAttributeBase instance) {
    if (instance instanceof MBeanAttribute) {
      return (MBeanAttribute) instance;
    }
    return MBeanAttribute.builder()
        .name(instance.name())
        .everIncreasing(instance.everIncreasing())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.MBeanAttribute}.
   * @return new MBeanAttribute builder
   */
  public static MBeanAttribute.Builder builder() {
    return new MBeanAttribute.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.MBeanAttribute}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_EVER_INCREASING = 0x2L;
    private long initializedBitset;
  
    private @Nullable String name;
    private boolean everIncreasing;
    private Builder() {}
  
    /**
     * Initializes value for {@link GaugeConfigBase.MBeanAttributeBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeConfigBase.MBeanAttributeBase#everIncreasing() everIncreasing}.
     * @param everIncreasing value for everIncreasing
     * @return {@code this} builder for chained invocation
     */
    public final Builder everIncreasing(boolean everIncreasing) {
      checkNotIsSet(everIncreasingIsSet(), "everIncreasing");
      this.everIncreasing = everIncreasing;
      initializedBitset |= INITIALIZED_BIT_EVER_INCREASING;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.MBeanAttribute}.
     * @return immutable instance of MBeanAttribute
     */
    public MBeanAttribute build() {
      checkRequiredAttributes();
      return new MBeanAttribute(name, everIncreasing);
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean everIncreasingIsSet() {
      return (initializedBitset & INITIALIZED_BIT_EVER_INCREASING) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of MBeanAttribute is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!everIncreasingIsSet()) {
        attributes.add("everIncreasing");
      }
      return "Cannot build MBeanAttribute, some of required attributes are not set " + attributes;
    }
  }
}
