package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PluginConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PluginConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PluginConfigBase"})
@Immutable
public final class PluginConfig extends PluginConfigBase {
  private final String id;
  private final boolean enabled;
  private final ImmutableMap<String, PropertyValue> properties;
  private final ImmutableMap<String, Boolean> booleanProperties;
  private final ImmutableMap<String, String> stringProperties;
  private final ImmutableMap<String, Optional<Double>> doubleProperties;
  private final String version;

  private PluginConfig(PluginConfig.Builder builder) {
    this.id = builder.id;
    this.properties = builder.propertiesBuilder.build();
    this.enabled = builder.enabledIsSet()
        ? builder.enabled
        : super.enabled();
    this.booleanProperties = Preconditions.checkNotNull(super.booleanProperties());
    this.stringProperties = Preconditions.checkNotNull(super.stringProperties());
    this.doubleProperties = Preconditions.checkNotNull(super.doubleProperties());
    this.version = Preconditions.checkNotNull(super.version());
  }

  private PluginConfig(
      String id,
      boolean enabled,
      ImmutableMap<String, PropertyValue> properties) {
    this.id = id;
    this.enabled = enabled;
    this.properties = properties;
    this.booleanProperties = Preconditions.checkNotNull(super.booleanProperties());
    this.stringProperties = Preconditions.checkNotNull(super.stringProperties());
    this.doubleProperties = Preconditions.checkNotNull(super.doubleProperties());
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public boolean enabled() {
    return enabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public ImmutableMap<String, PropertyValue> properties() {
    return properties;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code booleanProperties} attribute
   */
  @JsonIgnore
  @JsonProperty("booleanProperties")
  @Override
  public ImmutableMap<String, Boolean> booleanProperties() {
    return booleanProperties;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code stringProperties} attribute
   */
  @JsonIgnore
  @JsonProperty("stringProperties")
  @Override
  public ImmutableMap<String, String> stringProperties() {
    return stringProperties;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code doubleProperties} attribute
   */
  @JsonIgnore
  @JsonProperty("doubleProperties")
  @Override
  public ImmutableMap<String, Optional<Double>> doubleProperties() {
    return doubleProperties;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link PluginConfigBase#id() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final PluginConfig withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PluginConfig(newValue, this.enabled, this.properties);
  }
  
  /**
   * Copy current immutable object by setting value for {@link PluginConfigBase#enabled() enabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enabled
   * @return modified copy of the {@code this} object
   */
  public final PluginConfig withEnabled(boolean value) {
    if (this.enabled == value) {
      return this;
    }
    boolean newValue = value;
    return new PluginConfig(this.id, newValue, this.properties);
  }
  
  /**
   * Copy current immutable object by replacing {@link PluginConfigBase#properties() properties} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to properties map
   * @return modified copy of {@code this} object
   */
  public final PluginConfig withProperties(Map<String, ? extends PropertyValue> entries) {
    if (this.properties == entries) {
      return this;
    }
    ImmutableMap<String, PropertyValue> newValue = ImmutableMap.copyOf(entries);
    return new PluginConfig(this.id, this.enabled, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PluginConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PluginConfig && equalTo((PluginConfig) another));
  }
  
  private boolean equalTo(PluginConfig another) {
    return id.equals(another.id)
        && enabled == another.enabled
        && properties.equals(another.properties)
        && booleanProperties.equals(another.booleanProperties)
        && stringProperties.equals(another.stringProperties)
        && doubleProperties.equals(another.doubleProperties)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code id}, {@code enabled}, {@code properties}, {@code booleanProperties}, {@code stringProperties}, {@code doubleProperties}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + Booleans.hashCode(enabled);
    h = h * 17 + properties.hashCode();
    h = h * 17 + booleanProperties.hashCode();
    h = h * 17 + stringProperties.hashCode();
    h = h * 17 + doubleProperties.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code PluginConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PluginConfig")
        .add("id", id)
        .add("enabled", enabled)
        .add("properties", properties)
        .add("booleanProperties", booleanProperties)
        .add("stringProperties", stringProperties)
        .add("doubleProperties", doubleProperties)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static PluginConfig fromAllAttributes(
      @JsonProperty("id") @Nullable String id,
      @JsonProperty("enabled") @Nullable Boolean enabled,
      @JsonProperty("properties") @Nullable Map<String, PropertyValue> properties) {
    PluginConfig.Builder builder = PluginConfig.builder();
    if (id != null) {
      builder.id(id);
    }
    if (enabled != null) {
      builder.enabled(enabled);
    }
    if (properties != null) {
      builder.putAllProperties(properties);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link PluginConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable PluginConfig instance
   */
  public static PluginConfig copyOf(PluginConfigBase instance) {
    if (instance instanceof PluginConfig) {
      return (PluginConfig) instance;
    }
    return PluginConfig.builder()
        .id(instance.id())
        .enabled(instance.enabled())
        .putAllProperties(instance.properties())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.PluginConfig}.
   * @return new PluginConfig builder
   */
  public static PluginConfig.Builder builder() {
    return new PluginConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.PluginConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_ID = 0x1L;
    private static final long NONDEFAULT_BIT_ENABLED = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String id;
    private boolean enabled;
    private ImmutableMap.Builder<String, PropertyValue> propertiesBuilder = ImmutableMap.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link PluginConfigBase#id() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      checkNotIsSet(idIsSet(), "id");
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Initializes value for {@link PluginConfigBase#enabled() enabled}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link PluginConfigBase#enabled() enabled}.</em>
     * @param enabled value for enabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabled(boolean enabled) {
      checkNotIsSet(enabledIsSet(), "enabled");
      this.enabled = enabled;
      nondefaultBitset |= NONDEFAULT_BIT_ENABLED;
      return this;
    }
  
    /**
     * Put one entry to {@link PluginConfigBase#properties() properties} map.
     * @param key the key in properties map
     * @param value the associated value in properties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putProperties(String key, PropertyValue value) {
      propertiesBuilder.put(key, value);
      return this;
    }
  
    /**
     * Put one entry to {@link PluginConfigBase#properties() properties} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putProperties(Map.Entry<String, ? extends PropertyValue> entry) {
      propertiesBuilder.put(entry);
      return this;
    }
  
    /**
     * Put all mappings from specified map as entries to {@link PluginConfigBase#properties() properties} map. Nulls are not permitted
     * @param entries to be added to properties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllProperties(Map<String, ? extends PropertyValue> entries) {
      propertiesBuilder.putAll(entries);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.PluginConfig}.
     * @return immutable instance of PluginConfig
     */
    public PluginConfig build() {
      checkRequiredAttributes();
      return new PluginConfig(this);
    }
  
    private boolean enabledIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ENABLED) != 0;
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of PluginConfig is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!idIsSet()) {
        attributes.add("id");
      }
      return "Cannot build PluginConfig, some of required attributes are not set " + attributes;
    }
  }
}
