package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link RollupConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code RollupConfig.builder()}.
 * Use static factory method to create immutable instances:
 * {@code RollupConfig.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "RollupConfigBase"})
@Immutable
public final class RollupConfig extends RollupConfigBase {
  private final long intervalMillis;
  private final long viewThresholdMillis;

  private RollupConfig(long intervalMillis, long viewThresholdMillis) {
    this.intervalMillis = intervalMillis;
    this.viewThresholdMillis = viewThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code intervalMillis} attribute
   */
  @JsonProperty("intervalMillis")
  @Override
  public long intervalMillis() {
    return intervalMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code viewThresholdMillis} attribute
   */
  @JsonProperty("viewThresholdMillis")
  @Override
  public long viewThresholdMillis() {
    return viewThresholdMillis;
  }
  
  /**
   * Copy current immutable object by setting value for {@link RollupConfigBase#intervalMillis() intervalMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for intervalMillis
   * @return modified copy of the {@code this} object
   */
  public final RollupConfig withIntervalMillis(long value) {
    if (this.intervalMillis == value) {
      return this;
    }
    long newValue = value;
    return new RollupConfig(newValue, this.viewThresholdMillis);
  }
  
  /**
   * Copy current immutable object by setting value for {@link RollupConfigBase#viewThresholdMillis() viewThresholdMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for viewThresholdMillis
   * @return modified copy of the {@code this} object
   */
  public final RollupConfig withViewThresholdMillis(long value) {
    if (this.viewThresholdMillis == value) {
      return this;
    }
    long newValue = value;
    return new RollupConfig(this.intervalMillis, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code RollupConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof RollupConfig && equalTo((RollupConfig) another));
  }
  
  private boolean equalTo(RollupConfig another) {
    return intervalMillis == another.intervalMillis
        && viewThresholdMillis == another.viewThresholdMillis;
  }
  
  /**
   * Computes hash code from attributes: {@code intervalMillis}, {@code viewThresholdMillis}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(intervalMillis);
    h = h * 17 + Longs.hashCode(viewThresholdMillis);
    return h;
  }
  
  /**
   * Prints immutable value {@code RollupConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RollupConfig")
        .add("intervalMillis", intervalMillis)
        .add("viewThresholdMillis", viewThresholdMillis)
        .toString();
  }
  
  @JsonCreator
  public static RollupConfig fromAllAttributes(
      @JsonProperty("intervalMillis") @Nullable Long intervalMillis,
      @JsonProperty("viewThresholdMillis") @Nullable Long viewThresholdMillis) {
    RollupConfig.Builder builder = RollupConfig.builder();
    if (intervalMillis != null) {
      builder.intervalMillis(intervalMillis);
    }
    if (viewThresholdMillis != null) {
      builder.viewThresholdMillis(viewThresholdMillis);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code RollupConfig} instance.
   * @param intervalMillis value for {@code intervalMillis}
   * @param viewThresholdMillis value for {@code viewThresholdMillis}
   * @return immutable RollupConfig instance
   */
  public static org.glowroot.config.RollupConfig of(long intervalMillis, long viewThresholdMillis) {
    return new RollupConfig(intervalMillis, viewThresholdMillis);
  }
  
  /**
   * Creates immutable copy of {@link RollupConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable RollupConfig instance
   */
  public static RollupConfig copyOf(RollupConfigBase instance) {
    if (instance instanceof RollupConfig) {
      return (RollupConfig) instance;
    }
    return RollupConfig.builder()
        .intervalMillis(instance.intervalMillis())
        .viewThresholdMillis(instance.viewThresholdMillis())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.RollupConfig}.
   * @return new RollupConfig builder
   */
  public static RollupConfig.Builder builder() {
    return new RollupConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.RollupConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_INTERVAL_MILLIS = 0x1L;
    private static final long INITIALIZED_BIT_VIEW_THRESHOLD_MILLIS = 0x2L;
    private long initializedBitset;
  
    private long intervalMillis;
    private long viewThresholdMillis;
    private Builder() {}
  
    /**
     * Initializes value for {@link RollupConfigBase#intervalMillis() intervalMillis}.
     * @param intervalMillis value for intervalMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder intervalMillis(long intervalMillis) {
      checkNotIsSet(intervalMillisIsSet(), "intervalMillis");
      this.intervalMillis = intervalMillis;
      initializedBitset |= INITIALIZED_BIT_INTERVAL_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link RollupConfigBase#viewThresholdMillis() viewThresholdMillis}.
     * @param viewThresholdMillis value for viewThresholdMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder viewThresholdMillis(long viewThresholdMillis) {
      checkNotIsSet(viewThresholdMillisIsSet(), "viewThresholdMillis");
      this.viewThresholdMillis = viewThresholdMillis;
      initializedBitset |= INITIALIZED_BIT_VIEW_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.RollupConfig}.
     * @return immutable instance of RollupConfig
     */
    public RollupConfig build() {
      checkRequiredAttributes();
      return new RollupConfig(intervalMillis, viewThresholdMillis);
    }
  
    private boolean intervalMillisIsSet() {
      return (initializedBitset & INITIALIZED_BIT_INTERVAL_MILLIS) != 0;
    }
  
    private boolean viewThresholdMillisIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VIEW_THRESHOLD_MILLIS) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of RollupConfig is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!intervalMillisIsSet()) {
        attributes.add("intervalMillis");
      }
      if (!viewThresholdMillisIsSet()) {
        attributes.add("viewThresholdMillis");
      }
      return "Cannot build RollupConfig, some of required attributes are not set " + attributes;
    }
  }
}
