package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link StorageConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code StorageConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "StorageConfigBase"})
@Immutable
public final class StorageConfig extends StorageConfigBase {
  private final ImmutableList<Integer> rollupExpirationHours;
  private final int traceExpirationHours;
  private final ImmutableList<Integer> rollupCappedDatabaseSizesMb;
  private final int traceCappedDatabaseSizeMb;
  private final String version;

  private StorageConfig(StorageConfig.Builder builder) {
    this.rollupExpirationHours = builder.rollupExpirationHours != null
        ? builder.rollupExpirationHours
        : Preconditions.checkNotNull(super.rollupExpirationHours());
    this.traceExpirationHours = builder.traceExpirationHoursIsSet()
        ? builder.traceExpirationHours
        : super.traceExpirationHours();
    this.rollupCappedDatabaseSizesMb = builder.rollupCappedDatabaseSizesMb != null
        ? builder.rollupCappedDatabaseSizesMb
        : Preconditions.checkNotNull(super.rollupCappedDatabaseSizesMb());
    this.traceCappedDatabaseSizeMb = builder.traceCappedDatabaseSizeMbIsSet()
        ? builder.traceCappedDatabaseSizeMb
        : super.traceCappedDatabaseSizeMb();
    this.version = Preconditions.checkNotNull(super.version());
  }

  private StorageConfig(
      ImmutableList<Integer> rollupExpirationHours,
      int traceExpirationHours,
      ImmutableList<Integer> rollupCappedDatabaseSizesMb,
      int traceCappedDatabaseSizeMb) {
    this.rollupExpirationHours = rollupExpirationHours;
    this.traceExpirationHours = traceExpirationHours;
    this.rollupCappedDatabaseSizesMb = rollupCappedDatabaseSizesMb;
    this.traceCappedDatabaseSizeMb = traceCappedDatabaseSizeMb;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rollupExpirationHours} attribute
   */
  @JsonProperty("rollupExpirationHours")
  @Override
  public ImmutableList<Integer> rollupExpirationHours() {
    return rollupExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceExpirationHours} attribute
   */
  @JsonProperty("traceExpirationHours")
  @Override
  public int traceExpirationHours() {
    return traceExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rollupCappedDatabaseSizesMb} attribute
   */
  @JsonProperty("rollupCappedDatabaseSizesMb")
  @Override
  public ImmutableList<Integer> rollupCappedDatabaseSizesMb() {
    return rollupCappedDatabaseSizesMb;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceCappedDatabaseSizeMb} attribute
   */
  @JsonProperty("traceCappedDatabaseSizeMb")
  @Override
  public int traceCappedDatabaseSizeMb() {
    return traceCappedDatabaseSizeMb;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link StorageConfigBase#rollupExpirationHours() rollupExpirationHours}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for rollupExpirationHours
   * @return modified copy of the {@code this} object
   */
  public final StorageConfig withRollupExpirationHours(ImmutableList<Integer> value) {
    if (this.rollupExpirationHours == value) {
      return this;
    }
    ImmutableList<Integer> newValue = Preconditions.checkNotNull(value);
    return new StorageConfig(
        newValue,
        this.traceExpirationHours,
        this.rollupCappedDatabaseSizesMb,
        this.traceCappedDatabaseSizeMb);
  }
  
  /**
   * Copy current immutable object by setting value for {@link StorageConfigBase#traceExpirationHours() traceExpirationHours}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceExpirationHours
   * @return modified copy of the {@code this} object
   */
  public final StorageConfig withTraceExpirationHours(int value) {
    if (this.traceExpirationHours == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfig(
        this.rollupExpirationHours,
        newValue,
        this.rollupCappedDatabaseSizesMb,
        this.traceCappedDatabaseSizeMb);
  }
  
  /**
   * Copy current immutable object by setting value for {@link StorageConfigBase#rollupCappedDatabaseSizesMb() rollupCappedDatabaseSizesMb}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for rollupCappedDatabaseSizesMb
   * @return modified copy of the {@code this} object
   */
  public final StorageConfig withRollupCappedDatabaseSizesMb(ImmutableList<Integer> value) {
    if (this.rollupCappedDatabaseSizesMb == value) {
      return this;
    }
    ImmutableList<Integer> newValue = Preconditions.checkNotNull(value);
    return new StorageConfig(this.rollupExpirationHours, this.traceExpirationHours, newValue, this.traceCappedDatabaseSizeMb);
  }
  
  /**
   * Copy current immutable object by setting value for {@link StorageConfigBase#traceCappedDatabaseSizeMb() traceCappedDatabaseSizeMb}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceCappedDatabaseSizeMb
   * @return modified copy of the {@code this} object
   */
  public final StorageConfig withTraceCappedDatabaseSizeMb(int value) {
    if (this.traceCappedDatabaseSizeMb == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfig(this.rollupExpirationHours, this.traceExpirationHours, this.rollupCappedDatabaseSizesMb, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code StorageConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof StorageConfig && equalTo((StorageConfig) another));
  }
  
  private boolean equalTo(StorageConfig another) {
    return rollupExpirationHours.equals(another.rollupExpirationHours)
        && traceExpirationHours == another.traceExpirationHours
        && rollupCappedDatabaseSizesMb.equals(another.rollupCappedDatabaseSizesMb)
        && traceCappedDatabaseSizeMb == another.traceCappedDatabaseSizeMb
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code rollupExpirationHours}, {@code traceExpirationHours}, {@code rollupCappedDatabaseSizesMb}, {@code traceCappedDatabaseSizeMb}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + rollupExpirationHours.hashCode();
    h = h * 17 + traceExpirationHours;
    h = h * 17 + rollupCappedDatabaseSizesMb.hashCode();
    h = h * 17 + traceCappedDatabaseSizeMb;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code StorageConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StorageConfig")
        .add("rollupExpirationHours", rollupExpirationHours)
        .add("traceExpirationHours", traceExpirationHours)
        .add("rollupCappedDatabaseSizesMb", rollupCappedDatabaseSizesMb)
        .add("traceCappedDatabaseSizeMb", traceCappedDatabaseSizeMb)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static StorageConfig fromAllAttributes(
      @JsonProperty("rollupExpirationHours") @Nullable ImmutableList<Integer> rollupExpirationHours,
      @JsonProperty("traceExpirationHours") @Nullable Integer traceExpirationHours,
      @JsonProperty("rollupCappedDatabaseSizesMb") @Nullable ImmutableList<Integer> rollupCappedDatabaseSizesMb,
      @JsonProperty("traceCappedDatabaseSizeMb") @Nullable Integer traceCappedDatabaseSizeMb) {
    StorageConfig.Builder builder = StorageConfig.builder();
    if (rollupExpirationHours != null) {
      builder.rollupExpirationHours(rollupExpirationHours);
    }
    if (traceExpirationHours != null) {
      builder.traceExpirationHours(traceExpirationHours);
    }
    if (rollupCappedDatabaseSizesMb != null) {
      builder.rollupCappedDatabaseSizesMb(rollupCappedDatabaseSizesMb);
    }
    if (traceCappedDatabaseSizeMb != null) {
      builder.traceCappedDatabaseSizeMb(traceCappedDatabaseSizeMb);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link StorageConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable StorageConfig instance
   */
  public static StorageConfig copyOf(StorageConfigBase instance) {
    if (instance instanceof StorageConfig) {
      return (StorageConfig) instance;
    }
    return StorageConfig.builder()
        .rollupExpirationHours(instance.rollupExpirationHours())
        .traceExpirationHours(instance.traceExpirationHours())
        .rollupCappedDatabaseSizesMb(instance.rollupCappedDatabaseSizesMb())
        .traceCappedDatabaseSizeMb(instance.traceCappedDatabaseSizeMb())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.StorageConfig}.
   * @return new StorageConfig builder
   */
  public static StorageConfig.Builder builder() {
    return new StorageConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.StorageConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_ROLLUP_EXPIRATION_HOURS = 0x1L;
    private static final long NONDEFAULT_BIT_TRACE_EXPIRATION_HOURS = 0x2L;
    private static final long NONDEFAULT_BIT_ROLLUP_CAPPED_DATABASE_SIZES_MB = 0x4L;
    private static final long NONDEFAULT_BIT_TRACE_CAPPED_DATABASE_SIZE_MB = 0x8L;
    private long nondefaultBitset;
  
    private @Nullable ImmutableList<Integer> rollupExpirationHours;
    private int traceExpirationHours;
    private @Nullable ImmutableList<Integer> rollupCappedDatabaseSizesMb;
    private int traceCappedDatabaseSizeMb;
    private Builder() {}
  
    /**
     * Initializes value for {@link StorageConfigBase#rollupExpirationHours() rollupExpirationHours}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link StorageConfigBase#rollupExpirationHours() rollupExpirationHours}.</em>
     * @param rollupExpirationHours value for rollupExpirationHours
     * @return {@code this} builder for chained invocation
     */
    public final Builder rollupExpirationHours(ImmutableList<Integer> rollupExpirationHours) {
      checkNotIsSet(rollupExpirationHoursIsSet(), "rollupExpirationHours");
      this.rollupExpirationHours = Preconditions.checkNotNull(rollupExpirationHours);
      nondefaultBitset |= NONDEFAULT_BIT_ROLLUP_EXPIRATION_HOURS;
      return this;
    }
  
    /**
     * Initializes value for {@link StorageConfigBase#traceExpirationHours() traceExpirationHours}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link StorageConfigBase#traceExpirationHours() traceExpirationHours}.</em>
     * @param traceExpirationHours value for traceExpirationHours
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceExpirationHours(int traceExpirationHours) {
      checkNotIsSet(traceExpirationHoursIsSet(), "traceExpirationHours");
      this.traceExpirationHours = traceExpirationHours;
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_EXPIRATION_HOURS;
      return this;
    }
  
    /**
     * Initializes value for {@link StorageConfigBase#rollupCappedDatabaseSizesMb() rollupCappedDatabaseSizesMb}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link StorageConfigBase#rollupCappedDatabaseSizesMb() rollupCappedDatabaseSizesMb}.</em>
     * @param rollupCappedDatabaseSizesMb value for rollupCappedDatabaseSizesMb
     * @return {@code this} builder for chained invocation
     */
    public final Builder rollupCappedDatabaseSizesMb(ImmutableList<Integer> rollupCappedDatabaseSizesMb) {
      checkNotIsSet(rollupCappedDatabaseSizesMbIsSet(), "rollupCappedDatabaseSizesMb");
      this.rollupCappedDatabaseSizesMb = Preconditions.checkNotNull(rollupCappedDatabaseSizesMb);
      nondefaultBitset |= NONDEFAULT_BIT_ROLLUP_CAPPED_DATABASE_SIZES_MB;
      return this;
    }
  
    /**
     * Initializes value for {@link StorageConfigBase#traceCappedDatabaseSizeMb() traceCappedDatabaseSizeMb}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link StorageConfigBase#traceCappedDatabaseSizeMb() traceCappedDatabaseSizeMb}.</em>
     * @param traceCappedDatabaseSizeMb value for traceCappedDatabaseSizeMb
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceCappedDatabaseSizeMb(int traceCappedDatabaseSizeMb) {
      checkNotIsSet(traceCappedDatabaseSizeMbIsSet(), "traceCappedDatabaseSizeMb");
      this.traceCappedDatabaseSizeMb = traceCappedDatabaseSizeMb;
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_CAPPED_DATABASE_SIZE_MB;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.StorageConfig}.
     * @return immutable instance of StorageConfig
     */
    public StorageConfig build() {
      return new StorageConfig(this);
    }
  
    private boolean rollupExpirationHoursIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ROLLUP_EXPIRATION_HOURS) != 0;
    }
  
    private boolean traceExpirationHoursIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_EXPIRATION_HOURS) != 0;
    }
  
    private boolean rollupCappedDatabaseSizesMbIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ROLLUP_CAPPED_DATABASE_SIZES_MB) != 0;
    }
  
    private boolean traceCappedDatabaseSizeMbIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_CAPPED_DATABASE_SIZE_MB) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of StorageConfig is strict, attribute is already set: ".concat(name));
      }
    }
  }
}
